/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.pab.dc.service.receipt;

import com.jcraft.jsch.ChannelSftp;
import java.io.File;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.banks.pab.dc.service.receipt.PABDCCommConfig;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.business.receipt.utils.BankReceiptApiUtil;
import kd.ebg.receipt.common.constant.UploadStatusEnum;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.core.utils.ErrorMsgUtil;
import kd.ebg.receipt.common.core.utils.GZFileUtils;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.bank.BankFtpProperties;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.framework.receipt.util.SFTPUtils;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.framework.services.receipt.EBCReceiptInfoJsonService;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class BankReceiptDownloadImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptDownloadImpl.class);
    public DownloadListDetailService downloadListDetailService;
    public EBCReceiptInfoJsonService receiptInfoJsonService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
        this.receiptInfoJsonService = (EBCReceiptInfoJsonService)SpringContextUtil.getBean(EBCReceiptInfoJsonService.class);
    }

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.DOWNLOADING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        this.init(request);
        long taskId = request.getTaskId();
        String bankLogin = EBContext.getContext().getBankLoginID();
        List downloadListDetails = this.downloadListDetailService.selectByRefId(Long.valueOf(taskId));
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(16);
        BankFtpProperties bankFtpProperties = (BankFtpProperties)EBConfigBuilder.getInstance().buildConfig(BankFtpProperties.class, bankLogin);
        PABDCCommConfig config = (PABDCCommConfig)EBConfigBuilder.getInstance().buildConfig(PABDCCommConfig.class, bankLogin);
        String transCode = config.getQueryReceiptInt();
        boolean isZipModel = false;
        ArrayList<Long> deleteId = new ArrayList<Long>(1);
        if (!Objects.equals(transCode, "ELC009") && request.getTransDate().isBefore(LocalDate.now())) {
            isZipModel = true;
        }
        if (request.getTransDate().minusDays(-15L).isBefore(LocalDate.now())) {
            isZipModel = false;
        }
        ChannelSftp sftp = null;
        if (bankFtpProperties.getReceiptAchieveWay().equals("sftp")) {
            sftp = SFTPUtils.getInstance().getSftp(bankLogin);
        }
        boolean isLastFile = false;
        for (int i = 0; i < downloadListDetails.size(); ++i) {
            DownloadListDetail downloadListDetail;
            if (i == downloadListDetails.size() - 1) {
                isLastFile = true;
            }
            if ((downloadListDetail = (DownloadListDetail)downloadListDetails.get(i)).getUploadFlag().intValue() == UploadStatusEnum.UPLOAD_SUCCESS.getId()) {
                if (isZipModel) {
                    deleteId.add(downloadListDetail.getId());
                    continue;
                }
                result.add(downloadListDetail);
                continue;
            }
            if (isZipModel && downloadListDetail.getFileName().contains(".pdf")) {
                deleteId.add(downloadListDetail.getId());
                continue;
            }
            if (!downloadListDetail.getFileName().contains(".zip") && !downloadListDetail.getFileName().contains(".rar") && !downloadListDetail.getFileName().contains(".pdf")) continue;
            try {
                List<DownloadListDetail> details = this.download(downloadListDetail, bankFtpProperties, sftp, isLastFile, transCode);
                result.addAll(details);
                continue;
            }
            catch (Throwable e) {
                logger.monitorError("pab_dc-download#error" + e.getMessage(), e);
                deleteId.add(downloadListDetail.getId());
            }
        }
        this.downloadListDetailService.deleteById(deleteId);
        return BankReceiptHandleResponseEB.success(result);
    }

    public List<DownloadListDetail> download(DownloadListDetail detail, BankFtpProperties bankFtpProperties, ChannelSftp sftp, boolean isLastFile, String transCode) {
        ArrayList<DownloadListDetail> result;
        block19: {
            result = new ArrayList<DownloadListDetail>(16);
            String bankLogin = EBContext.getContext().getBankLoginID();
            String accNo = detail.getAccNo();
            String bankVersionId = detail.getBankVersionId();
            LocalDate transDate = detail.getTransDate();
            String bakFilePath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)bankVersionId, (String)accNo, (String)LocalDateUtil.formatDate((LocalDate)transDate));
            detail.setBankFilePath(bakFilePath);
            String ftpPath = bankFtpProperties.getFtpPath();
            String filePath = bakFilePath + File.separator + detail.getFileName();
            boolean flag = false;
            try {
                File file = FileCommonUtils.getFileByPath((String)filePath);
                if (file.exists() && !file.isDirectory()) {
                    ArrayList<DownloadListDetail> arrayList = result;
                    return arrayList;
                }
                boolean isToday = detail.getTransDate().equals(LocalDate.now());
                String fileName = detail.getFileName();
                if (isToday || Objects.equals(transCode, "ELC009")) {
                    fileName = detail.getFileLink();
                }
                if (bankFtpProperties.getReceiptAchieveWay().equals("sftp")) {
                    if (SFTPUtils.getInstance().isAbort(sftp)) {
                        sftp = SFTPUtils.getInstance().getSftp(bankLogin);
                        ftpPath = bankFtpProperties.getFtpPath();
                        ftpPath = EBGStringUtils.isEmpty((String)ftpPath) ? "/" : ftpPath;
                    }
                    flag = SFTPUtils.getInstance().downloadSingleFile(ftpPath, fileName, bakFilePath, sftp);
                } else if (bankFtpProperties.getReceiptAchieveWay().equals("bank_login")) {
                    BankReceiptApiUtil bankReceiptApiUtil = new BankReceiptApiUtil(accNo, transDate);
                    flag = bankReceiptApiUtil.downloadReceiptFile(fileName, bakFilePath);
                }
                if (!flag) {
                    throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u56de\u5355\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff1a", (String)"BankReceiptDownloadImpl_0", (String)"ebg-receipt-banks-pab-dc", (Object[])new Object[0]), detail.getFileName()));
                }
                if (isToday || Objects.equals(transCode, "ELC009")) {
                    File sourceFile = FileCommonUtils.getFileByPath((String)(bakFilePath + File.separator + fileName));
                    FileCommonUtils.moveFile((File)sourceFile, (String)bakFilePath, (String)detail.getFileName());
                    result.add(detail);
                    ArrayList<DownloadListDetail> arrayList = result;
                    return arrayList;
                }
                String unZipDir = bakFilePath + File.separator + "temp";
                if (GZFileUtils.unZipFiles((String)(bakFilePath + File.separator + detail.getFileName()), (String)unZipDir)) {
                    RequestContextUtils.setZipName((String)detail.getFileName());
                    File unZipFile = FileCommonUtils.getFileByPath((String)unZipDir);
                    if (unZipFile.isDirectory() && unZipFile.exists()) {
                        for (File receiptFile : unZipFile.listFiles()) {
                            DownloadListDetail downloadListDetail = new DownloadListDetail();
                            downloadListDetail.setFileLink(receiptFile.getName());
                            downloadListDetail.setFileName(receiptFile.getName());
                            result.add(downloadListDetail);
                            FileCommonUtils.moveFile((File)receiptFile, (String)bakFilePath, (String)receiptFile.getName());
                        }
                        FileCommonUtils.getFileByPath((String)unZipDir).delete();
                        FileCommonUtils.getFileByPath((String)(bakFilePath + File.separator + detail.getFileName())).delete();
                        break block19;
                    }
                    throw new ReceiptException(ResManager.loadKDString((String)"\u56de\u5355\u6587\u4ef6\u4e0d\u5b58\u5728\u3002", (String)"BankReceiptDownloadImpl_1", (String)"ebg-receipt-banks-pab-dc", (Object[])new Object[0]));
                }
                throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u56de\u5355\u538b\u7f29\u6587\u4ef6[%s]\u89e3\u538b\u7f29\u5931\u8d25\u3002", (String)"BankReceiptDownloadImpl_5", (String)"ebg-receipt-banks-pab-dc", (Object[])new Object[0]), detail.getFileName()));
            }
            catch (Exception e) {
                String msg = ErrorMsgUtil.getSFTPErrorMSG((String)detail.getFileName(), (String)e.getMessage());
                throw new ReceiptException(msg, (Throwable)e);
            }
            finally {
                if (isLastFile) {
                    SFTPUtils.getInstance().close(sftp);
                }
            }
        }
        return result;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "PAB_DC_BankReceiptDownload";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5e73\u5b89\u94f6\u884c\u76f4\u8fde\u7248\u56de\u5355\u6587\u4ef6\u4e0b\u8f7d", (String)"BankReceiptDownloadImpl_4", (String)"ebg-receipt-banks-pab-dc", (Object[])new Object[0]);
    }
}

