/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.bochk.dc.service;

import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Stream;
import kd.ebg.receipt.banks.bochk.dc.service.receipt.DownloadFile;
import kd.ebg.receipt.banks.bochk.dc.service.utils.BOCHK_DC_Parser;
import kd.ebg.receipt.banks.bochk.dc.service.utils.ReceiptInfo;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.core.utils.GZFileUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.match.MatchRule;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.framework.services.receipt.EBCReceiptInfoJsonService;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class BankReceiptDownloadImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptDownloadImpl.class);
    public DownloadListDetailService downloadListDetailService;
    public EBCReceiptInfoJsonService receiptInfoJsonService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
        this.receiptInfoJsonService = (EBCReceiptInfoJsonService)SpringContextUtil.getBean(EBCReceiptInfoJsonService.class);
    }

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.DOWNLOADING.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        this.init(request);
        long taskId = request.getTaskId();
        String accNo = request.getAccNo();
        String bankVersionId = request.getBankVersionId();
        LocalDate transDate = request.getTransDate();
        String transDateStr = transDate.format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        List downloadListDetails = this.downloadListDetailService.selectByRefId(Long.valueOf(taskId));
        logger.info(">>>>>>>>>\u4e2d\u94f6\u9999\u6e2f-{}-{}-\u56de\u5355\u8bb0\u5f55\u6570\u91cf\uff1a{}", new Object[]{accNo, transDate, downloadListDetails.size()});
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(16);
        String bakFilePath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)bankVersionId, (String)accNo, (String)transDateStr);
        for (DownloadListDetail downloadListDetail : downloadListDetails) {
            String requestID = downloadListDetail.getFileLink();
            BankReceiptRequest req = BankReceiptRequest.builder().accNo(accNo).transDate(transDate).requestStr(requestID).build();
            BankReceiptResponseEB resp = new DownloadFile().doBiz(req);
            ReceiptInfo receiptInfo = (ReceiptInfo)resp.getData();
            String fileName = receiptInfo.getFileName();
            String fileContent = receiptInfo.getFileContent();
            if (fileName.toLowerCase(Locale.ENGLISH).endsWith(".pdf")) {
                logger.info("\u672c\u6b21\u8fd4\u56de\u7684\u662fPDF {}", (Object)fileName);
                BOCHK_DC_Parser.base64ToFile(fileContent, bakFilePath + File.separator + fileName);
                DownloadListDetail detail = new DownloadListDetail();
                String transRef = this.splitTransRef(fileName);
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("TransRef", (Object)transRef);
                String jsonStr = jsonObject.toJSONString();
                String receiptMatchNo = MatchRule.getInstance().getReceiptMatchNo(accNo, transDateStr, jsonStr);
                detail.setFileLink(fileName);
                detail.setFileName(fileName);
                detail.setDetailNo(receiptMatchNo);
                detail.setReceiptJson(jsonStr);
                result.add(detail);
            } else {
                String pdfPath = bakFilePath + File.separator + requestID;
                String zipPath = pdfPath + File.separator + fileName;
                File tempFile = FileCommonUtils.getFileByPath((String)pdfPath);
                if (!tempFile.exists() && !tempFile.mkdirs()) {
                    logger.info("\u521b\u5efa{}\u6587\u4ef6\u5939\u5931\u8d25", (Object)pdfPath);
                    continue;
                }
                if (BOCHK_DC_Parser.base64ToFile(fileContent, zipPath) && GZFileUtils.unZipFiles((String)zipPath, (String)pdfPath)) {
                    try (Stream<Path> paths = Files.walk(Paths.get(pdfPath, new String[0]), new FileVisitOption[0]);){
                        paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(Path::toFile).forEach(f -> {
                            if (!f.getName().endsWith(".zip") && FileCommonUtils.moveFile((File)f, (String)bakFilePath, (String)f.getName())) {
                                DownloadListDetail detail = new DownloadListDetail();
                                String transRef = this.splitTransRef(f.getName());
                                detail.setFileLink(f.getName());
                                detail.setFileName(f.getName());
                                JSONObject jsonObject = new JSONObject();
                                jsonObject.put("TransRef", (Object)transRef);
                                String jsonStr = jsonObject.toJSONString();
                                String receiptMatchNo = MatchRule.getInstance().getReceiptMatchNo(accNo, transDateStr, jsonStr);
                                detail.setDetailNo(receiptMatchNo);
                                detail.setReceiptJson(jsonStr);
                                result.add(detail);
                            }
                        });
                    }
                    catch (IOException e) {
                        logger.info("\u626b\u63cf\u6587\u4ef6\u5939{}\u5f02\u5e38", (Object)pdfPath);
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                    finally {
                        FileCommonUtils.deleteFile((String)zipPath);
                        FileCommonUtils.deleteAllFile((String)pdfPath);
                    }
                }
            }
            try {
                Thread.sleep(40000L);
            }
            catch (InterruptedException e) {
                logger.info("\u5904\u7406{}\u65f6\u7ebf\u7a0b\u88ab\u4e2d\u65ad", (Object)requestID);
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return BankReceiptHandleResponseEB.success(result);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "";
    }

    public String getBizDesc() {
        return "";
    }

    public String splitTransRef(String fileName) {
        fileName = fileName.replace(".pdf", "");
        String[] nameFields = fileName.split("_");
        return nameFields[nameFields.length - 1];
    }
}

