/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.bochk.dc.service.detail;

import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.bochk.dc.service.utils.BOCHK_DC_Packer;
import kd.ebg.receipt.banks.bochk.dc.service.utils.BOCHK_DC_Parser;
import kd.ebg.receipt.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.receipt.business.detail.atomic.IDetail;
import kd.ebg.receipt.business.detail.atomic.IHisDetail;
import kd.ebg.receipt.business.detail.bank.BankDetailRequest;
import kd.ebg.receipt.business.detail.bank.EBBankDetailResponse;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.model.DetailInfo;
import org.jdom2.Element;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    private static final EBGLogger log = EBGLogger.getInstance().getLogger(DetailImpl.class);

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "AcctActivityREQ";
    }

    public String getBizDesc() {
        return "";
    }

    public String pack(BankDetailRequest bankDetailRequest) {
        BankAcnt acnt = bankDetailRequest.getAcnt();
        Element BOCHKE2B = BOCHK_DC_Packer.createRootWithHead(BOCHK_DC_Packer.getPackageId());
        Element Tx = new Element("Tx");
        Element AcctActivityREQ = new Element("AcctActivityREQ");
        String accNo = acnt.getAccNo();
        JDomUtils.addChild((Element)AcctActivityREQ, (String)"AcctNo", (String)accNo);
        JDomUtils.addChild((Element)AcctActivityREQ, (String)"StartDate", (String)bankDetailRequest.getStartDate().format(DateTimeFormatter.ofPattern("yyyy/MM/dd")));
        JDomUtils.addChild((Element)AcctActivityREQ, (String)"EndDate", (String)bankDetailRequest.getEndDate().format(DateTimeFormatter.ofPattern("yyyy/MM/dd")));
        JDomUtils.addChild((Element)AcctActivityREQ, (String)"TransCur", (String)bankDetailRequest.getBankCurrency().toUpperCase());
        JDomUtils.addChild((Element)Tx, (Element)AcctActivityREQ);
        JDomUtils.addChild((Element)BOCHKE2B, (Element)Tx);
        String encoding = RequestContextUtils.getCharset();
        return JDomUtils.root2String((Element)BOCHKE2B, (String)encoding);
    }

    public EBBankDetailResponse parse(BankDetailRequest rqst, String s) {
        ArrayList<DetailInfo> detailList = new ArrayList<DetailInfo>(8);
        Element root = JDomUtils.string2Root((String)s, (String)RequestContextUtils.getCharset());
        BankResponse bankRsp = BOCHK_DC_Parser.parseHead(root);
        if (!"S".equals(bankRsp.getResponseCode())) {
            String ErrorCode = root.getChild("Head").getChild("ErrorCode").getTextTrim();
            String ErrorDesc = root.getChild("Head").getChild("ErrorDesc").getTextTrim();
            if (ErrorCode.equals("SP0400") || ErrorCode.equals("E11071") || ErrorDesc != null && ErrorDesc.startsWith("NO ACTIVITY FOUND")) {
                return new EBBankDetailResponse(detailList);
            }
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u8fd4\u56de\u7ed3\u679c\u4e3a(%1$s,%2$s);\u9519\u8bef\u7801\uff1a%3$s,\u9519\u8bef\u8bf4\u660e\uff1a%4$s", (String)"DetailImpl_0", (String)"ebg-receipt-banks-bochk-dc", (Object[])new Object[0]), bankRsp.getResponseCode(), bankRsp.getResponseMessage(), ErrorCode, ErrorDesc));
        }
        Element AcctActivityRLY = root.getChild("Tx").getChild("AcctActivityRLY");
        Element TransRecord = AcctActivityRLY.getChild("TransRecord");
        if (TransRecord == null) {
            return new EBBankDetailResponse(detailList);
        }
        Element result = TransRecord.getChild("Result");
        if (result == null) {
            return new EBBankDetailResponse(detailList);
        }
        List recordList = result.getChildren("Record");
        for (Element record : recordList) {
            String ref = record.getChildTextTrim("TransRef");
            if (StringUtils.isEmpty((String)ref)) continue;
            String tid = record.getChildTextTrim("TransId");
            DetailInfo detailInfo = new DetailInfo();
            detailInfo.setBizRefNo(ref);
            detailInfo.setId(tid);
            detailList.add(detailInfo);
        }
        return new EBBankDetailResponse(detailList);
    }

    public ConnectionFactory getConnectionFactory() {
        ConnectionFactory factory = super.getConnectionFactory();
        factory.setUri(RequestContextUtils.getBankParameterValue((String)"bankUrl"));
        factory.setHttpHeader("Content-Type", "application/xml;charset=" + RequestContextUtils.getCharset());
        return factory;
    }
}

