/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.fjhxb.dc.service;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.receipt.banks.fjhxb.dc.service.api.B2ESelfReceiptBatchPrn;
import kd.ebg.receipt.banks.fjhxb.dc.service.api.B2ESelfReceiptPrnQry;
import kd.ebg.receipt.banks.fjhxb.dc.service.api.DownloadFile;
import kd.ebg.receipt.banks.fjhxb.dc.service.api.ReceiptInfo;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;

public class BankReceiptFetchListImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptFetchListImpl.class);

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.PROCESSING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        String transDateStr = transDate.format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(16);
        logger.info("\u83b7\u53d6\u7535\u5b50\u56de\u5355\u8bf7\u6c42\u4fe1\u606f\uff1a\n accNo = " + accNo + " and transDate = " + transDate + "\n");
        String bakFilePath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)"FJHXB_DC", (String)accNo, (String)transDateStr);
        BankReceiptRequest bankReceiptRequest = this.buildReq(accNo, transDate);
        BankReceiptResponseEB receiptResponseEB = new B2ESelfReceiptPrnQry().doBiz(bankReceiptRequest);
        List receiptInfos = (List)receiptResponseEB.getData();
        for (ReceiptInfo receiptInfo : receiptInfos) {
            String fileName = receiptInfo.getMatchNo() + ".pdf";
            DownloadListDetail downloadListDetail = new DownloadListDetail();
            BankReceiptRequest req = this.buildReq(accNo, transDate);
            HashMap<String, ReceiptInfo> paramMap = new HashMap<String, ReceiptInfo>(2);
            paramMap.put("ReceiptInfo", receiptInfo);
            req.setParamsMap(paramMap);
            BankReceiptResponseEB response = new B2ESelfReceiptBatchPrn().doBiz(req);
            Object data = response.getData();
            if (data == null) continue;
            String waitingDownloadFilename = (String)data;
            req.setRequestStr(waitingDownloadFilename);
            RequestContextUtils.setRunningParam((String)"fileName", (String)waitingDownloadFilename);
            new DownloadFile().doBiz(req);
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                logger.error("\u56de\u5355\u4e0b\u8f7d\u4f11\u7720\u5f02\u5e38", (Throwable)e);
            }
            downloadListDetail.setFileName(fileName);
            downloadListDetail.setFileLink(receiptInfo.toJSONStr() + "!@#" + waitingDownloadFilename);
            result.add(downloadListDetail);
        }
        return BankReceiptHandleResponseEB.success(result);
    }

    public BankReceiptRequest buildReq(String accNo, LocalDate localDate) {
        return BankReceiptRequest.builder().accNo(accNo).transDate(localDate).build();
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "BankReceiptFetchListAndDownloadTheList";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u83b7\u53d6\u56de\u5355\u6587\u4ef6\u5217\u8868", (String)"BankReceiptFetchListImpl_0", (String)"ebg-receipt-banks-fjhxb-dc", (Object[])new Object[0]);
    }
}

