/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.fjhxb.dc.service.api;

import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.fjhxb.dc.service.api.ReceiptInfo;
import kd.ebg.receipt.banks.fjhxb.dc.service.utils.FJHXB_Packer;
import kd.ebg.receipt.banks.fjhxb.dc.service.utils.FJHXB_Parser;
import kd.ebg.receipt.banks.fjhxb.dc.service.utils.FJHXB_Util;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import org.jdom2.Element;

public class B2ESelfReceiptPrnQry
extends AbstractBankReceiptImpl
implements IBankReceipt {
    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "B2ESelfReceiptPrnQry";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u56de\u5355\u67e5\u8be2", (String)"B2ESelfReceiptPrnQry_0", (String)"ebg-receipt-banks-fjhxb-dc", (Object[])new Object[0]);
    }

    public String pack(BankReceiptRequest bankReceiptRequest) {
        Element ebank_root = new Element("Message");
        JDomUtils.addChild((Element)ebank_root, (Element)FJHXB_Packer.buildHead("B2ESelfReceiptPrnQry", Sequence.gen18Sequence()));
        Element body = JDomUtils.addChild((Element)ebank_root, (String)"Body");
        JDomUtils.addChild((Element)body, (String)"AcNo", (String)bankReceiptRequest.getAccNo());
        JDomUtils.addChild((Element)body, (String)"PrintStatus", (String)"0");
        JDomUtils.addChild((Element)body, (String)"BeginDate", (String)bankReceiptRequest.getTransDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        JDomUtils.addChild((Element)body, (String)"EndDate", (String)bankReceiptRequest.getTransDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        return JDomUtils.root2String((Element)ebank_root, (String)RequestContextUtils.getCharset());
    }

    public BankReceiptResponseEB parse(BankReceiptRequest bankReceiptRequest, String s) {
        Element root = JDomUtils.string2Root((String)s, (String)RequestContextUtils.getCharset());
        BankResponse bankResponse = FJHXB_Parser.parserCommonInfo(root);
        if (!FJHXB_Util.SUCCESS_CODE.equalsIgnoreCase(bankResponse.getResponseCode())) {
            String resMsg = String.format(ResManager.loadKDString((String)"\u672c\u6b21\u56de\u5355\u67e5\u8be2\u5f02\u5e38\uff0c\u5f02\u5e38\u8fd4\u56de\u7801\uff1a%1$s\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a%2$s\u3002", (String)"", (String)"ebg-receipt-banks-fjhxb-dc", (Object[])new Object[0]), bankResponse.getResponseCode(), bankResponse.getResponseMessage());
            throw EBExceiptionUtil.serviceException((String)resMsg);
        }
        List list = root.getChild("Body").getChild("List").getChildren("Map");
        ArrayList<ReceiptInfo> receiptInfos = new ArrayList<ReceiptInfo>(8);
        for (Element element : list) {
            ReceiptInfo receiptInfo = new ReceiptInfo();
            String receiptNo = element.getChildTextTrim("ReceiptNo");
            String receiptType = element.getChildTextTrim("ReceiptType");
            String trsDate = element.getChildTextTrim("TrsDate");
            String amount = element.getChildTextTrim("Amount");
            String jnlNo = element.getChildTextTrim("JnlNo");
            String DtlSeqNum = element.getChildTextTrim("DtlSeqNum");
            receiptInfo.setAccNo(bankReceiptRequest.getAccNo());
            receiptInfo.setReceiptNo(receiptNo);
            receiptInfo.setReceiptType(receiptType);
            receiptInfo.setTrsDate(trsDate);
            receiptInfo.setAmount(amount);
            receiptInfo.setJnlNo(jnlNo);
            receiptInfo.setDtlSeqNum(DtlSeqNum);
            receiptInfos.add(receiptInfo);
        }
        return BankReceiptResponseEB.success(receiptInfos);
    }

    public void configFactory(ConnectionFactory factory) {
        String s = "/eweb/B2ESelfReceiptPrnQry.do?userPassword=" + RequestContextUtils.getBankParameterValue((String)"userPassword") + "&SIGDATA=2";
        factory.setUri(s);
        super.configFactory(factory);
    }
}

