/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.citicb.dc.service.reconciliation.api;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.JDomExtUtils;
import org.jdom2.Document;
import org.jdom2.Element;

public class BankReconciliationDownRequestImpl
extends AbstractBankReceiptImpl
implements IBankReceipt {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReconciliationDownRequestImpl.class);

    public String pack(BankReceiptRequest request) {
        String accNo = request.getAccNo();
        String requestStr = request.getRequestStr();
        EBContext.getContext().setRemoveWriteResponseLog(true);
        return this.getRequestXml(accNo, requestStr);
    }

    private String getRequestXml(String accNo, String billNo) {
        String userId = RequestContextUtils.getRunningParam((String)"userId");
        Element root = JDomExtUtils.createRoot((String)"stream");
        JDomUtils.addChild((Element)root, (String)"action", (String)this.getBizCode());
        JDomUtils.addChild((Element)root, (String)"userName", (String)userId);
        JDomUtils.addChild((Element)root, (String)"accountNo", (String)accNo);
        JDomUtils.addChild((Element)root, (String)"fileType", (String)"2");
        Element list = JDomUtils.addChild((Element)root, (String)"list");
        list.setAttribute("name", "userDataList");
        Element row = JDomUtils.addChild((Element)list, (String)"row");
        JDomUtils.addChild((Element)row, (String)"billNo", (String)billNo);
        EBContext.getContext().setRemoveWriteResponseLog(true);
        return JDomExtUtils.doc2StrGBK((Document)new Document(root));
    }

    public BankReceiptResponseEB parse(BankReceiptRequest request, String responseStr) {
        EBContext.getContext().setRemoveWriteResponseLog(false);
        if (StringUtils.isNotEmpty((String)responseStr) && responseStr.length() < 1000) {
            logger.info("\u63a5\u53e3\u8fd4\u56de\u6570\u636e\uff1a{}", (Object)responseStr);
        }
        return BankReceiptResponseEB.success((Object)this.parseFileInfo(responseStr));
    }

    private String parseFileInfo(String responseStr) {
        Element root = JDomExtUtils.str2DocGBK((String)responseStr).getRootElement();
        String status = JDomExtUtils.getChildText((Element)root, (String)"status");
        String statusText = JDomExtUtils.getChildText((Element)root, (String)"statusText");
        if ("AAAAAAA".equalsIgnoreCase(status)) {
            String fileContent = JDomExtUtils.getChildElement((Element)root, (String)"fileConTent").getTextTrim();
            if (StringUtils.isNotEmpty((String)fileContent)) {
                return fileContent;
            }
            throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u8c03\u7528DLADCDOW\u63a5\u53e3\u83b7\u53d6\u5230\u94f6\u884c\u8fd4\u56de\u7684\u9519\u8bef\u62a5\u6587\uff0c\u94f6\u884c\u8fd4\u56de\u7801[%1$s]\uff1a%2$s\u3002", (String)"BankReconciliationDownRequestImpl_0", (String)"ebg-receipt-banks-citicb-dc", (Object[])new Object[0]), status, statusText));
        }
        throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u8c03\u7528DLADCDOW\u63a5\u53e3\u83b7\u53d6\u5230\u94f6\u884c\u8fd4\u56de\u7684\u9519\u8bef\u62a5\u6587\uff0c\u94f6\u884c\u8fd4\u56de\u7801[%1$s]\uff1a%2$s\u3002", (String)"BankReconciliationDownRequestImpl_0", (String)"ebg-receipt-banks-citicb-dc", (Object[])new Object[0]), status, statusText));
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "DLADCDOW";
    }

    public String getBizDesc() {
        return "";
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "application/xml");
    }
}

