/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.spdb.dc.service.receipt;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.utils.string.StringLength;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.spdb.dc.service.receipt.SPDBDCCommConfig;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import org.jdom2.Element;

public class Packer {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(Packer.class);

    public static Element buildHeadMessage(String transCode) {
        logger.info("buildHeadMessage-begin");
        String bankLoginId = EBContext.getContext().getBankLoginID();
        SPDBDCCommConfig spdbdcCommConfig = (SPDBDCCommConfig)EBConfigBuilder.getInstance().buildConfig(SPDBDCCommConfig.class, bankLoginId);
        String masterID = spdbdcCommConfig.getMasterNo();
        Element head = new Element("head");
        JDomUtils.addChild((Element)head, (String)"transCode", (String)transCode);
        JDomUtils.addChild((Element)head, (String)"signFlag", (String)"1");
        JDomUtils.addChild((Element)head, (String)"masterID", (String)masterID);
        JDomUtils.addChild((Element)head, (String)"packetID", (String)("00" + Sequence.gen18Sequence()));
        JDomUtils.addChild((Element)head, (String)"timeStamp", (String)LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        logger.info("buildHeadMessage-end");
        return head;
    }

    public static Element buildWJ01Body(String accNo, String date) {
        logger.info("buildWJ01Body-begin");
        String bankLoginId = EBContext.getContext().getBankLoginID();
        SPDBDCCommConfig spdbdcCommConfig = (SPDBDCCommConfig)EBConfigBuilder.getInstance().buildConfig(SPDBDCCommConfig.class, bankLoginId);
        String testTime = spdbdcCommConfig.getBiSafeTestTime();
        Element body = new Element("body");
        String acctNoFixLength = StringLength.fixed((String)accNo, (String)" ", (int)20, (boolean)false);
        JDomUtils.addChild((Element)body, (String)"acctNo", (String)acctNoFixLength);
        JDomUtils.addChild((Element)body, (String)"fileBusinessType", (String)"1");
        if (StringUtils.isNotEmpty((String)testTime)) {
            date = testTime;
        }
        JDomUtils.addChild((Element)body, (String)"fileDownloadPar", (String)("3|" + date));
        logger.info("buildWJ01Body-end");
        return body;
    }

    public static Element buildDY47Body(String accNo, String date, int start) {
        logger.info("buildDY47Body-begin");
        Element body = new Element("body");
        JDomUtils.addChild((Element)body, (String)"billDownloadChanel", (String)"1");
        JDomUtils.addChild((Element)body, (String)"acctNo", (String)accNo);
        JDomUtils.addChild((Element)body, (String)"singleOrBatchFlag", (String)"1");
        JDomUtils.addChild((Element)body, (String)"beginNumber", (String)String.valueOf(start));
        JDomUtils.addChild((Element)body, (String)"queryNumber", (String)"10");
        JDomUtils.addChild((Element)body, (String)"beginDate", (String)date);
        JDomUtils.addChild((Element)body, (String)"endDate", (String)date);
        logger.info("buildDY47Body-end");
        return body;
    }

    public static Element buildWJ12Body(String accNo, String date, String recNo) {
        logger.info("buildWJ12Body-begin");
        Element body = new Element("body");
        JDomUtils.addChild((Element)body, (String)"acctNo", (String)accNo);
        JDomUtils.addChild((Element)body, (String)"fileDownloadFlag", (String)"1");
        JDomUtils.addChild((Element)body, (String)"fileDownloadPar", (String)recNo);
        logger.info("buildWJ12Body-end");
        return body;
    }
}

