/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.spdb.dc.service.receipt;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Objects;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.receipt.banks.spdb.dc.service.receipt.SPDBDCCommConfig;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.parse.impl.AbstractFileParser;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;

public class SPDBDCFileParser
extends AbstractFileParser {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(SPDBDCFileParser.class);

    public String getAccNo() {
        return this.getParsedString(0);
    }

    public LocalDate getDate() {
        return LocalDate.now();
    }

    public String getReceiptNo() {
        return this.getParsedString(2);
    }

    public String getCdFlag() {
        String bankLoginId = EBContext.getContext().getBankLoginID();
        SPDBDCCommConfig config = (SPDBDCCommConfig)EBConfigBuilder.getInstance().buildConfig(SPDBDCCommConfig.class, bankLoginId);
        boolean isUseNewApi = Objects.equals(config.getIs_use_new_api(), "true");
        if (EBGStringUtils.isNotEmpty((String)this.fileName) && this.fileName.contains("UNKNOW")) {
            return "UNKNOW";
        }
        if (isUseNewApi) {
            String subpoenaSeqNo = String.format("%s@%s", this.getParsedString(3), this.getParsedString(7));
            return subpoenaSeqNo;
        }
        return "e";
    }

    public String getAmount() {
        String bankLoginId = EBContext.getContext().getBankLoginID();
        SPDBDCCommConfig config = (SPDBDCCommConfig)EBConfigBuilder.getInstance().buildConfig(SPDBDCCommConfig.class, bankLoginId);
        if (config.getPushWay().equals("API")) {
            String amount = this.getParsedString(5);
            String amountStr = this.getParsedString(4);
            if (EBGStringUtils.isNotEmpty((String)amountStr) && amountStr.contains(".")) {
                return amountStr;
            }
            try {
                BigDecimal bigDecimal = new BigDecimal(amount);
                logger.info(bigDecimal.toString());
                return amount;
            }
            catch (Exception e) {
                logger.info(amount);
                return this.getParsedString(4);
            }
        }
        return "e";
    }

    public String getFileSplit() {
        return "_";
    }

    public String getBankVersion() {
        return "SPDB_DC";
    }
}

