/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.cdb.ccip.service.receipt.fetch;

import com.google.common.collect.Maps;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.receipt.banks.cdb.ccip.service.receipt.api.BankReceiptDownloadRequestImpl;
import kd.ebg.receipt.banks.cdb.ccip.service.receipt.api.BankReceiptInfoRequestImpl;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.ReceiptInfo;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.framework.services.receipt.DownloadTaskService;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class ReceiptFetchListImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(ReceiptFetchListImpl.class);
    public DownloadListDetailService downloadListDetailService;
    public DownloadTaskService downloadTaskService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
        this.downloadTaskService = (DownloadTaskService)SpringContextUtil.getBean(DownloadTaskService.class);
    }

    public String getDeveloper() {
        return "kingdee";
    }

    public String getBizCode() {
        return "RECEIPT_FETCHLIST";
    }

    public String getBizDesc() {
        return "";
    }

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.PROCESSING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        this.init(request);
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(16);
        BankReceiptInfoRequestImpl bankReceiptInfoRequest = new BankReceiptInfoRequestImpl();
        List<ReceiptInfo> receiptInfoList = bankReceiptInfoRequest.queryReceiptList(accNo, transDate);
        int count = 0;
        int DOWNLOAD_RECEIPTLIST_SIZE = 1;
        ArrayList fileInfoNodeList = new ArrayList(16);
        BankReceiptRequest bankReceiptRequest = BankReceiptRequest.builder().accNo(accNo).transDate(transDate).build();
        do {
            ArrayList<String> downloadReceiptNo = new ArrayList<String>(16);
            for (int i = 0; i < DOWNLOAD_RECEIPTLIST_SIZE && count < receiptInfoList.size(); ++i) {
                ReceiptInfo receiptNode = receiptInfoList.get(count);
                if (EBGStringUtils.isEmpty((String)receiptNode.getEbillKey())) continue;
                downloadReceiptNo.add(receiptNode.getEbillKey());
                ++count;
            }
            if (downloadReceiptNo.size() == 0) continue;
            HashMap paramMap = Maps.newHashMapWithExpectedSize((int)1);
            paramMap.put("downloadReceiptNos", downloadReceiptNo);
            bankReceiptRequest.setParamsMap((Map)paramMap);
            BankReceiptDownloadRequestImpl bankReceiptDownloadRequest = new BankReceiptDownloadRequestImpl();
            BankReceiptResponseEB bankReceiptResponseEB = bankReceiptDownloadRequest.doBiz(bankReceiptRequest);
            List fileNames = (List)bankReceiptResponseEB.getData();
            fileInfoNodeList.addAll(fileNames);
        } while (count < receiptInfoList.size());
        for (int i = 0; i < receiptInfoList.size(); ++i) {
            ReceiptInfo receiptNode;
            if (i >= fileInfoNodeList.size() || null == (receiptNode = receiptInfoList.get(i))) continue;
            ((ReceiptInfo)fileInfoNodeList.get(i)).setReceiptNo(receiptNode.getReceiptNo());
            ((ReceiptInfo)fileInfoNodeList.get(i)).setOppAccNo(receiptNode.getOppAccNo());
            ((ReceiptInfo)fileInfoNodeList.get(i)).setAmount(receiptNode.getAmount());
            ((ReceiptInfo)fileInfoNodeList.get(i)).setEbillKey(receiptNode.getEbillKey());
            ((ReceiptInfo)fileInfoNodeList.get(i)).setExplanation(receiptNode.getExplanation());
        }
        for (ReceiptInfo receiptInfo : fileInfoNodeList) {
            String receiptNo = receiptInfo.getReceiptNo();
            String amount = receiptInfo.getAmount();
            String cdFlag = receiptInfo.getExplanation();
            String oppAccNO = receiptInfo.getOppAccNo();
            String fileName = ReceiptFetchListImpl.createFileName(accNo, transDate, receiptNo, amount, cdFlag, oppAccNO);
            String fileLink = receiptInfo.getFilePath();
            DownloadListDetail downloadListDetail = new DownloadListDetail();
            downloadListDetail.setFileLink(fileLink);
            downloadListDetail.setFileName(fileName);
            result.add(downloadListDetail);
        }
        if (result.size() == 0) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u6ca1\u6709\u56de\u5355\u8bb0\u5f55", (String)"ReceiptFetchListImpl_0", (String)"ebg-receipt-banks-cdb-ccip", (Object[])new Object[0]));
        }
        return BankReceiptHandleResponseEB.success(result);
    }

    public static String createFileName(String accNo, LocalDate transDate, String receiptNo, String amount, String cdFlag, String oppAccNO) {
        StringBuilder sb = new StringBuilder();
        sb.append(accNo).append("_").append(transDate.format(DateTimeFormatter.BASIC_ISO_DATE)).append("_").append(receiptNo).append("_").append(amount).append("_").append(cdFlag).append("_").append(oppAccNO).append("_").append(".pdf");
        return sb.toString();
    }
}

