/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.cdb.ccip.service.util;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.cdb.ccip.service.util.CDBBankResponse;
import kd.ebg.receipt.banks.cdb.ccip.service.util.JDomExtUtils;
import org.apache.commons.codec.binary.Base64;
import org.jdom2.Element;

public class CommonParser {
    public static CDBBankResponse getFrontResponse(String rspStr) {
        EBGLogger logger = EBGLogger.getInstance().getLogger(CDBBankResponse.class);
        CDBBankResponse response = new CDBBankResponse();
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        Element header = JDomUtils.getChildElement((Element)root, (String)"header");
        String returnCode = JDomUtils.getChildText((Element)header, (String)"returnCode");
        String returnMsg = JDomUtils.getChildText((Element)header, (String)"returnMsg");
        response.setResponseCode(returnCode);
        response.setResponseMessage(returnMsg);
        if (!"0000".equals(returnCode)) {
            logger.info("returnCode\u8fd4\u56de" + returnCode);
            response.setSuccess(false);
        } else {
            response.setSuccess(true);
            Element body = JDomUtils.getChildElement((Element)root, (String)"body");
            String bankMsg = "";
            try {
                bankMsg = JDomExtUtils.getChildText((Element)body, (String)"bankMsg");
                bankMsg = new String(Base64.decodeBase64((String)bankMsg), RequestContextUtils.getCharset());
            }
            catch (Exception e) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u89e3\u6790\u94f6\u884c\u54cd\u5e94\u5185\u5bb9\u8282\u70b9\u53d1\u751f\u5f02\u5e38", (String)"CommonParser_0", (String)"ebg-receipt-banks-cdb-ccip", (Object[])new Object[0]), (Throwable)e);
            }
            response.setBankMsg(bankMsg);
        }
        return response;
    }

    public static CDBBankResponse getBankPreResponse(String rspStr) {
        CDBBankResponse response = new CDBBankResponse();
        Element root = JDomExtUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        Element header = JDomExtUtils.getChildElement((Element)root, (String)"Transaction_Header");
        String statusCode = JDomExtUtils.getChildText((Element)header, (String)"SYS_TX_STATUS");
        String bankCode = JDomExtUtils.getChildText((Element)header, (String)"SYS_RESP_CODE");
        String bankMsg = JDomExtUtils.getChildText((Element)header, (String)"SYS_RESP_DESC");
        response.setResponseCode(bankCode);
        response.setResponseMessage(bankMsg);
        response.setBankMsg(bankMsg);
        if ("01".equals(statusCode)) {
            response.setSuccess(false);
        } else {
            response.setSuccess(true);
        }
        Element tranResponse = JDomExtUtils.getChildElement((Element)header, (String)"tran_response");
        if (null != tranResponse) {
            String status = JDomExtUtils.getChildText((Element)tranResponse, (String)"status");
            if ("COMPLETE".equals(status)) {
                response.setPaySuccess(true);
            } else {
                response.setUnkown(true);
            }
        } else {
            response.setUnkown(true);
        }
        return response;
    }

    public static String preParse(String rspStr) {
        CDBBankResponse rsp = CommonParser.getFrontResponse(rspStr);
        if (!rsp.isSuccess()) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u91d1\u8776\u524d\u7f6e\u673a\u8fd4\u56de\u5f02\u5e38\u3002%1$s %2$s\u3002", (String)"CommonParser_1", (String)"ebg-receipt-banks-cdb-ccip", (Object[])new Object[0]), rsp.getResponseCode(), rsp.getResponseMessage()));
        }
        rspStr = rsp.getBankMsg();
        return rspStr;
    }
}

