/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.gsb.dc.service.api;

import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.gsb.dc.utils.Packer;
import kd.ebg.receipt.banks.gsb.dc.utils.Parser;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import org.jdom2.Element;

public class ReceiptRequestImpl
extends AbstractBankReceiptImpl
implements IBankReceipt {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(ReceiptRequestImpl.class);

    public String pack(BankReceiptRequest request) {
        String accNo = request.getAcnt().getAccNo();
        Element root = Packer.buildHead("B2EBillQryDload", null);
        Element map = JDomUtils.getChildElement((Element)root, (String)"Body");
        JDomUtils.addChild((Element)map, (String)"AcNo", (String)accNo);
        JDomUtils.addChild((Element)map, (String)"Currency", (String)request.getAcnt().getCurrency());
        JDomUtils.addChild((Element)map, (String)"BeginDate", (String)request.getTransDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        JDomUtils.addChild((Element)map, (String)"EndDate", (String)request.getTransDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        JDomUtils.addChild((Element)map, (String)"TrsJnlNo", (String)request.getRequestStr());
        String encoding = RequestContextUtils.getCharset();
        return JDomUtils.root2String((Element)root, (String)encoding);
    }

    public void configFactory(ConnectionFactory factory) {
        Packer.configFactory(factory, "B2EBillQryDload");
    }

    public BankReceiptResponseEB parse(BankReceiptRequest bankReceiptRequest, String s) {
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)s, (String)encoding);
        BankResponse bankResponse = Parser.parser(root);
        if ("000000".equals(bankResponse.getResponseCode())) {
            Element body = root.getChild("Body");
            Element list = body.getChild("List");
            Element record = list.getChild("Map");
            list = record.getChild("List");
            record = list.getChild("Map");
            String filePath = record.getChildTextTrim("FilePath");
            String fileName = record.getChildTextTrim("FileName");
            HashMap<String, String> info = new HashMap<String, String>(2);
            info.put("FilePath", filePath);
            info.put("FileName", fileName);
            return BankReceiptResponseEB.success(info);
        }
        throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u56de\u5355\u4e0b\u8f7d\u51fa\u73b0\u5f02\u5e38\uff0c\u9519\u8bef\u4fe1\u606f\uff1a%s", (String)"ReceiptRequestImpl_0", (String)"ebg-receipt-banks-gsb-dc", (Object[])new Object[0]), bankResponse.getResponseMessage()));
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "B2EBillQryDload";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u94f6\u4f01\u76f4\u8054\u7535\u5b50\u56de\u5355\u67e5\u8be2\u4e0b\u8f7d", (String)"ReceiptRequestImpl_1", (String)"ebg-receipt-banks-gsb-dc", (Object[])new Object[0]);
    }
}

