/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.cabc.dc.service.receipt;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.receipt.banks.cabc.dc.service.receipt.utils.HttpUtils;
import kd.ebg.receipt.banks.cabc.dc.service.receipt.utils.RequestPacker;
import kd.ebg.receipt.banks.cabc.dc.service.receipt.utils.ResponseParser;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.bank.BankLoginProperties;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.framework.services.receipt.DownloadTaskService;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.model.receipt.DownloadListTask;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class CabcDcFetchListImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger log = EBGLogger.getInstance().getLogger(CabcDcFetchListImpl.class);
    public DownloadListDetailService downloadListDetailService;
    public DownloadTaskService downloadTaskService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
        this.downloadTaskService = (DownloadTaskService)SpringContextUtil.getBean(DownloadTaskService.class);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u7535\u5b50\u56de\u5355\u83b7\u53d6\u4e0b\u8f7d\u5217\u8868", (String)"CabcDcFetchListImpl_0", (String)"ebg-receipt-banks-cabc-dc", (Object[])new Object[0]);
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        this.init(request);
        long taskId = request.getTaskId();
        DownloadListTask downloadListTask = this.downloadTaskService.findById(taskId);
        List<DownloadListDetail> result = this.doJob(downloadListTask);
        return BankReceiptHandleResponseEB.success(result);
    }

    public List<DownloadListDetail> doJob(DownloadListTask task) {
        BankLoginProperties loginProperties = (BankLoginProperties)EBConfigBuilder.getInstance().buildConfig(BankLoginProperties.class, task.getBankLoginId());
        String host = loginProperties.getIp();
        Integer port = loginProperties.getPort();
        String requestURL = "http://" + host + ":" + port + "/yqbank/APIReqServlet";
        ArrayList<DownloadListDetail> detailList = new ArrayList<DownloadListDetail>(16);
        String accNo = task.getAccNo();
        String Request = RequestPacker.pack(task);
        log.info("\u957f\u5b89\u94f6\u884c\u7535\u5b50\u56de\u5355\u4e0b\u8f7d\u8bf7\u6c42\uff1a\n{}", (Object)Request);
        String Response = HttpUtils.sendMessage(Request, requestURL);
        log.info("\u957f\u5b89\u94f6\u884c\u7535\u5b50\u56de\u5355\u4e0b\u8f7d\u54cd\u5e94\uff1a\n{}", (Object)Response);
        String downloadURL = ResponseParser.parse(Response);
        log.info("\u957f\u5b89\u94f6\u884c\u7535\u5b50\u56de\u5355\u4e0b\u8f7d\u5730\u5740\uff1a\n{}", (Object)downloadURL);
        String zipFileName = downloadURL.substring(downloadURL.indexOf(accNo));
        DownloadListDetail detail = new DownloadListDetail();
        detail.setFileName(zipFileName);
        detail.setFileLink(downloadURL);
        detailList.add(detail);
        RequestContextUtils.setZipName((String)zipFileName);
        return detailList;
    }
}

