/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.gyb.dc.service.receipt.api;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.gyb.dc.service.receipt.utils.GYB_Packer;
import kd.ebg.receipt.banks.gyb.dc.service.receipt.utils.GYB_Parser;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import org.jdom2.Element;

public class OneReceiptDownloadImpl
extends AbstractBankReceiptImpl
implements IBankReceipt {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(OneReceiptDownloadImpl.class);

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "B2eDownloadReceipt4UTF8";
    }

    public String getBizDesc() {
        return null;
    }

    public void configFactory(ConnectionFactory factory) {
        String s = "/New_B2E/Forward.do?SIGDATA=1&";
        try {
            s = s + "userPassword=" + RequestContextUtils.getParameter().getBankParameter("userCif");
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u7528\u6237\u5bc6\u7801\u5f02\u5e38", (Throwable)e);
        }
        factory.setUri(s);
        factory.setHttpHeader("content-type", "text/xml; charset=UTF-8");
        super.configFactory(factory);
    }

    public String pack(BankReceiptRequest bankReceiptRequest) {
        Element ebank_root = new Element("transaction");
        String receiptNo = bankReceiptRequest.getRequestStr();
        JDomUtils.addChild((Element)ebank_root, (Element)GYB_Packer.buildHead(this.getBizCode(), Sequence.gen18Sequence()));
        JDomUtils.addChild((Element)ebank_root, (Element)this.getRequestBody(receiptNo));
        String rqstStr = JDomUtils.root2String((Element)ebank_root, (String)RequestContextUtils.getCharset());
        EBContext.getContext().setRemoveWriteResponseLog(true);
        return rqstStr;
    }

    private Element getRequestBody(String receiptNo) {
        Element RequestBody = new Element("RequestBody");
        Element body = JDomUtils.addChild((Element)RequestBody, (String)"RequestRecord");
        JDomUtils.addChild((Element)body, (String)"ReceiptNo", (String)receiptNo);
        JDomUtils.addChild((Element)body, (String)"Bak1", (String)"HDZHZZ");
        return RequestBody;
    }

    public BankReceiptResponseEB parse(BankReceiptRequest bankReceiptRequest, String response) {
        EBContext.getContext().setRemoveWriteResponseLog(false);
        if (EBGStringUtils.isNotEmpty((String)response) && response.length() < 500) {
            logger.info(response);
        }
        return BankReceiptResponseEB.success((Object)this.parseResponse(response));
    }

    public String parseResponse(String responseStr) {
        String encoding = RequestContextUtils.getCharset();
        Element ebenk = JDomUtils.string2Root((String)responseStr, (String)encoding);
        BankResponse bankResponse = GYB_Parser.parserCommonInfo(ebenk);
        Element body = ebenk.getChild("RespondBody");
        if ("0000".equals(bankResponse.getResponseCode()) || "RET2000".equals(bankResponse.getResponseCode())) {
            List list = body.getChildren("RespondRecord");
            if (list.size() == 0) {
                String errorMsg = String.format(ResManager.loadKDString((String)"\u7535\u5b50\u56de\u5355\u4e0b\u8f7d\u63a5\u53e3\u8c03\u7528\u8fd4\u56de\u9519\u8bef:%1$s\u3002", (String)"BankReceiptDownloadImpl_0", (String)"ebg-receipt-banks-gyb-dc", (Object[])new Object[0]), body.getChildText("respondInfo"));
                throw EBExceiptionUtil.serviceException((String)errorMsg);
            }
            for (int i = 0; i < list.size(); ++i) {
                Element row = (Element)list.get(i);
                String ReceiptFile = row.getChildTextTrim("ReceiptFile");
                if (!EBGStringUtils.isNotEmpty((String)ReceiptFile)) continue;
                return ReceiptFile;
            }
            return null;
        }
        String errorMsg = String.format(ResManager.loadKDString((String)"\u7535\u5b50\u56de\u5355\u4e0b\u8f7d\u63a5\u53e3\u8c03\u7528\u8fd4\u56de\u9519\u8bef:%1$s\u3002", (String)"BankReceiptDownloadImpl_0", (String)"ebg-receipt-banks-gyb-dc", (Object[])new Object[0]), body.getChildText("respondInfo"));
        throw EBExceiptionUtil.serviceException((String)errorMsg);
    }
}

