/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.cqb.dc.receipt.utils;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.business.detail.bank.EBBankDetailResponse;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.framework.match.MatchRule;
import kd.ebg.receipt.common.model.DetailInfo;
import org.jdom2.Element;

public class CQB_DC_Parser {
    public static EBBankDetailResponse parseDetail(String responseStr) {
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        Element head = root.getChild("head");
        String errorCode = head.getChildTextTrim("ErrorCode");
        String errorMsg = head.getChildTextTrim("ErrorMsg");
        if (!errorCode.equalsIgnoreCase("0000")) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u660e\u7ec6\u5931\u8d25,\u94f6\u884c\u8fd4\u56de\u9519\u8bef\u7801:%1$s\u9519\u8bef\u4fe1\u606f:%2$s", (String)"CQB_DC_Parser_9", (String)"ebg-receipt-banks-cqb-dc", (Object[])new Object[0]), errorCode, errorMsg));
        }
        Element body = root.getChild("body");
        List trans = body.getChildren("Trans");
        if (CollectionUtil.isEmpty((Collection)trans)) {
            return new EBBankDetailResponse((List)Lists.newArrayList());
        }
        ArrayList<DetailInfo> list = new ArrayList<DetailInfo>(16);
        for (int i = 0; i < trans.size(); ++i) {
            Element element = (Element)trans.get(i);
            DetailInfo detailInfo = new DetailInfo();
            String transAmt = element.getChildTextTrim("TransAmt");
            String acctAmt = element.getChildTextTrim("AcctAmt");
            String oppAcct = element.getChildTextTrim("OppAcct");
            String oppName = element.getChildTextTrim("OppName");
            String transSeqNo = element.getChildTextTrim("TransSeqNo");
            detailInfo.setOppAccNo(oppAcct);
            detailInfo.setOppAccName(oppName);
            detailInfo.setBizRefNo(transSeqNo);
            detailInfo.setReversed1(transAmt);
            detailInfo.setReversed2(acctAmt);
            String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData(element);
            detailInfo.setJson(jsonStr);
            list.add(detailInfo);
        }
        return new EBBankDetailResponse(list);
    }

    public static BankReceiptResponseEB parseReceiptInfo(String responseStr) {
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        Element head = root.getChild("head");
        String errorCode = head.getChildTextTrim("ErrorCode");
        String errorMsg = head.getChildTextTrim("ErrorMsg");
        if (!errorCode.equalsIgnoreCase("0000")) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u660e\u7ec6\u5931\u8d25,\u94f6\u884c\u8fd4\u56de\u9519\u8bef\u7801:%1$s\u9519\u8bef\u4fe1\u606f:%2$s", (String)"CQB_DC_Parser_9", (String)"ebg-receipt-banks-cqb-dc", (Object[])new Object[0]), errorCode, errorMsg));
        }
        Element body = root.getChild("body");
        String base64Str = body.getChildTextTrim("PdfStr");
        if (EBGStringUtils.isNotEmpty((String)base64Str)) {
            return BankReceiptResponseEB.success((Object)base64Str);
        }
        return BankReceiptResponseEB.fail((String)responseStr);
    }
}

