/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.nbb.opa.service.receipt.utils;

import com.nbcb.sdk.OpenSDK;
import com.nbcb.sdk.aes.exception.SDKException;
import com.nbcb.sdk.aes.param.ConfigParam;
import java.time.LocalDate;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.banks.nbb.opa.service.receipt.utils.KeyStoreUtil;

public class NBBUtil {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(NBBUtil.class);

    public static String send(String productID, String srvID, String reqJsonStr, String from) throws Exception {
        StringBuilder rs = new StringBuilder();
        StringBuilder rp = new StringBuilder();
        rs.append(from).append(ResManager.loadKDString((String)"\u8bf7\u6c42:", (String)"NBBUtil_1", (String)"ebg-receipt-banks-nbb-opa", (Object[])new Object[0])).append(reqJsonStr);
        logger.info(rs.toString());
        String appId = RequestContextUtils.getBankParameterValue((String)"appId");
        String repStr = OpenSDK.send((String)appId, (String)productID, (String)srvID, (String)reqJsonStr);
        rp.append(from).append(ResManager.loadKDString((String)"\u54cd\u5e94:", (String)"NBBUtil_2", (String)"ebg-receipt-banks-nbb-opa", (Object[])new Object[0])).append(repStr);
        logger.info(rp.toString());
        return repStr;
    }

    public static void initSdk(String customerId) throws SDKException {
        String appId = RequestContextUtils.getBankParameterValue((String)"appId");
        String pubKey = KeyStoreUtil.getPubKey();
        String url = RequestContextUtils.getBankParameterValue((String)"ip");
        String privateKey = KeyStoreUtil.getCustomerPK();
        ConfigParam configParam = new ConfigParam();
        configParam.setPrivateKey(privateKey);
        configParam.setPublicUrl(url);
        configParam.setAppKey(appId);
        configParam.setPublicKey(pubKey);
        configParam.setConnectTimeOut(Integer.valueOf(60000));
        configParam.setReadTimeOut(Integer.valueOf(60000));
        logger.info("\u79df\u6237{}", (Object)customerId);
        OpenSDK.dynamicInit((ConfigParam)configParam, (boolean)true);
    }

    public static String getCacheName(String accNo, LocalDate transDate) {
        String cacheName = String.format("nbb_opa_receipt_%s_%s", accNo, LocalDateUtil.formatDate((LocalDate)transDate));
        return cacheName;
    }
}

