/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.bsz.dc.service.util;

import com.bsz.becp.signature.BSZJSONRequest;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import net.sf.json.JSONObject;

public class Utils {
    public static EBGLogger logger = EBGLogger.getInstance().getLogger(Utils.class);
    private static final String RET_MSG = "RET_MSG";
    private static final String DETAIL_NOT_FOUND_CODE = "HDQP2001";
    private static final char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private static String toHexString(long x) {
        StringBuffer sb = new StringBuffer();
        while (x > 0L) {
            char c = hexDigits[(int)(x & 0xFL)];
            sb.insert(0, c);
            x >>>= 4;
        }
        return new String(sb);
    }

    public static String getRecvMsg(String responseMsg) throws Exception {
        BSZJSONRequest reponseJson = new BSZJSONRequest();
        String retCode = reponseJson.getErrorCode(responseMsg);
        if ("0".equals(retCode) || "000000".equals(retCode)) {
            return reponseJson.getPlainData(responseMsg);
        }
        if (DETAIL_NOT_FOUND_CODE.equals(retCode)) {
            return reponseJson.getPlainData(responseMsg);
        }
        String retMsg = Utils.getDataFromRspHeader(responseMsg, RET_MSG);
        StringBuffer errorMsg = new StringBuffer();
        errorMsg.append("RET_CODE:");
        errorMsg.append(retCode);
        errorMsg.append(";RET_MSG:");
        errorMsg.append(retMsg);
        logger.error("\u8fd4\u56de\u9519\u8bef\u4fe1\u606f\uff1a" + errorMsg);
        throw new ReceiptException(errorMsg.toString());
    }

    public static String nullAsBlank(String msg) {
        return EBGStringUtils.isEmpty((String)msg) ? "" : msg;
    }

    public static void checkRspCode(String responseCode, String responseMessage, String successCode) throws Exception {
        if (!successCode.equals(responseCode)) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de :%s\u3002", (String)"Utils_1", (String)"ebg-receipt-banks-bsz-dc", (Object[])new Object[0]), EBGStringUtils.catWithSpace((String[])new String[]{responseCode, responseMessage}));
            throw new ReceiptException(errorMsg);
        }
    }

    public static LocalDateTime parserDateTime(String dateStr, String formatter) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(formatter);
        return LocalDateTime.parse(dateStr, dateTimeFormatter);
    }

    public static boolean allfieldIsNUll(Object o) {
        return o == null;
    }

    public static String getDataFromRspHeader(String rsp, String feildName) {
        JSONObject jsonContent = JSONObject.fromObject((Object)rsp);
        JSONObject jsonBody = jsonContent.getJSONObject("header");
        return jsonBody.getString(feildName);
    }
}

