/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.boimc.dc.receipt;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.receipt.banks.boimc.dc.receipt.api.B2EQueryImpl;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.framework.services.receipt.DownloadTaskService;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.model.receipt.DownloadListTask;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class BoimcDcFetchListImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BoimcDcFetchListImpl.class);
    public DownloadListDetailService downloadListDetailService;
    public DownloadTaskService downloadTaskService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
        this.downloadTaskService = (DownloadTaskService)SpringContextUtil.getBean(DownloadTaskService.class);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u7535\u5b50\u56de\u5355\u83b7\u53d6\u4e0b\u8f7d\u5217\u8868\u3002", (String)"BoimcDcFetchListImpl_0", (String)"ebg-receipt-banks-boimc-dc", (Object[])new Object[0]);
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        this.init(request);
        long taskId = request.getTaskId();
        DownloadListTask downloadListTask = this.downloadTaskService.findById(taskId);
        List<DownloadListDetail> result = this.doJob(downloadListTask);
        return BankReceiptHandleResponseEB.success(result);
    }

    public List<DownloadListDetail> doJob(DownloadListTask task) {
        ArrayList<DownloadListDetail> details = new ArrayList<DownloadListDetail>();
        String accNO = task.getAccNo();
        LocalDate transDate = task.getTransDate();
        B2EQueryImpl request = new B2EQueryImpl();
        BankReceiptRequest receiptRequest = BankReceiptRequest.builder().accNo(accNO).transDate(transDate).build();
        BankReceiptResponseEB result = request.doBiz(receiptRequest);
        List fileNames = (List)result.getData();
        if (fileNames != null) {
            for (String fileName : fileNames) {
                DownloadListDetail detail = new DownloadListDetail();
                detail.setFileLink(fileName);
                detail.setFileName(fileName);
                detail.setAccNo(task.getAccNo());
                details.add(detail);
            }
        } else {
            logger.info("\u94f6\u884c\u672a\u8fd4\u56de\u9700\u8981\u4e0b\u8f7d\u7684\u6587\u4ef6");
            throw new ReceiptException(ResManager.loadKDString((String)"\u94f6\u884c\u672a\u8fd4\u56de\u9700\u8981\u4e0b\u8f7d\u7684\u6587\u4ef6\u3002", (String)"BoimcDcFetchListImpl_1", (String)"ebg-receipt-banks-boimc-dc", (Object[])new Object[0]));
        }
        if (details.size() == 0) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u672c\u6b21\u672a\u83b7\u53d6\u5230\u56de\u5355\u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5\u5f53\u5929\u662f\u5426\u6709\u4ea4\u6613\u660e\u7ec6\u3002", (String)"BoimcDcFetchListImpl_2", (String)"ebg-receipt-banks-boimc-dc", (Object[])new Object[0]));
        }
        return details;
    }
}

