/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.boimc.dc.receipt;

import com.google.common.collect.Maps;
import com.jcraft.jsch.ChannelSftp;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.bank.info.BankRequest;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.receipt.banks.boimc.dc.receipt.BoimcDcCommConfig;
import kd.ebg.receipt.banks.boimc.dc.receipt.api.DownloadImpl;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.core.utils.ErrorMsgUtil;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.bank.BankFtpProperties;
import kd.ebg.receipt.common.framework.receipt.bank.BankLoginProperties;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.framework.receipt.util.SFTPUtils;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.framework.services.receipt.DownloadTaskService;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.model.receipt.DownloadListTask;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class ReceiptDownloadImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(ReceiptDownloadImpl.class);
    public DownloadListDetailService downloadListDetailService;
    public DownloadTaskService downloadTaskService;

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
        this.downloadTaskService = (DownloadTaskService)SpringContextUtil.getBean(DownloadTaskService.class);
    }

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.DOWNLOADING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        this.init(request);
        long taskId = request.getTaskId();
        DownloadListTask downloadListTask = this.downloadTaskService.findById(taskId);
        List downloadListDetails = this.downloadListDetailService.selectByRefId(Long.valueOf(taskId));
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(16);
        if (downloadListDetails.size() == 0) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u672c\u6b21\u4efb\u52a1\u83b7\u53d6\u7684\u56de\u5355\u6587\u4ef6\u5217\u8868\u4e3a\u7a7a\u3002", (String)"ReceiptDownloadImpl_0", (String)"ebg-receipt-banks-boimc-dc", (Object[])new Object[0]));
        }
        for (DownloadListDetail detail : downloadListDetails) {
            result.addAll(this.download(downloadListDetails, request.getBankLoginId(), downloadListTask.getBankVersionId()));
        }
        if (result.size() == 0) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u672c\u6b21\u4efb\u52a1\u83b7\u53d6\u7684\u56de\u5355\u6587\u4ef6\u4e3a\u7a7a\u3002", (String)"ReceiptDownloadImpl_1", (String)"ebg-receipt-banks-boimc-dc", (Object[])new Object[0]));
        }
        return BankReceiptHandleResponseEB.success(result);
    }

    public List<DownloadListDetail> download(List<DownloadListDetail> details, String bankLogin, String bankVersionId) {
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>();
        boolean isLastFile = false;
        for (DownloadListDetail detail : details) {
            if (details.indexOf(detail) == details.size() - 1) {
                isLastFile = true;
            }
            BankLoginProperties bankLoginProperties = (BankLoginProperties)EBConfigBuilder.getInstance().buildConfig(BankLoginProperties.class, bankLogin);
            StringBuilder sb = new StringBuilder();
            sb.append("http://").append(bankLoginProperties.getIp()).append(":").append(bankLoginProperties.getPort()).append("/eweb/downloadFile.do?userPassword=").append(((BoimcDcCommConfig)EBConfigBuilder.getInstance().buildConfig(BoimcDcCommConfig.class, bankLogin)).getUserCipher()).append("&transcode=B2EDownBill&fileName=");
            String url = sb.toString();
            String realUrl = url + detail.getFileLink();
            HashMap runningParams = Maps.newHashMapWithExpectedSize((int)16);
            runningParams.put("url", realUrl);
            EBContext.getContext().setRunningParams((Map)runningParams);
            DownloadImpl downloadFile = new DownloadImpl();
            BankReceiptRequest downloadBankReceiptRequest = BankReceiptRequest.builder().accNo(detail.getAccNo()).transDate(detail.getTransDate()).build();
            BankReceiptResponseEB respose = (BankReceiptResponseEB)downloadFile.doBiz((BankRequest)downloadBankReceiptRequest);
            String realRes = (String)respose.getData();
            logger.info("\u5185\u8499\u53e4\u94f6\u884c\u4e0b\u8f7d\u56de\u5355\u6587\u4ef6\u8fd4\u56de\u62a5\u6587: \n " + realRes);
            if (realRes.contains("<success>" + detail.getFileLink() + "</success>")) {
                result.add(detail);
            }
            int length = detail.getFileName().length();
            String newFileName = detail.getFileName().substring(0, length - 4) + detail.getAccNo() + detail.getFileName().substring(length - 4, length);
            String filePath = FileStorageUtil.getFileBakPath((String)bankVersionId) + File.separator + newFileName;
            String ftpPath = "";
            ChannelSftp sftp = null;
            try {
                if (SFTPUtils.getInstance().isAbort(sftp)) {
                    sftp = SFTPUtils.getInstance().getSftp(bankLogin);
                    BankFtpProperties bankFtpProperties = (BankFtpProperties)EBConfigBuilder.getInstance().buildConfig(BankFtpProperties.class, bankLogin);
                    ftpPath = bankFtpProperties.getFtpPath();
                    ftpPath = StringUtils.isEmpty((String)ftpPath) ? "/" : ftpPath;
                }
                SFTPUtils.getInstance().downloadSingleFile(ftpPath, detail.getFileLink(), filePath, sftp);
                detail.setFileName(newFileName);
                if (!isLastFile) continue;
            }
            catch (Exception e) {
                try {
                    String msg = ErrorMsgUtil.getSFTPErrorMSG((String)detail.getFileName(), (String)e.getMessage());
                    throw new ReceiptException(msg, (Throwable)e);
                }
                catch (Throwable throwable) {
                    if (isLastFile) {
                        SFTPUtils.getInstance().close(sftp);
                    }
                    throw throwable;
                }
            }
            SFTPUtils.getInstance().close(sftp);
        }
        return result;
    }
}

