/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.zsb.opa.service.receipt;

import com.google.common.collect.Maps;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.framework.bank.info.BankHeader;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.banks.zsb.opa.service.detail.DetailImpl;
import kd.ebg.receipt.banks.zsb.opa.service.receipt.api.GetBankReceiptFileName;
import kd.ebg.receipt.business.detail.bank.BankDetailRequest;
import kd.ebg.receipt.business.detail.bank.EBBankDetailResponse;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.constant.UploadStatusEnum;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.model.DetailInfo;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class BankReceiptFetchListImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptFetchListImpl.class);
    public DownloadListDetailService downloadListDetailService;

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.PROCESSING.getId();
    }

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        this.init(request);
        long taskId = request.getTaskId();
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        String transDateStr = LocalDateUtil.formatDate((LocalDate)transDate);
        ArrayList<Object> result = new ArrayList<Object>(16);
        DetailImpl detail = new DetailImpl();
        BankDetailRequest bankDetailRequest = new BankDetailRequest();
        BankHeader header = new BankHeader();
        bankDetailRequest.setHeader(header);
        bankDetailRequest.setStartDate(transDate);
        bankDetailRequest.setEndDate(transDate);
        BankAcnt bankAcnt = new BankAcnt();
        bankAcnt.setAccNo(accNo);
        header.setAcnt(bankAcnt);
        EBBankDetailResponse bankDetailResponse = detail.detail(bankDetailRequest);
        List details = bankDetailResponse.getDetails();
        List downloadListDetails = this.downloadListDetailService.selectByRefId(Long.valueOf(taskId));
        HashMap downloadListDetailMap = Maps.newHashMapWithExpectedSize((int)1);
        for (DownloadListDetail downloadListDetail : downloadListDetails) {
            if (downloadListDetail.getUploadFlag().intValue() != UploadStatusEnum.UPLOAD_SUCCESS.getId()) continue;
            downloadListDetailMap.put(downloadListDetail.getFileName(), downloadListDetail);
        }
        for (DetailInfo detailInfo : details) {
            String amount = detailInfo.getReversed1();
            String cdFlag = detailInfo.getKdFlag();
            String serialNo = detailInfo.getPayBankDetailSeqID();
            StringBuilder fileName = new StringBuilder();
            fileName.append(accNo).append("_");
            fileName.append(transDateStr).append("_");
            fileName.append(serialNo).append("_");
            fileName.append(amount).append("_");
            fileName.append(cdFlag).append(".pdf");
            DownloadListDetail downloadListDetail = new DownloadListDetail();
            downloadListDetail.setFileName(fileName.toString());
            if (downloadListDetailMap.containsKey(downloadListDetail.getFileName())) {
                result.add(downloadListDetailMap.get(downloadListDetail.getFileName()));
                continue;
            }
            try {
                GetBankReceiptFileName getBankReceiptFileName = new GetBankReceiptFileName();
                BankReceiptRequest bankReceiptRequest = BankReceiptRequest.builder().accNo(accNo).transDate(transDate).requestStr(serialNo).build();
                BankReceiptResponseEB bankReceiptResponseEB = getBankReceiptFileName.doBiz(bankReceiptRequest);
                String receiptFileName = (String)bankReceiptResponseEB.getData();
                downloadListDetail.setFileLink(receiptFileName);
                result.add(downloadListDetail);
            }
            catch (Throwable e) {
                logger.error("yqwfw_qryReceiptInfo\u8c03\u7528\u9519\u8bef\uff1a" + e.getMessage());
            }
        }
        if (result.size() == 0) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u672c\u6b21\u4efb\u52a1\u83b7\u53d6\u7684\u56de\u5355\u6587\u4ef6\u5217\u8868\u4e3a\u7a7a\u3002", (String)"BankReceiptFetchListImpl_0", (String)"ebg-receipt-banks-zsb-opa", (Object[])new Object[0]));
        }
        return BankReceiptHandleResponseEB.success(result);
    }

    public boolean isBreak() {
        return true;
    }

    public String getDeveloper() {
        return "lw";
    }

    public String getBizCode() {
        return "ZSB_OPA_BankReceiptFetchList";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u83b7\u53d6\u56de\u5355\u6587\u4ef6\u5217\u8868", (String)"BankReceiptFetchListImpl_1", (String)"ebg-receipt-banks-zsb-opa", (Object[])new Object[0]);
    }
}

