/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.xib.dc.service.receipt;

import java.io.File;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.core.utils.ErrorMsgUtil;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.framework.services.receipt.EBCReceiptInfoJsonService;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.utils.DownloadUtils;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class BankReceiptDownloadImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptDownloadImpl.class);
    public DownloadListDetailService downloadListDetailService;
    public EBCReceiptInfoJsonService receiptInfoJsonService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
        this.receiptInfoJsonService = (EBCReceiptInfoJsonService)SpringContextUtil.getBean(EBCReceiptInfoJsonService.class);
    }

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.DOWNLOADING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        this.init(request);
        long taskId = request.getTaskId();
        String accNo = request.getAccNo();
        String transDateStr = LocalDateUtil.formatDate((LocalDate)request.getTransDate());
        String bankVersion = "XIB_DC";
        List downloadListDetails = this.downloadListDetailService.selectByRefId(Long.valueOf(taskId));
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(16);
        String bakFilePath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)bankVersion, (String)accNo, (String)transDateStr);
        for (DownloadListDetail downloadListDetail : downloadListDetails) {
            this.download(downloadListDetail, bakFilePath);
            logger.info("\u8d26\u53f7\uff1a{}-\u65e5\u671f\uff1a{}-\u56de\u5355\u6587\u4ef6\uff1a{}-\u4e0b\u8f7d\u6210\u529f", new Object[]{accNo, transDateStr, downloadListDetail.getFileName()});
            result.add(downloadListDetail);
        }
        return BankReceiptHandleResponseEB.success(result);
    }

    public void download(DownloadListDetail detail, String bakFilePath) {
        String receiptFilePath = bakFilePath + File.separator + detail.getFileName();
        File receiptFile = FileCommonUtils.getFileByPath((String)receiptFilePath);
        if (receiptFile.exists()) {
            return;
        }
        String fileUrl = detail.getFileLink();
        String fileName = detail.getFileName();
        if (EBGStringUtils.isEmpty((String)fileUrl)) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u56de\u5355\u6587\u4ef6\u8def\u5f84\u4e3a\u7a7a", (String)"BankReceiptDownloadImpl_0", (String)"ebg-receipt-banks-xib-dc", (Object[])new Object[0]));
        }
        try {
            if (fileUrl.contains("http")) {
                RequestContextUtils.setRunningParam((String)"exchangeProtocol", (String)"http");
            } else {
                RequestContextUtils.setRunningParam((String)"exchangeProtocol", (String)"https");
            }
            DownloadUtils.download((String)fileUrl, (String)fileName, (String)bakFilePath);
        }
        catch (Exception e) {
            logger.error("\u53a6\u95e8\u56fd\u9645-\u56de\u5355\u6587\u4ef6\u540d\uff1a" + fileName + ",\u4e0b\u8f7d\u56de\u5355\u6587\u4ef6\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a", (Throwable)e);
            String msg = ErrorMsgUtil.getSFTPErrorMSG((String)detail.getFileLink(), (String)e.getMessage());
            throw new ReceiptException(msg, (Throwable)e);
        }
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "XIB_DC_BankReceiptDownload";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u53a6\u95e8\u56fd\u9645\u94f6\u884c\u76f4\u8fde\u7248\u56de\u5355\u6587\u4ef6\u4e0b\u8f7d", (String)"BankReceiptDownloadImpl_1", (String)"ebg-receipt-banks-xib-dc", (Object[])new Object[0]);
    }
}

