/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.engine.eas.action.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DBRoute;
import kd.bos.entity.AppMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.imsc.dmw.common.pagemodel.DmwReportpushrecord;
import kd.imsc.dmw.consts.PeriodTypeEnum;
import kd.imsc.dmw.engine.eas.action.AbstractMigrateAction;
import kd.imsc.dmw.engine.eas.action.impl.reportpush.ReportPushCallable;
import kd.imsc.dmw.engine.eas.core.config.ReportPushConfig;
import kd.imsc.dmw.engine.eas.core.context.MigrateContext;
import kd.imsc.dmw.engine.eas.core.log.ReportPushLog;
import kd.imsc.dmw.engine.eas.core.param.ReportPushRequestParam;
import kd.imsc.dmw.engine.eas.core.progress.ActionProgress;
import kd.imsc.dmw.helper.BalanceCheckDataHelper;
import kd.imsc.dmw.helper.eas.EasReportHelper;
import kd.imsc.dmw.utils.CommonUtils;
import kd.imsc.dmw.utils.StringUtil;

public class ReportPushAction
extends AbstractMigrateAction {
    private final DistributeSessionlessCache distributeCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("ReportPushAction");
    private static final ThreadPool POOL = ThreadPools.newCachedThreadPool((String)"ReportPushAsyncValidator", (int)8, (int)16);
    private static final String[] idNameFields = new String[]{"id", "number", "name"};
    private static final String[] templateFields = new String[]{"template.id id", "template.name name", "template.number number"};
    private ReportPushRequestParam requestParam;

    public ReportPushAction(MigrateContext migrateContext, ReportPushRequestParam requestParam, ActionProgress progress) {
        super.setExecuteContext(migrateContext);
        this.setProgress(progress);
        this.requestParam = requestParam;
    }

    @Override
    public void doExec() {
        try {
            this.initFeedbackCustData(0, 0);
            this.doReportPush();
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            String msg = sw.toString();
            this.updatePushRecordBill(this.requestParam.getPushRecordId(), "4", msg);
            HashMap<String, String> pushResultMap = new HashMap<String, String>(3);
            pushResultMap.put("failmsg", msg);
            this.getExecuteContext().getProgressController().feedbackCustData("failmsg", pushResultMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doReportPush() throws IOException, InterruptedException, ExecutionException {
        List<Long> pushRecordEntryIdList = this.requestParam.getPushRecordEntryIdList();
        ArrayList<Future> futuresList = new ArrayList<Future>(16);
        QFilter filter = new QFilter("id", "=", (Object)this.requestParam.getPushRecordId());
        DynamicObjectCollection pushRecordEntryColl = QueryServiceHelper.query((String)"dmw_reportpushrecord", (String)String.join((CharSequence)",", "reporttype", DmwReportpushrecord.EF_reportid_query, "bcmmodelid"), (QFilter[])filter.toArray());
        if (CommonUtils.isNull(pushRecordEntryColl)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u62a5\u8868\u63a8\u9001\u8bb0\u5f55\u4e0d\u5b58\u5728,\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u518d\u63a8\u9001\u3002", (String)"ReportPushAction_0", (String)"imsc-dmw-platform", (Object[])new Object[0]));
        }
        String easReportType = ((DynamicObject)pushRecordEntryColl.get(0)).getString("reporttype");
        int permission = PermissionServiceHelper.checkPermission((long)RequestContext.get().getCurrUserId(), (String)"bcm_model", (long)((DynamicObject)pushRecordEntryColl.get(0)).getLong("bcmmodelid"), (String)AppMetadataCache.getAppInfo((String)("2".equals(easReportType) ? "cm" : "rpt")).getId(), (String)"bcm_report_list", (String)"4730fc9f000021ae");
        String formId = "2".equals(easReportType) ? "dmw_fi_mergereport_eas" : "dmw_fi_report_eas";
        String attachKey = "2".equals(easReportType) ? "rptdataattachment" : "attachmentpanelap";
        Object[] resportIds = pushRecordEntryColl.stream().map(o -> o.getLong(DmwReportpushrecord.EF_reportid_query)).toArray();
        Map<String, List<Map<String, Object>>> attachmentMap = EasReportHelper.getAttachments(formId, resportIds, attachKey, true);
        Map<String, Set<String>> sheetNameMap = BalanceCheckDataHelper.getSheetNameMap(attachmentMap);
        String selectFields = String.join((CharSequence)",", "reporttype", "bcmmodelid", "bcmmodelnumber", "bcmmodelname", "entryentity.id", "entryentity.orgnumber", "entryentity.orgname", "entryentity.reportcycle", "entryentity.reportname", "entryentity.yearnumber", "entryentity.periodnumber", DmwReportpushrecord.EF_reportid_query, "entryentity.currencyname");
        filter.and(new QFilter("entryentity.id", "in", pushRecordEntryIdList));
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)ReportPushAction.class.getName(), (String)"dmw_reportpushrecord", (String)selectFields, (QFilter[])filter.toArray(), (String)"entryentity.seq");
        ArrayList<ReportPushConfig> pushConfigList = new ArrayList<ReportPushConfig>(16);
        ArrayList<ReportPushLog> failPushLogList = new ArrayList<ReportPushLog>(16);
        int count = 0;
        try {
            while (dataSet.hasNext()) {
                ++count;
                Row pushRecordEntry = dataSet.next();
                long pushRecordEntryId = pushRecordEntry.getLong("entryentity.id");
                StringBuilder msgBuilder = new StringBuilder();
                if (permission == 0) {
                    if ("2".equals(pushRecordEntry.getString("reporttype"))) {
                        msgBuilder.append(ResManager.loadKDString((String)"\u65e0\u5408\u5e76\u62a5\u8868\u7684\u7f16\u5236\u5b8c\u6210\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ReportPushAction_1", (String)"imsc-dmw-platform", (Object[])new Object[0])).append("\n");
                    } else {
                        msgBuilder.append(ResManager.loadKDString((String)"\u65e0\u8d22\u52a1\u62a5\u8868\u7684\u7f16\u5236\u5b8c\u6210\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ReportPushAction_2", (String)"imsc-dmw-platform", (Object[])new Object[0])).append("\n");
                    }
                }
                Map<String, Object> memberTreeIdMap = this.verifyMemberData(pushRecordEntry, sheetNameMap, msgBuilder);
                if (msgBuilder.length() > 0) {
                    ReportPushLog reportPushLog = new ReportPushLog(this.requestParam.getPushRecordId(), pushRecordEntryId, false, msgBuilder.toString());
                    failPushLogList.add(reportPushLog);
                    this.getProgress().updateComplete(this.getProgress().getComplete() + 1);
                    this.updateFeedbackCustData(reportPushLog);
                    continue;
                }
                ReportPushConfig reportPushConfig = this.createReportPushConfig(pushRecordEntry, attachmentMap, memberTreeIdMap);
                pushConfigList.add(reportPushConfig);
                if (count % 100 != 0) continue;
                ReportPushCallable pushTask = new ReportPushCallable(new ArrayList<ReportPushConfig>(pushConfigList), this.getExecuteContext());
                futuresList.add(POOL.submit((Callable)pushTask));
                pushConfigList.clear();
            }
        }
        finally {
            dataSet.close();
        }
        if (!pushConfigList.isEmpty()) {
            ReportPushCallable pushTask = new ReportPushCallable(pushConfigList, this.getExecuteContext());
            futuresList.add(POOL.submit((Callable)pushTask));
        }
        int complete = 0;
        while (complete != futuresList.size()) {
            int endCount = Math.toIntExact(futuresList.stream().filter(Future::isDone).count());
            if (endCount <= complete) continue;
            complete = endCount;
            this.getProgress().updateComplete(this.getProgress().getComplete() + complete);
        }
        for (Future pushResult : futuresList) {
            List pushLogList = (List)pushResult.get();
            for (ReportPushLog reportPushLog : pushLogList) {
                this.updateFeedbackCustData(reportPushLog);
            }
        }
        EasReportHelper.updatePushRecordEntry(failPushLogList);
        EasReportHelper.updatePushRecordBillStatusByEntry(this.requestParam.getPushRecordId());
    }

    private ReportPushConfig createReportPushConfig(Row pushRecordEntry, Map<String, List<Map<String, Object>>> attachmentMap, Map<String, Object> memberTreeIdMap) throws IOException {
        ReportPushConfig reportPushConfig = new ReportPushConfig(this.requestParam.getPushRecordId(), pushRecordEntry.getLong("entryentity.id"), pushRecordEntry.getLong(DmwReportpushrecord.EF_reportid_query), pushRecordEntry.getString("reporttype"));
        long modelId = pushRecordEntry.getLong("bcmmodelid");
        reportPushConfig.setModel(modelId);
        reportPushConfig.setFyear((Long)memberTreeIdMap.get("fyear"));
        reportPushConfig.setPeriod((Long)memberTreeIdMap.get("period"));
        reportPushConfig.setScene((Long)memberTreeIdMap.get("scene"));
        reportPushConfig.setCurrency((Long)memberTreeIdMap.get("currency"));
        reportPushConfig.setEntity((Long)memberTreeIdMap.get("entity"));
        this.setReportPushConfig(reportPushConfig);
        Map templateIdMap = (Map)memberTreeIdMap.get("template");
        List<Map<Long, String>> spreadjsonList = BalanceCheckDataHelper.getSpreadjsonList(pushRecordEntry.getString(DmwReportpushrecord.EF_reportid_query), attachmentMap, templateIdMap);
        reportPushConfig.setSpreadjsonList(spreadjsonList);
        return reportPushConfig;
    }

    private Map<String, Object> verifyMemberData(Row pushRecordEntry, Map<String, Set<String>> sheetNameMap, StringBuilder msgBuilder) {
        long modelId = pushRecordEntry.getLong("bcmmodelid");
        String modelNumber = pushRecordEntry.getString("bcmmodelnumber");
        String modelName = pushRecordEntry.getString("bcmmodelname");
        String yearNumber = pushRecordEntry.getString("entryentity.yearnumber");
        String periodNumber = pushRecordEntry.getString("entryentity.periodnumber");
        String orgNumber = pushRecordEntry.getString("entryentity.orgnumber");
        String orgName = pushRecordEntry.getString("entryentity.orgname");
        HashSet<String> entityNumberSet = new HashSet<String>(16);
        HashSet<String> sceneNameSet = new HashSet<String>(16);
        HashSet<String> yearNumberSet = new HashSet<String>(16);
        HashSet<String> periodNumberSet = new HashSet<String>(16);
        HashSet<String> currencyNameSet = new HashSet<String>(16);
        HashSet<String> templateMsgSet = new HashSet<String>(16);
        boolean isMerge = "2".equals(pushRecordEntry.getString("reporttype"));
        long orgMemberTreeId = this.validateEntity(modelId, orgNumber, entityNumberSet, isMerge);
        String periodType = pushRecordEntry.getString("entryentity.reportcycle");
        long sceneMemberTreeId = this.validateScene(modelId, periodType, sceneNameSet);
        long yearMemberTreeId = this.validateFYear(modelId, yearNumber, yearNumberSet);
        long periodMemberTreeId = this.validatePeriod(modelId, periodNumber, periodNumberSet);
        String currencyName = pushRecordEntry.getString("entryentity.currencyname");
        long currencyMemberTreeId = this.validateCurrency(modelId, currencyName, currencyNameSet);
        Set<String> sheetNameSet = sheetNameMap.get(pushRecordEntry.getString(DmwReportpushrecord.EF_reportid_query));
        if (CommonUtils.isNull(sheetNameSet)) {
            msgBuilder.append(ResManager.loadKDString((String)"\u62a5\u8868\u6570\u636e\u9644\u4ef6\u4e0d\u5b58\u5728\u3002", (String)"ReportPushAction_3", (String)"imsc-dmw-platform", (Object[])new Object[0])).append("\n");
        }
        if (!entityNumberSet.isEmpty()) {
            String entityMsg = ResManager.loadKDString((String)"\u5728[%1$s]%2$s\u4f53\u7cfb\u7ec4\u7ec7\u7ef4\u5ea6\u4e0b\u672a\u627e\u5230\u7f16\u7801\u4e3a%3$s\u7684\u6570\u636e\uff0c\u8bf7\u5148\u68c0\u67e5\u524d\u7f6e\u6761\u4ef6\u5b8c\u6210\u540e\u518d\u63a8\u9001\u3002", (String)"ReportPushAction_4", (String)"imsc-dmw-platform", (Object[])new Object[0]);
            if (entityNumberSet.size() > 1) {
                entityMsg = ResManager.loadKDString((String)"\u5728[%1$s]%2$s\u4f53\u7cfb\u7ec4\u7ec7\u7ef4\u5ea6\u4e0b\u627e\u5230\u7f16\u7801\u4e3a%3$s\u7684\u591a\u6761\u6570\u636e\uff0c\u8bf7\u4fee\u6539\u7ec4\u7ec7\u7ef4\u5ea6\u6570\u636e\uff0c\u4fdd\u6301\u7f16\u7801\u552f\u4e00\u540e\u518d\u63a8\u9001\u3002", (String)"ReportPushAction_5", (String)"imsc-dmw-platform", (Object[])new Object[0]);
            }
            msgBuilder.append(String.format(entityMsg, modelNumber, modelName, String.join((CharSequence)"\u3001", entityNumberSet))).append("\n");
        }
        if (!sceneNameSet.isEmpty()) {
            String sceneName = PeriodTypeEnum.of(periodType).getName();
            String sceneMsg = ResManager.loadKDString((String)"\u5728[%1$s]%2$s\u4f53\u7cfb\u60c5\u666f\u7ef4\u5ea6\u4e0b\u672a\u627e\u5230\u540d\u79f0\u4e3a%3$s\u7684\u6570\u636e\uff0c\u8bf7\u5148\u68c0\u67e5\u524d\u7f6e\u6761\u4ef6\u5b8c\u6210\u540e\u518d\u63a8\u9001\u3002", (String)"ReportPushAction_6", (String)"imsc-dmw-platform", (Object[])new Object[0]);
            if (sceneNameSet.size() > 1) {
                sceneMsg = ResManager.loadKDString((String)"\u5728[%1$s]%2$s\u4f53\u7cfb\u60c5\u666f\u7ef4\u5ea6\u4e0b\u627e\u5230\u540d\u79f0\u4e3a%3$s\u7684\u591a\u6761\u6570\u636e\uff0c\u8bf7\u4fee\u6539\u60c5\u666f\u7ef4\u5ea6\u6570\u636e\uff0c\u4fdd\u6301\u540d\u79f0\u552f\u4e00\u540e\u518d\u63a8\u9001\u3002", (String)"ReportPushAction_7", (String)"imsc-dmw-platform", (Object[])new Object[0]);
            }
            msgBuilder.append(String.format(sceneMsg, modelNumber, modelName, sceneName)).append("\n");
        }
        if (!yearNumberSet.isEmpty()) {
            String yearMsg = ResManager.loadKDString((String)"\u5728[%1$s]%2$s\u4f53\u7cfb\u8d22\u5e74\u7ef4\u5ea6\u4e0b\u672a\u627e\u5230\u7f16\u7801\u4e3a%3$s\u7684\u6570\u636e\uff0c\u8bf7\u5148\u68c0\u67e5\u524d\u7f6e\u6761\u4ef6\u5b8c\u6210\u540e\u518d\u63a8\u9001\u3002", (String)"ReportPushAction_8", (String)"imsc-dmw-platform", (Object[])new Object[0]);
            if (yearNumberSet.size() > 1) {
                yearMsg = ResManager.loadKDString((String)"\u5728[%1$s]%2$s\u4f53\u7cfb\u8d22\u5e74\u7ef4\u5ea6\u4e0b\u627e\u5230\u7f16\u7801\u4e3a%3$s\u7684\u591a\u6761\u6570\u636e\uff0c\u8bf7\u4fee\u6539\u8d22\u5e74\u7ef4\u5ea6\u6570\u636e\uff0c\u4fdd\u6301\u7f16\u7801\u552f\u4e00\u540e\u518d\u63a8\u9001\u3002", (String)"ReportPushAction_9", (String)"imsc-dmw-platform", (Object[])new Object[0]);
            }
            msgBuilder.append(String.format(yearMsg, modelNumber, modelName, String.join((CharSequence)"\u3001", yearNumberSet))).append("\n");
        }
        if (!periodNumberSet.isEmpty()) {
            String periodMsg = ResManager.loadKDString((String)"\u5728[%1$s]%2$s\u4f53\u7cfb\u671f\u95f4\u7ef4\u5ea6\u4e0b\u672a\u627e\u5230\u7f16\u7801\u4e3a%3$s\u7684\u6570\u636e\uff0c\u8bf7\u5148\u68c0\u67e5\u524d\u7f6e\u6761\u4ef6\u5b8c\u6210\u540e\u518d\u63a8\u9001\u3002", (String)"ReportPushAction_10", (String)"imsc-dmw-platform", (Object[])new Object[0]);
            if (periodNumberSet.size() > 1) {
                periodMsg = ResManager.loadKDString((String)"\u5728[%1$s]%2$s\u4f53\u7cfb\u671f\u95f4\u7ef4\u5ea6\u4e0b\u627e\u5230\u7f16\u7801\u4e3a%3$s\u7684\u591a\u6761\u6570\u636e\uff0c\u8bf7\u4fee\u6539\u671f\u95f4\u7ef4\u5ea6\u6570\u636e\uff0c\u4fdd\u6301\u7f16\u7801\u552f\u4e00\u540e\u518d\u63a8\u9001\u3002", (String)"ReportPushAction_11", (String)"imsc-dmw-platform", (Object[])new Object[0]);
            }
            msgBuilder.append(String.format(periodMsg, modelNumber, modelName, String.join((CharSequence)"\u3001", periodNumberSet))).append("\n");
        }
        if (!currencyNameSet.isEmpty()) {
            String currencyMsg = ResManager.loadKDString((String)"\u5728[%1$s]%2$s\u4f53\u7cfb\u5e01\u79cd\u7ef4\u5ea6\u4e0b\u672a\u627e\u5230\u540d\u79f0\u4e3a%3$s\u7684\u6570\u636e\uff0c\u8bf7\u5148\u68c0\u67e5\u524d\u7f6e\u6761\u4ef6\u5b8c\u6210\u540e\u518d\u63a8\u9001\u3002", (String)"ReportPushAction_12", (String)"imsc-dmw-platform", (Object[])new Object[0]);
            if (currencyNameSet.size() > 1) {
                currencyMsg = ResManager.loadKDString((String)"\u5728[%1$s]%2$s\u4f53\u7cfb\u5e01\u79cd\u7ef4\u5ea6\u4e0b\u627e\u5230\u540d\u79f0\u4e3a%3$s\u7684\u591a\u6761\u6570\u636e\uff0c\u8bf7\u4fee\u6539\u5e01\u79cd\u7ef4\u5ea6\u6570\u636e\uff0c\u4fdd\u6301\u540d\u79f0\u552f\u4e00\u540e\u518d\u63a8\u9001\u3002", (String)"ReportPushAction_13", (String)"imsc-dmw-platform", (Object[])new Object[0]);
            }
            msgBuilder.append(String.format(currencyMsg, modelNumber, modelName, currencyName)).append("\n");
        }
        HashMap<Long, String> templateIdMap = new HashMap<Long, String>(16);
        String reportName = pushRecordEntry.getString("entryentity.reportname");
        if (CommonUtils.isNull(sheetNameSet)) {
            sheetNameSet = new HashSet<String>(1);
            sheetNameSet.add(reportName);
        }
        for (String sheetName : sheetNameSet) {
            String templateName = sheetNameSet.size() <= 1 ? reportName : reportName + "_" + sheetName;
            long templateId = this.validateTemplate(modelId, orgNumber, templateName, templateMsgSet, isMerge);
            if (templateId > 0L) {
                templateIdMap.put(templateId, sheetName);
            }
            if (templateMsgSet.isEmpty()) continue;
            String templateMsg = ResManager.loadKDString((String)"\u5728[%1$s]%2$s\u4f53\u7cfb[%3$s]%4$s\u7ec4\u7ec7\u4e0b\u672a\u627e\u5230\u540d\u79f0\u4e3a%5$s\u7684\u6a21\u677f\uff0c\u5148\u68c0\u67e5\u524d\u7f6e\u6761\u4ef6\u5b8c\u6210\u540e\u518d\u63a8\u9001\u3002", (String)"ReportPushAction_14", (String)"imsc-dmw-platform", (Object[])new Object[0]);
            if (templateMsgSet.size() > 1) {
                templateMsg = ResManager.loadKDString((String)"\u5728[%1$s]%2$s\u4f53\u7cfb[%3$s]%4$s\u7ec4\u7ec7\u4e0b\u627e\u5230\u540d\u79f0\u4e3a%5$s\u7684\u591a\u6761\u6570\u636e\uff0c\u8bf7\u4fee\u6539\u6a21\u677f\u7ef4\u5ea6\u6570\u636e\uff0c\u4fdd\u6301\u540d\u79f0\u552f\u4e00\u540e\u518d\u63a8\u9001\u3002", (String)"ReportPushAction_15", (String)"imsc-dmw-platform", (Object[])new Object[0]);
            }
            msgBuilder.append(String.format(templateMsg, modelNumber, modelName, orgNumber, orgName, templateName)).append("\n");
            templateMsgSet.clear();
        }
        HashMap<String, Object> memberDataMap = new HashMap<String, Object>(6);
        memberDataMap.put("entity", orgMemberTreeId);
        memberDataMap.put("scene", sceneMemberTreeId);
        memberDataMap.put("fyear", yearMemberTreeId);
        memberDataMap.put("period", periodMemberTreeId);
        memberDataMap.put("currency", currencyMemberTreeId);
        memberDataMap.put("template", templateIdMap);
        return memberDataMap;
    }

    private void setReportPushConfig(ReportPushConfig reportPushConfig) {
        Date currentTime = KDDateUtils.now();
        long currUserId = RequestContext.get().getCurrUserId();
        reportPushConfig.setReportstatus("C");
        reportPushConfig.setCreator(currUserId);
        reportPushConfig.setCreatetime(currentTime);
        reportPushConfig.setModifier(currUserId);
        reportPushConfig.setModifytime(currentTime);
        reportPushConfig.setSendbacktimes(0);
        reportPushConfig.setBillstatus("C");
        reportPushConfig.setCommittimes(1);
        reportPushConfig.setNofin(0L);
        reportPushConfig.setData("#gzip#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");
        reportPushConfig.setReporttype("1");
        reportPushConfig.setVersion(0L);
        reportPushConfig.setSendbacktime(null);
        reportPushConfig.setCommittime(currentTime);
        reportPushConfig.setFirstcommittime(currentTime);
        reportPushConfig.setSendbacker(0L);
        reportPushConfig.setCompleter(currUserId);
        reportPushConfig.setCommitor(currUserId);
        reportPushConfig.setCompletetime(currentTime);
        reportPushConfig.setDescription(ResManager.loadKDString((String)"EAS\u62a5\u8868\u63a8\u9001", (String)"ReportPushAction_16", (String)"imsc-dmw-platform", (Object[])new Object[0]));
    }

    private long validateEntity(long modelId, String orgNumber, Set<String> orgNumberSet, boolean isMerge) {
        Map<String, String> cacheDataMap;
        List cacheDataList;
        long orgMemberTreeId = 0L;
        QFilter filter = this.getMemberQFilterByNumber(modelId, orgNumber);
        if (isMerge) {
            filter.and(new QFilter("cslscheme.number", "=", (Object)"DefaultScheme"));
        }
        if (CommonUtils.isNull(cacheDataList = (cacheDataMap = this.cacheModelMemberData("bcm_entitymembertree", modelId, orgNumber, filter, idNameFields)).entrySet().stream().filter(e -> orgNumber.equals(JSONObject.parseObject((String)((String)e.getValue())).getString("number"))).collect(Collectors.toList()))) {
            orgNumberSet.add(orgNumber);
        } else if (cacheDataList.size() > 1) {
            orgNumberSet.addAll(cacheDataList.stream().map(e -> JSONObject.parseObject((String)((String)e.getValue())).getString("number")).collect(Collectors.toSet()));
        } else {
            orgMemberTreeId = Long.parseLong((String)((Map.Entry)cacheDataList.get(0)).getKey());
        }
        return orgMemberTreeId;
    }

    private long validateScene(long modelId, String periodType, Set<String> sceneNameSet) {
        long sceneMemberTreeId = 0L;
        String sceneName = PeriodTypeEnum.of(periodType).getName();
        QFilter filter = this.getMemberQFilterByName(modelId, sceneName);
        Map<String, String> cacheDataMap = this.cacheModelMemberData("bcm_scenemembertree", modelId, periodType, filter, idNameFields);
        List cacheDataList = cacheDataMap.entrySet().stream().filter(e -> sceneName.equals(JSONObject.parseObject((String)((String)e.getValue())).getString("name"))).collect(Collectors.toList());
        if (CommonUtils.isNull(cacheDataList)) {
            sceneNameSet.add(sceneName);
        } else if (cacheDataList.size() > 1) {
            sceneNameSet.addAll(cacheDataList.stream().map(e -> JSONObject.parseObject((String)((String)e.getValue())).getString("number")).collect(Collectors.toSet()));
        } else {
            sceneMemberTreeId = Long.parseLong((String)((Map.Entry)cacheDataList.get(0)).getKey());
        }
        return sceneMemberTreeId;
    }

    private long validateFYear(long modelId, String yearNumber, Set<String> yearNumberSet) {
        long yearMemberTreeId = 0L;
        QFilter filter = this.getMemberQFilterByNumber(modelId, yearNumber);
        Map<String, String> cacheDataMap = this.cacheModelMemberData("bcm_fymembertree", modelId, yearNumber, filter, idNameFields);
        List cacheDataList = cacheDataMap.entrySet().stream().filter(e -> yearNumber.equals(JSONObject.parseObject((String)((String)e.getValue())).getString("number"))).collect(Collectors.toList());
        if (CommonUtils.isNull(cacheDataList)) {
            yearNumberSet.add(yearNumber);
        } else if (cacheDataList.size() > 1) {
            yearNumberSet.addAll(cacheDataList.stream().map(e -> JSONObject.parseObject((String)((String)e.getValue())).getString("number")).collect(Collectors.toSet()));
        } else {
            yearMemberTreeId = Long.parseLong((String)((Map.Entry)cacheDataList.get(0)).getKey());
        }
        return yearMemberTreeId;
    }

    private long validatePeriod(long modelId, String periodNumber, Set<String> periodNumberSet) {
        long periodMemberTreeId = 0L;
        QFilter filter = this.getMemberQFilterByNumber(modelId, periodNumber);
        Map<String, String> cacheDataMap = this.cacheModelMemberData("bcm_periodmembertree", modelId, periodNumber, filter, idNameFields);
        List cacheDataList = cacheDataMap.entrySet().stream().filter(e -> periodNumber.equals(JSONObject.parseObject((String)((String)e.getValue())).getString("number"))).collect(Collectors.toList());
        if (CommonUtils.isNull(cacheDataList)) {
            periodNumberSet.add(periodNumber);
        } else if (cacheDataList.size() > 1) {
            periodNumberSet.addAll(cacheDataList.stream().map(e -> JSONObject.parseObject((String)((String)e.getValue())).getString("number")).collect(Collectors.toSet()));
        } else {
            periodMemberTreeId = Long.parseLong((String)((Map.Entry)cacheDataList.get(0)).getKey());
        }
        return periodMemberTreeId;
    }

    private long validateCurrency(long modelId, String currencyName, Set<String> currencyNameSet) {
        long currencyMemberTreeId = 0L;
        QFilter filter = this.getMemberQFilterByName(modelId, currencyName);
        Map<String, String> cacheDataMap = this.cacheModelMemberData("bcm_currencymembertree", modelId, currencyName, filter, idNameFields);
        List cacheDataList = cacheDataMap.entrySet().stream().filter(e -> currencyName.equals(JSONObject.parseObject((String)((String)e.getValue())).getString("name"))).collect(Collectors.toList());
        if (CommonUtils.isNull(cacheDataList)) {
            currencyNameSet.add(currencyName);
        } else if (cacheDataList.size() > 1) {
            currencyNameSet.addAll(cacheDataList.stream().map(e -> JSONObject.parseObject((String)((String)e.getValue())).getString("number")).collect(Collectors.toSet()));
        } else {
            currencyMemberTreeId = Long.parseLong((String)((Map.Entry)cacheDataList.get(0)).getKey());
        }
        return currencyMemberTreeId;
    }

    private long validateTemplate(long modelId, String orgNumber, String templateName, Set<String> templateNameSet, boolean isMerge) {
        long templateId = 0L;
        QFilter entityFilter = new QFilter("entity.number", "=", (Object)orgNumber);
        entityFilter.and("model", "=", (Object)modelId);
        if (isMerge) {
            entityFilter.and("entity.cslscheme.number", "=", (Object)"DefaultScheme");
        }
        entityFilter.and(new QFilter("model", "=", (Object)modelId));
        entityFilter.and(new QFilter("template.name", "=", (Object)templateName));
        entityFilter.and(new QFilter("template.status", "=", (Object)"1"));
        Map<String, String> cacheDataMap = this.cacheModelMemberData("bcm_distributionentity", modelId, templateName + "_" + orgNumber, entityFilter, templateFields);
        List cacheDataList = cacheDataMap.entrySet().stream().filter(e -> templateName.equals(JSONObject.parseObject((String)((String)e.getValue())).getString("name"))).collect(Collectors.toList());
        if (CommonUtils.isNull(cacheDataList)) {
            templateNameSet.add(templateName);
        } else if (cacheDataList.size() > 1) {
            templateNameSet.addAll(cacheDataList.stream().map(e -> JSONObject.parseObject((String)((String)e.getValue())).getString("number")).collect(Collectors.toSet()));
        } else {
            templateId = Long.parseLong((String)((Map.Entry)cacheDataList.get(0)).getKey());
        }
        return templateId;
    }

    private QFilter getMemberQFilterByNumber(long modelId, String modelMemberNumber) {
        QFilter cusFilter = new QFilter("status", "=", (Object)"C");
        cusFilter.and(new QFilter("enable", "=", (Object)"1"));
        cusFilter.and(new QFilter("model", "=", (Object)modelId));
        cusFilter.and(new QFilter("number", "=", (Object)modelMemberNumber));
        return cusFilter;
    }

    private QFilter getMemberQFilterByName(long modelId, String modelMemberName) {
        QFilter cusFilter = new QFilter("status", "=", (Object)"C");
        cusFilter.and(new QFilter("enable", "=", (Object)"1"));
        cusFilter.and(new QFilter("model", "=", (Object)modelId));
        cusFilter.and(new QFilter("name", "=", (Object)modelMemberName));
        return cusFilter;
    }

    private Map<String, String> cacheModelMemberData(String modelMemberFormId, long modelId, String modelMemberNumber, QFilter filter, String[] selectFields) {
        String cacheKey = modelMemberFormId + "_" + modelId + "_" + modelMemberNumber;
        HashMap<String, String> cacheDataMap = this.distributeCache.getAll(cacheKey);
        if (!this.distributeCache.contains(cacheKey)) {
            DynamicObjectCollection dataCollection = QueryServiceHelper.query((String)modelMemberFormId, (String)String.join((CharSequence)",", selectFields), (QFilter[])filter.toArray());
            HashMap<String, String> dataMap = new HashMap<String, String>(16);
            for (DynamicObject item : dataCollection) {
                JSONObject valueJson = new JSONObject();
                valueJson.put("id", (Object)item.getString("id"));
                valueJson.put("number", (Object)item.getString("number"));
                valueJson.put("name", (Object)item.getString("name"));
                dataMap.put(item.getString("id"), JSON.toJSONString((Object)valueJson));
            }
            this.distributeCache.put(cacheKey, dataMap, 180);
            cacheDataMap = dataMap;
        }
        return cacheDataMap;
    }

    private void updatePushRecordBill(long pushRecordId, String status, String errorMsg) {
        DynamicObject newDynObj = BusinessDataServiceHelper.newDynamicObject((String)"dmw_reportpushrecord");
        String recordTableName = newDynObj.getDynamicObjectType().getAlias();
        StringBuilder updateSql = new StringBuilder();
        updateSql.append(" update ").append(recordTableName).append(" set fpushstatus=?,ferrorinfo=?,ferrorinfo_tag=?,ftraceid=? where fid =? ");
        String msg = StringUtil.subDataDeal(errorMsg, 500);
        BalanceCheckDataHelper.execute(DBRoute.of((String)"imsc"), updateSql.toString(), new Object[]{status, msg, errorMsg, RequestContext.get().getTraceId(), pushRecordId});
    }

    private void updateFeedbackCustData(ReportPushLog reportPushLog) {
        Map<String, Object> taskCustomData = this.getExecuteContext().getProgressController().getCustData();
        Map pushResultMap = (Map)taskCustomData.get("successmsg");
        int sucessCount = (Integer)pushResultMap.get("successcount");
        int failCount = (Integer)pushResultMap.get("failcount");
        if (reportPushLog.isSuccess()) {
            ++sucessCount;
        } else {
            ++failCount;
        }
        pushResultMap.put("successcount", sucessCount);
        pushResultMap.put("failcount", failCount);
        this.getExecuteContext().getProgressController().feedbackCustData("successmsg", pushResultMap);
    }

    private void initFeedbackCustData(int sucessCount, int failCount) {
        HashMap<String, Integer> pushResultMap = new HashMap<String, Integer>(3);
        int allCount = this.requestParam.getPushRecordEntryIdList().size();
        pushResultMap.put("allcount", allCount);
        pushResultMap.put("successcount", sucessCount);
        pushResultMap.put("failcount", failCount);
        this.getExecuteContext().getProgressController().feedbackCustData("successmsg", pushResultMap);
    }
}

