/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.engine.eas.action.impl.migrate.isccaller;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.imsc.dmw.engine.eas.core.config.MigrateIscSchemeConfig;
import kd.imsc.dmw.engine.eas.core.context.MigrateContext;
import kd.imsc.dmw.helper.tpl.MigrateUserGuideProjectHelper;
import kd.imsc.dmw.utils.StringUtil;

public abstract class AbstractIscScheme {
    protected String schemeType;
    protected MigrateIscSchemeConfig config;
    protected MigrateContext context;
    protected long instanceId;
    protected String executeType;

    protected AbstractIscScheme(String executeType, String schemeType, MigrateIscSchemeConfig config, MigrateContext context) {
        this.executeType = executeType;
        this.schemeType = schemeType;
        this.config = config;
        this.context = context;
    }

    abstract String doExcute();

    public abstract Tuple<String, String> wait2End();

    public abstract boolean checkTerminate();

    public void updateExcutionStatus(String status, String msg) {
        if (msg == null) {
            msg = "";
        }
        String projectEntryTableName = MigrateUserGuideProjectHelper.getMigObjectTableNameByProjectFormId(this.context.getProjectFormId());
        String sql = "update " + projectEntryTableName + " set fmigratestatus = ?, fmigratelog = ? where fentryid = ?";
        DB.execute((DBRoute)DBRoute.of((String)"imsc"), (String)sql, (Object[])new Object[]{new SqlParameter(":fmigratestatus", 12, (Object)status), new SqlParameter(":fmigratelog", 12, (Object)(msg.length() > 255 ? msg.substring(0, 255) : msg)), new SqlParameter(":fentryid", -5, (Object)this.config.getEntryId())});
    }

    public void updateExcutionId() {
        String projectEntryTableName = MigrateUserGuideProjectHelper.getMigObjectTableNameByProjectFormId(this.context.getProjectFormId());
        String sql = "update " + projectEntryTableName + " set fiscexcutionid = ? where fentryid = ?";
        DB.execute((DBRoute)DBRoute.of((String)"imsc"), (String)sql, (Object[])new Object[]{new SqlParameter(":fiscexcutionid", 12, (Object)String.valueOf(this.instanceId)), new SqlParameter(":fentryid", -5, (Object)this.config.getEntryId())});
    }

    public int getDynamicSleepSecond(int beginSecond, int maxSecond) {
        if (beginSecond >= maxSecond) {
            return maxSecond;
        }
        return beginSecond * 13 / 10;
    }

    public Set<String> getAllEASBosTypes() {
        long projectId = this.context.getProjectId();
        DynamicObject projectObj = BusinessDataServiceHelper.loadSingle((Object)projectId, (String)this.context.getProjectFormId(), (String)"treeentryentity.id,treeentryentity.migrateobject,treeentryentity.migbotp,treeentryentity.migdap,treeentryentity.migrecord");
        DynamicObjectCollection entryList = projectObj.getDynamicObjectCollection("treeentryentity");
        ArrayList<Object> migEASObjs = new ArrayList<Object>(16);
        for (DynamicObject entry : entryList) {
            String[] easIdList;
            String easObjectId;
            boolean botp = entry.getBoolean("migbotp");
            boolean dap = entry.getBoolean("migdap");
            DynamicObject migObj = entry.getDynamicObject("migrateobject");
            if (migObj == null || !botp && !dap || StringUtil.isEmpty(easObjectId = migObj.getString("easobjectid"))) continue;
            for (String easId : easIdList = easObjectId.split(";")) {
                if (!StringUtil.isNotEmpty(easId)) continue;
                migEASObjs.add(Long.valueOf(easId));
            }
        }
        Set<String> bostypes = this.getIscObjNumber(migEASObjs);
        if (CollectionUtils.isNotEmpty(bostypes)) {
            bostypes.add("2652E01E");
        }
        return bostypes;
    }

    public String getMigNumber() {
        long entryId = this.config.getEntryId();
        QFilter qFilter = new QFilter("treeentryentity.id", "=", (Object)entryId);
        DynamicObject query = QueryServiceHelper.queryOne((String)this.context.getProjectFormId(), (String)"treeentryentity.parentmigobj.number", (QFilter[])qFilter.toArray());
        return query.getString("treeentryentity.parentmigobj.number");
    }

    public String getExecuteType() {
        return this.executeType;
    }

    private Set<String> getIscObjNumber(List<Object> migEASObjs) {
        QFilter iscObjs = new QFilter("id", "in", migEASObjs);
        DynamicObject[] loads = BusinessDataServiceHelper.load((String)"isc_metadata_schema", (String)"id,number", (QFilter[])iscObjs.toArray());
        HashSet<String> numbers = new HashSet<String>(16);
        for (DynamicObject scheme : loads) {
            numbers.add(scheme.getString("number"));
        }
        return numbers;
    }
}

