/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.engine.eas.action.impl.reportpush.exec;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.imsc.dmw.engine.eas.action.impl.reportpush.exec.IReportPush;
import kd.imsc.dmw.engine.eas.core.config.ReportPushConfig;
import kd.imsc.dmw.engine.eas.core.log.ReportPushLog;
import kd.imsc.dmw.utils.CommonUtils;

public abstract class AbstractBcmReportEntity
implements IReportPush {
    private ReportPushConfig reportPushConfig;

    public AbstractBcmReportEntity(ReportPushConfig reportPushConfig) {
        this.reportPushConfig = reportPushConfig;
    }

    @Override
    public ReportPushLog doReportPush() {
        return this.saveReportData();
    }

    private ReportPushLog saveReportData() {
        List<Map<Long, String>> spreadjsonList = this.reportPushConfig.getSpreadjsonList();
        HashSet<String> rptIdSet = new HashSet<String>(spreadjsonList.size());
        StringBuilder msgBuilder = new StringBuilder();
        for (Map<Long, String> spreadjsonMap : spreadjsonList) {
            long templateId = spreadjsonMap.keySet().iterator().next();
            long billId = this.findExistBillId(templateId);
            DynamicObject billData = billId == 0L ? BusinessDataServiceHelper.newDynamicObject((String)"bcm_reportentity") : BusinessDataServiceHelper.loadSingle((Object)billId, (String)"bcm_reportentity");
            billData.set("model", (Object)this.reportPushConfig.getModel());
            billData.set("fyear", (Object)this.reportPushConfig.getFyear());
            billData.set("period", (Object)this.reportPushConfig.getPeriod());
            billData.set("scene", (Object)this.reportPushConfig.getScene());
            billData.set("currency", (Object)this.reportPushConfig.getCurrency());
            billData.set("entity", (Object)this.reportPushConfig.getEntity());
            billData.set("template", (Object)templateId);
            billData.set("spreadjson", (Object)spreadjsonMap.values().iterator().next());
            billData.set("reportstatus", (Object)this.reportPushConfig.getReportstatus());
            billData.set("creator", (Object)this.reportPushConfig.getCreator());
            billData.set("createtime", (Object)this.reportPushConfig.getCreatetime());
            billData.set("modifier", (Object)RequestContext.get().getCurrUserId());
            billData.set("modifytime", (Object)this.reportPushConfig.getModifytime());
            billData.set("sendbacktimes", (Object)this.reportPushConfig.getSendbacktimes());
            billData.set("committimes", (Object)this.reportPushConfig.getCommittimes());
            billData.set("data", (Object)this.reportPushConfig.getData());
            billData.set("reporttype", (Object)this.reportPushConfig.getReporttype());
            billData.set("committime", (Object)this.reportPushConfig.getCommittime());
            billData.set("firstcommittime", (Object)this.reportPushConfig.getFirstcommittime());
            billData.set("completer", (Object)this.reportPushConfig.getCompleter());
            billData.set("commitor", (Object)this.reportPushConfig.getCommitor());
            billData.set("completetime", (Object)this.reportPushConfig.getCompletetime());
            billData.set("description", (Object)this.reportPushConfig.getDescription());
            OperationResult optResult = OperationServiceHelper.executeOperate((String)"save", (String)"bcm_reportentity", (DynamicObject[])new DynamicObject[]{billData}, (OperateOption)CommonUtils.getOperateOption(true, false));
            if (!optResult.isSuccess()) {
                msgBuilder.append(CommonUtils.getErrDetail(optResult));
                continue;
            }
            billId = billData.getLong("id");
            if (billId == 0L && !CommonUtils.isNull(optResult.getSuccessPkIds())) {
                billId = Long.parseLong(optResult.getSuccessPkIds().get(0).toString());
            }
            rptIdSet.add(String.valueOf(billId));
        }
        ReportPushLog reportPushLog = new ReportPushLog(this.reportPushConfig.getPushRecordId(), this.reportPushConfig.getPushRecordEntryId(), msgBuilder.length() == 0, msgBuilder.toString());
        reportPushLog.setBcmReportIds(String.join((CharSequence)",", rptIdSet));
        reportPushLog.setEasReportId(this.reportPushConfig.getEasReportId());
        reportPushLog.setEasReportType(this.reportPushConfig.getEasReportType());
        return reportPushLog;
    }

    private long findExistBillId(long templateId) {
        QFilter filter = new QFilter("model", "=", (Object)this.reportPushConfig.getModel());
        filter.and(new QFilter("entity", "=", (Object)this.reportPushConfig.getEntity()));
        filter.and(new QFilter("scene", "=", (Object)this.reportPushConfig.getScene()));
        filter.and(new QFilter("fyear", "=", (Object)this.reportPushConfig.getFyear()));
        filter.and(new QFilter("period", "=", (Object)this.reportPushConfig.getPeriod()));
        filter.and(new QFilter("currency", "=", (Object)this.reportPushConfig.getCurrency()));
        filter.and(new QFilter("template", "=", (Object)templateId));
        DynamicObject dynObj = QueryServiceHelper.queryOne((String)"bcm_reportentity", (String)"id", (QFilter[])new QFilter[]{filter});
        return dynObj != null ? dynObj.getLong("id") : 0L;
    }
}

