/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.engine.eas.core.ext.checkitems.base;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.imsc.dmw.engine.eas.core.config.isc.impl.IscServiceImpl;
import kd.imsc.dmw.engine.eas.core.ext.checkitems.AbstractCheckPlugin;
import kd.imsc.dmw.engine.eas.core.log.CheckItemLog;
import kd.imsc.dmw.engine.eas.core.param.CheckItemPluginParam;
import kd.imsc.dmw.utils.QFilterUtils;
import kd.imsc.dmw.utils.StringUtils;
import org.apache.commons.collections.CollectionUtils;

public abstract class AbstractOrgIscScheCheckPlugin
extends AbstractCheckPlugin {
    protected String sql;
    protected Long iscSchemeId;
    protected String roleTypeEas;
    protected String roleTypeXh;
    protected String roleTypeErrMsg;

    protected abstract void setBaseData();

    protected abstract String getErrorMessage(String var1, String var2);

    @Override
    public CheckItemLog doExecute(CheckItemPluginParam param) {
        String errMsg;
        this.setBaseData();
        CheckItemLog checkItemLog = new CheckItemLog();
        QFilter idEqFilter = QFilterUtils.getIdEqFilter(this.iscSchemeId);
        DynamicObjectCollection iscSchemes = QueryServiceHelper.query((String)"isc_data_copy", (String)"id,number,name,filter_entries.filter_column,filter_entries.filter_value_fixed", (QFilter[])idEqFilter.toArray());
        if (CollectionUtils.isEmpty((Collection)iscSchemes)) {
            String errMsg2 = ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u96c6\u6210\u65b9\u6848", (String)"AbstractOrgIscScheCheckPlugin_0", (String)"imsc-dmw-platform", (Object[])new Object[0]);
            this.buildErrMsg(errMsg2);
            this.buildFixDataList("B", this.iscSchemeId, null, null, errMsg2);
            this.buildCheckItemLog(checkItemLog);
            return checkItemLog;
        }
        IscServiceImpl service = new IscServiceImpl(param.getDbLinkId());
        Object iscDataResult = service.executeQuerySql(this.sql, 1000L);
        List resultList = (List)iscDataResult;
        if (CollectionUtils.isEmpty((Collection)resultList)) {
            String errMsg3 = ResManager.loadKDString((String)"EAS\u6839\u7ec4\u7ec7\u4e3a\u7a7a\uff0c\u627e\u4e0d\u5230\u5bf9\u5e94\u6839\u7ec4\u7ec7", (String)"AbstractOrgIscScheCheckPlugin_2", (String)"imsc-dmw-platform", (Object[])new Object[0]);
            this.buildErrMsg(errMsg3);
            this.buildFixDataList("A", "00000000-0000-0000-0000-000000000000CCE7AED4", null, null, errMsg3);
            this.buildCheckItemLog(checkItemLog);
            return checkItemLog;
        }
        Map map = (Map)resultList.get(0);
        String easNumber = (String)map.get("fnumber");
        Object xhNumber = ((DynamicObject)iscSchemes.get(0)).get("number");
        Object xhName = ((DynamicObject)iscSchemes.get(0)).get("name");
        HashMap<String, Object> paramMap = new HashMap<String, Object>(2);
        for (DynamicObject iscScheme : iscSchemes) {
            String filterValue;
            String filterKey = iscScheme.getString("filter_entries.filter_column");
            if (!"flongnumber".equalsIgnoreCase(filterKey) && !"longnumber".equalsIgnoreCase(filterKey) || easNumber.equals(filterValue = iscScheme.getString("filter_entries.filter_value_fixed"))) continue;
            errMsg = this.getErrorMessage(filterValue, easNumber);
            this.buildErrMsg(errMsg);
            this.buildFixDataList("B", this.iscSchemeId, xhNumber, xhName, errMsg);
            paramMap.put("rootNum", easNumber);
        }
        if (StringUtils.isNotEmpty(this.roleTypeXh)) {
            long rootOrgId = OrgUnitServiceHelper.getRootOrgId();
            QFilter orgFilter = new QFilter("id", "=", (Object)rootOrgId);
            DynamicObject bosOrg = BusinessDataServiceHelper.loadSingle((String)"bos_org", (String)("id,number,name," + this.roleTypeXh), (QFilter[])new QFilter[]{orgFilter});
            if (bosOrg == null) {
                errMsg = ResManager.loadKDString((String)"\u661f\u701a\u6839\u7ec4\u7ec7\u4e3a\u7a7a\uff0c\u627e\u4e0d\u5230\u5bf9\u5e94\u6839\u7ec4\u7ec7\u3002", (String)"AbstractOrgIscScheCheckPlugin_5", (String)"imsc-dmw-platform", (Object[])new Object[0]);
                this.buildErrMsg(errMsg);
                this.buildFixDataList("B", null, null, null, errMsg);
                this.buildCheckItemLog(checkItemLog);
                return checkItemLog;
            }
            boolean isCheckXh = bosOrg.getBoolean(this.roleTypeXh);
            boolean isCheckEas = this.getOrgBoolean(map.get(this.roleTypeEas));
            String xhOrgName = bosOrg.getString("name");
            String xhOrgNumber = bosOrg.getString("number");
            if (isCheckEas && !isCheckXh) {
                this.buildErrMsg(this.roleTypeErrMsg);
                this.buildFixDataList("B", rootOrgId, xhOrgNumber, xhOrgName, this.roleTypeErrMsg);
                paramMap.put("missRoleType", this.roleTypeXh);
                paramMap.put("rootNum", easNumber);
            }
        }
        this.setParamMap(paramMap);
        this.buildCheckItemLog(checkItemLog);
        return checkItemLog;
    }

    private boolean getOrgBoolean(Object obj) {
        if (obj == null) {
            return false;
        }
        String str = obj.toString();
        return "1".equals(str);
    }
}

