/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.engine.eas.core.ext.checkitems.base;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.imsc.dmw.engine.eas.core.config.isc.impl.IscServiceImpl;
import kd.imsc.dmw.engine.eas.core.ext.checkitems.AbstractCheckPlugin;
import kd.imsc.dmw.engine.eas.core.log.CheckItemLog;
import kd.imsc.dmw.engine.eas.core.param.CheckItemPluginParam;

public class AdminOrgCheckPlugin
extends AbstractCheckPlugin {
    private static final String SQL = "select fnumber,fname_l2 from T_ORG_Admin where FID='00000000-0000-0000-0000-000000000000CCE7AED4'";

    public AdminOrgCheckPlugin() {
        super("bos_adminorg", "T_ORG_Admin");
    }

    @Override
    public CheckItemLog doExecute(CheckItemPluginParam param) {
        CheckItemLog checkItemLog = new CheckItemLog();
        long rootOrgId = OrgUnitServiceHelper.getRootOrgId();
        DynamicObject bosOrg = BusinessDataServiceHelper.loadSingleFromCache((Object)rootOrgId, (String)"bos_adminorg", (String)"number,name");
        if (bosOrg == null) {
            checkItemLog.setStatus("B");
            checkItemLog.setValidateInfo(ResManager.loadKDString((String)"\u661f\u701a\u6839\u7ec4\u7ec7\u4e3a\u7a7a\uff0c\u627e\u4e0d\u5230\u5bf9\u5e94\u6839\u7ec4\u7ec7", (String)"AdminOrgCheckPlugin_0", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            return checkItemLog;
        }
        String xhNumber = bosOrg.getString("number");
        String xhName = bosOrg.getString("name");
        IscServiceImpl service = new IscServiceImpl(param.getDbLinkId());
        Object iscDataResult = service.executeQuerySql(SQL, 1000L);
        List resultList = (List)iscDataResult;
        if (CollectionUtils.isNotEmpty((Collection)resultList)) {
            String errMsg;
            if (CollectionUtils.isEmpty((Collection)resultList)) {
                checkItemLog.setStatus("B");
                checkItemLog.setValidateInfo(ResManager.loadKDString((String)"EAS\u6839\u7ec4\u7ec7\u4e3a\u7a7a\uff0c\u627e\u4e0d\u5230\u5bf9\u5e94\u6839\u7ec4\u7ec7", (String)"AdminOrgCheckPlugin_1", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            }
            Map map = (Map)resultList.get(0);
            String easNumber = (String)map.get("fnumber");
            String easName = (String)map.get("fname_l2");
            if (!xhNumber.equals(easNumber)) {
                errMsg = String.format(ResManager.loadKDString((String)"\u661f\u701a\u6839\u7ec4\u7ec7(%1$s)\u4e0eEAS\u6839\u7ec4\u7ec7(%2$s)\u7f16\u7801\u4e0d\u4e00\u81f4", (String)"AdminOrgCheckPlugin_3", (String)"imsc-dmw-platform", (Object[])new Object[0]), xhNumber, easNumber);
                this.buildErrMsg(errMsg);
                this.buildFixDataList("B", rootOrgId, xhNumber, xhName, errMsg);
            }
            if (!xhName.equals(easName)) {
                errMsg = String.format(ResManager.loadKDString((String)"\u661f\u701a\u6839\u7ec4\u7ec7(%1$s)\u4e0eEAS\u6839\u7ec4\u7ec7(%2$s)\u540d\u79f0\u4e0d\u4e00\u81f4", (String)"AdminOrgCheckPlugin_4", (String)"imsc-dmw-platform", (Object[])new Object[0]), xhName, easName);
                this.buildErrMsg(errMsg);
                this.buildFixDataList("B", rootOrgId, xhNumber, xhName, errMsg);
            }
        }
        this.buildCheckItemLog(checkItemLog);
        return checkItemLog;
    }
}

