/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.engine.eas.core.ext.eas.checkitems.base;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.imsc.dmw.engine.eas.core.config.isc.impl.IscServiceImpl;
import kd.imsc.dmw.engine.eas.core.ext.checkitems.AbstractCheckPlugin;
import kd.imsc.dmw.engine.eas.core.log.CheckItemLog;
import kd.imsc.dmw.engine.eas.core.param.CheckItemPluginParam;

public class TaxRateCheckPlugin
extends AbstractCheckPlugin {
    private static final Log logger = LogFactory.getLog(TaxRateCheckPlugin.class);

    public TaxRateCheckPlugin() {
        super("bd_taxrate", "");
    }

    @Override
    public CheckItemLog doExecute(CheckItemPluginParam param) {
        CheckItemLog checkItemLog = new CheckItemLog();
        Long dbLinkId = param.getDbLinkId();
        IscServiceImpl service = new IscServiceImpl(dbLinkId);
        String sql = "SELECT ftaxrate from( select FTaxRate FROM T_SM_PurRequestEntry UNION SELECT FTaxRate FROM T_SM_PURORDEREntry UNION SELECT FTaxRate FROM T_SM_PURRETURNSENTRY UNION SELECT FTaxRate FROM T_SM_PurContractEntry UNION SELECT FTaxRate FROM T_SM_SUBCONTRACTORDERENTRY UNION SELECT FTaxRate FROM T_SD_SaleContractEntry UNION SELECT FTaxRate FROM T_SD_SaleOrderEntry UNION SELECT FTaxRate FROM T_SD_SaleReturnsEntry UNION SELECT FTaxRate FROM T_IM_PurInWarehsEntry UNION SELECT FTaxRate FROM T_IM_SaleIssueEntry UNION SELECT FTaxRate FROM T_IM_TransferOrderBillEntry UNION SELECT ftaxrate FROM T_AP_OtherBillentry UNION SELECT ftaxrate FROM T_AR_OtherBillentry) as result";
        String countSql = "SELECT COUNT(1) as c FROM (SELECT FTaxRate FROM T_SM_PurRequestEntry UNION SELECT FTaxRate FROM T_SM_PURORDEREntry UNION SELECT FTaxRate FROM T_SM_PURRETURNSENTRY UNION SELECT FTaxRate FROM T_SM_PurContractEntry UNION SELECT FTaxRate FROM T_SM_SUBCONTRACTORDERENTRY UNION SELECT FTaxRate FROM T_SD_SaleContractEntry UNION SELECT FTaxRate FROM T_SD_SaleOrderEntry UNION SELECT FTaxRate FROM T_SD_SaleReturnsEntry UNION SELECT FTaxRate FROM T_IM_PurInWarehsEntry UNION SELECT FTaxRate FROM T_IM_SaleIssueEntry UNION SELECT FTaxRate FROM T_IM_TransferOrderBillEntry UNION SELECT ftaxrate FROM T_AP_OtherBillentry UNION SELECT ftaxrate FROM T_AR_OtherBillentry) AS combined_result";
        List<Map<String, Object>> resultList = this.executePageQuery(service, sql, countSql);
        HashSet<String> fieldList = new HashSet<String>(3);
        fieldList.add("taxrate");
        Map<String, List<Object>> map = this.queryXhData(fieldList, new QFilter[0]);
        List<Object> taxListXhTemp = map.get("taxrate");
        HashSet<BigDecimal> taxSetXh = new HashSet<BigDecimal>(taxListXhTemp.size());
        HashMap<String, Object> paramMap = new HashMap<String, Object>(2);
        ArrayList<BigDecimal> lackTaxList = new ArrayList<BigDecimal>(8);
        for (Object object : taxListXhTemp) {
            BigDecimal num = new BigDecimal(String.valueOf(object)).setScale(10, RoundingMode.HALF_UP);
            taxSetXh.add(num);
        }
        for (Map map2 : resultList) {
            BigDecimal tempTax = (BigDecimal)map2.get("ftaxrate");
            BigDecimal tax = tempTax.setScale(10, RoundingMode.HALF_UP);
            if (taxSetXh.contains(tax)) continue;
            lackTaxList.add(tax);
        }
        if (!lackTaxList.isEmpty()) {
            paramMap.put("lack_tax", lackTaxList);
            this.setParamMap(paramMap);
            String nameTemp = ResManager.loadKDString((String)"\u589e\u503c\u7a0e", (String)"TaxRateRepairPlugin_1", (String)"imsc-dmw-platform", (Object[])new Object[0]);
            for (BigDecimal lackTax : lackTaxList) {
                String taxValue = lackTax.stripTrailingZeros().toPlainString();
                String errMsg = ResManager.loadKDString((String)"\u661f\u701a\u4e2d\u7f3a\u5c11\u503c\u4e3a\uff08%s\uff09\u7684\u7a0e\u7387\uff0c\u8bf7\u4e00\u952e\u4fee\u590d\u521b\u5efa\u6216\u624b\u5de5\u521b\u5efa", (String)"TaxRateCheckPlugin_0", (String)"imsc-dmw-platform", (Object[])new Object[]{lackTax.toString()});
                this.buildErrMsg(errMsg);
                this.buildFixDataList("B", null, "V" + taxValue, nameTemp + taxValue + "%", errMsg);
            }
        }
        this.buildCheckItemLog(checkItemLog);
        return checkItemLog;
    }
}

