/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.engine.eas.core.ext.repairitems.fi.gl;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imsc.dmw.engine.eas.core.log.CheckItemLog;
import kd.imsc.dmw.engine.eas.core.model.RepairResponse;
import kd.imsc.dmw.engine.eas.core.param.RepairPluginParam;
import kd.imsc.dmw.engine.eas.core.plugin.ICheckRepairPlugin;

public class MainAccountBookRepairPlugin
implements ICheckRepairPlugin {
    private static final String TABLE_NAME = "bd_accountbookstype";
    private static final Log logger = LogFactory.getLog(MainAccountBookRepairPlugin.class);

    @Override
    public RepairResponse doExecute(RepairPluginParam param) {
        RepairResponse repairResponse = new RepairResponse();
        CheckItemLog checkItemLog = param.getCheckItemLog();
        Map<String, Object> paramMap = checkItemLog.getParamMap();
        if (paramMap == null) {
            String errMsg = ResManager.loadKDString((String)"\u661f\u701a\u6216EAS\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u6216\u5b58\u5728\u591a\u4e2a\u4e3b\u8d26\u7c3f\u3002", (String)"MainAccountBookCheckPlugin_0", (String)"imsc-dmw-platform", (Object[])new Object[0]);
            repairResponse.setDetail(errMsg);
            repairResponse.setFailCount(1L);
            repairResponse.setStauts("B");
        } else {
            Long rootNumber = (Long)paramMap.get("id");
            String mainAccountNum = (String)paramMap.get("EAS_NUMBER");
            DynamicObject mainAccount = BusinessDataServiceHelper.loadSingle((Object)rootNumber, (String)TABLE_NAME);
            if (mainAccount == null) {
                repairResponse.setStauts("B");
                repairResponse.setFailCount(1L);
                repairResponse.setDetail(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u4e3b\u8d26\u7c3f\uff0c\u53ef\u80fd\u5df2\u88ab\u5220\u9664\u3002", (String)"MainAccountBookRepairPlugin_1", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                return repairResponse;
            }
            mainAccount.set("number", (Object)mainAccountNum);
            try {
                SaveServiceHelper.saveOperate((String)TABLE_NAME, (DynamicObject[])new DynamicObject[]{mainAccount}, null);
                repairResponse.setStauts("A");
                repairResponse.setSuccessCount(1L);
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                repairResponse.setStauts("B");
                repairResponse.setFailCount(1L);
                repairResponse.setDetail(e.getMessage());
            }
        }
        return repairResponse;
    }
}

