/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.helper.lock;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kd.imsc.dmw.helper.lock.MutexLockUtils;

public class BizLocker
implements AutoCloseable {
    private Collection<String> needLockIds = new ArrayList<String>(16);

    public BizLocker(Collection<String> needLockIds) {
        this.needLockIds = needLockIds;
    }

    public BizLocker() {
    }

    public static BizLocker create() {
        return new BizLocker();
    }

    public static BizLocker create(Collection<String> needLockIds) {
        BizLocker locker = new BizLocker(needLockIds);
        locker.doLock();
        return locker;
    }

    public static BizLocker create(Long key, String checkItemFormId) {
        String param = BizLocker.getLockKey(key, checkItemFormId);
        BizLocker locker = new BizLocker(Collections.singletonList(param));
        locker.doLock();
        return locker;
    }

    private void doLock() {
        MutexLockUtils.doLock(this.needLockIds);
    }

    public void doLocks(Collection<String> needLockIds) {
        MutexLockUtils.doLock(needLockIds);
        this.needLockIds.addAll(needLockIds);
    }

    public BizLocker doLock(Long checkItemId, String checkItemFormId) {
        String key = BizLocker.getLockKey(checkItemId, checkItemFormId);
        MutexLockUtils.doLock(Collections.singleton(key));
        this.needLockIds.add(key);
        return this;
    }

    public BizLocker doLock(List<Long> checkItemId, String checkItemFormId) {
        ArrayList<String> list = new ArrayList<String>(16);
        checkItemId.forEach(n -> list.add(BizLocker.getLockKey(n, checkItemFormId)));
        MutexLockUtils.doLock(list);
        this.needLockIds.addAll(list);
        return this;
    }

    private static String getLockKey(Long checkItemId, String checkItemFormId) {
        return checkItemFormId + "&&" + checkItemId + "&&" + "isNotReEntry";
    }

    @Override
    public void close() {
        this.doRelease();
    }

    public void doRelease() {
        MutexLockUtils.releaseLock(this.needLockIds);
    }

    public static void doRelease(Long checkItem, String checkItemFormId) {
        String lockKey = BizLocker.getLockKey(checkItem, checkItemFormId);
        MutexLockUtils.releaseLock(Collections.singleton(lockKey));
    }
}

