/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.mservice;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.imsc.dmw.utils.StringUtils;

public class EASMigrateXhMappingServiceImpl {
    private static final String ENTRY_EAS_IDS = "entryEASIds";
    private static final String EAS_IDS = "easIds";
    private static final String DATA = "data";
    private static final String REQUEST_METHOD = "requestmethod";
    private static final String OP_USER = "opuser";
    private static final String PARAM = "param";
    private static final String DETAIL_MSG = "detailmsg";
    private static final Log logger = LogFactory.getLog(EASMigrateXhMappingServiceImpl.class);

    public Map<String, Object> getXhBillIdByEasEntryIds(Map<String, Object> params) {
        logger.info("\u5fae\u670d\u52a1\u901a\u8fc7EAS\u5206\u5f55ID\u83b7\u53d6\u661f\u701a\u5355\u636eID\u5f00\u59cb  \u53c2\u6570\uff1a{}", params);
        if (params == null) {
            return EASMigrateXhMappingServiceImpl.fail(ResManager.loadKDString((String)"\u53c2\u6570\u4e3a\u7a7a", (String)"EASMigrateXhMappingServiceImpl_0", (String)"imsc-dmw-platform", (Object[])new Object[0]));
        }
        if (params.get(ENTRY_EAS_IDS) == null || CollectionUtils.isEmpty((Collection)((List)params.get(ENTRY_EAS_IDS)))) {
            return EASMigrateXhMappingServiceImpl.fail(ResManager.loadKDString((String)"\u53c2\u6570entryEASIds\u4e3a\u7a7a", (String)"EASMigrateXhMappingServiceImpl_1", (String)"imsc-dmw-platform", (Object[])new Object[0]));
        }
        List easEntryIds = (List)params.get(ENTRY_EAS_IDS);
        String splitMark = this.getSplitMark(params);
        QFilter qFilter = new QFilter("easentryid", "in", (Object)easEntryIds);
        qFilter.and("splitMark", "=", (Object)splitMark);
        DynamicObjectCollection objs = QueryServiceHelper.query((String)"dmw_easidchange", (String)"easentryid,conparentid,id", (QFilter[])new QFilter[]{qFilter});
        Map<String, Object> returnMap = EASMigrateXhMappingServiceImpl.success();
        returnMap.put(DATA, new HashMap());
        if (CollectionUtils.isNotEmpty((Collection)objs)) {
            Map<String, String> collect = objs.stream().collect(Collectors.toMap(o -> o.getString("easentryid"), o -> o.getString("conparentid"), (v1, v2) -> String.valueOf(this.dealMultiValue(v1, v2))));
            ((Map)returnMap.get(DATA)).putAll(collect);
        }
        EASMigrateXhMappingServiceImpl.handleData(params, returnMap, easEntryIds, "getXhBillIdByEasEntryIds");
        return returnMap;
    }

    private String getSplitMark(Map<String, Object> params) {
        String splitMark = (String)params.get("splitMark");
        if (StringUtils.isEmpty(splitMark)) {
            splitMark = "default";
        }
        return splitMark;
    }

    public Map<String, Object> getXhBillIdsByEasIds(Map<String, Object> params) {
        logger.info("\u5fae\u670d\u52a1\u901a\u8fc7EAS\u5355\u636eID\u83b7\u53d6\u661f\u701a\u5355\u636eID\u5f00\u59cb  \u53c2\u6570\uff1a{}", params);
        if (params == null) {
            return EASMigrateXhMappingServiceImpl.fail(ResManager.loadKDString((String)"\u53c2\u6570\u4e3a\u7a7a", (String)"EASMigrateXhMappingServiceImpl_0", (String)"imsc-dmw-platform", (Object[])new Object[0]));
        }
        if (params.get(EAS_IDS) == null || CollectionUtils.isEmpty((Collection)((List)params.get(EAS_IDS)))) {
            return EASMigrateXhMappingServiceImpl.fail(ResManager.loadKDString((String)"\u53c2\u6570easIds\u4e3a\u7a7a", (String)"EASMigrateXhMappingServiceImpl_2", (String)"imsc-dmw-platform", (Object[])new Object[0]));
        }
        String splitMark = this.getSplitMark(params);
        List easIds = (List)params.get(EAS_IDS);
        QFilter qFilter = new QFilter("easparentid", "in", (Object)easIds);
        qFilter.and("splitMark", "=", (Object)splitMark);
        DynamicObjectCollection objs = QueryServiceHelper.query((String)"dmw_easidchange", (String)"easparentid,conparentid,id", (QFilter[])new QFilter[]{qFilter});
        Map<String, Object> returnMap = EASMigrateXhMappingServiceImpl.success();
        returnMap.put(DATA, new HashMap());
        if (CollectionUtils.isNotEmpty((Collection)objs)) {
            Map<String, String> collect = objs.stream().collect(Collectors.toMap(o -> o.getString("easparentid"), o -> o.getString("conparentid"), (v1, v2) -> String.valueOf(this.dealMultiValue(v1, v2))));
            ((Map)returnMap.get(DATA)).putAll(collect);
        }
        EASMigrateXhMappingServiceImpl.handleData(params, returnMap, easIds, "getXhBillIdsByEasIds");
        return returnMap;
    }

    public Map<String, Object> getXhEntryIdByEasEntryIds(Map<String, Object> params) {
        logger.info("\u5fae\u670d\u52a1\u901a\u8fc7\u901a\u8fc7EAS\u5206\u5f55ID\u83b7\u53d6\u661f\u701a\u5355\u636e\u5206\u5f55ID\u5f00\u59cb  \u53c2\u6570\uff1a{}", params);
        if (params == null) {
            return EASMigrateXhMappingServiceImpl.fail(ResManager.loadKDString((String)"\u53c2\u6570\u4e3a\u7a7a", (String)"EASMigrateXhMappingServiceImpl_0", (String)"imsc-dmw-platform", (Object[])new Object[0]));
        }
        if (params.get(ENTRY_EAS_IDS) == null || CollectionUtils.isEmpty((Collection)((List)params.get(ENTRY_EAS_IDS)))) {
            return EASMigrateXhMappingServiceImpl.fail(ResManager.loadKDString((String)"\u53c2\u6570entryEASIds\u4e3a\u7a7a", (String)"EASMigrateXhMappingServiceImpl_1", (String)"imsc-dmw-platform", (Object[])new Object[0]));
        }
        String splitMark = this.getSplitMark(params);
        List easEntryIds = (List)params.get(ENTRY_EAS_IDS);
        QFilter qFilter = new QFilter("easentryid", "in", (Object)easEntryIds);
        qFilter.and("splitMark", "=", (Object)splitMark);
        DynamicObjectCollection objs = QueryServiceHelper.query((String)"dmw_easidchange", (String)"easentryid,conentryid,id", (QFilter[])new QFilter[]{qFilter});
        Map<String, Object> returnMap = EASMigrateXhMappingServiceImpl.success();
        returnMap.put(DATA, new HashMap());
        if (CollectionUtils.isNotEmpty((Collection)objs)) {
            Map<String, String> collect = objs.stream().collect(Collectors.toMap(o -> o.getString("easentryid"), o -> o.getString("conentryid"), (v1, v2) -> String.valueOf(this.dealMultiValue(v1, v2))));
            ((Map)returnMap.get(DATA)).putAll(collect);
        }
        EASMigrateXhMappingServiceImpl.handleData(params, returnMap, easEntryIds, "getXhEntryIdByEasEntryIds");
        return returnMap;
    }

    public Map<String, Object> getMappingInfoByEasEntryIds(Map<String, Object> params) {
        logger.info("\u5fae\u670d\u52a1\u901a\u8fc7\u901a\u8fc7EAS\u5206\u5f55ID\u83b7\u53d6\u4e2d\u95f4\u8868\u6574\u884c\u4fe1\u606f\u5f00\u59cb  \u53c2\u6570\uff1a{}", params);
        if (params == null) {
            return EASMigrateXhMappingServiceImpl.fail(ResManager.loadKDString((String)"\u53c2\u6570\u4e3a\u7a7a", (String)"EASMigrateXhMappingServiceImpl_0", (String)"imsc-dmw-platform", (Object[])new Object[0]));
        }
        if (params.get(ENTRY_EAS_IDS) == null || CollectionUtils.isEmpty((Collection)((List)params.get(ENTRY_EAS_IDS)))) {
            return EASMigrateXhMappingServiceImpl.fail(ResManager.loadKDString((String)"\u53c2\u6570entryEASIds\u4e3a\u7a7a", (String)"EASMigrateXhMappingServiceImpl_1", (String)"imsc-dmw-platform", (Object[])new Object[0]));
        }
        String splitMark = this.getSplitMark(params);
        List easEntryIds = (List)params.get(ENTRY_EAS_IDS);
        QFilter qFilter = new QFilter("easentryid", "in", (Object)easEntryIds);
        qFilter.and("splitMark", "=", (Object)splitMark);
        List<String> fields = EASMigrateXhMappingServiceImpl.getAllFieldString("dmw_easidchange");
        DynamicObjectCollection objs = QueryServiceHelper.query((String)"dmw_easidchange", (String)String.join((CharSequence)",", fields), (QFilter[])new QFilter[]{qFilter});
        Map<String, Object> returnMap = EASMigrateXhMappingServiceImpl.success();
        returnMap.put(DATA, new HashMap());
        if (CollectionUtils.isNotEmpty((Collection)objs)) {
            Map<String, Map> collect = objs.stream().collect(Collectors.toMap(o -> o.getString("easentryid"), o -> {
                HashMap dataMap = new HashMap();
                fields.stream().forEach(f -> dataMap.put(f, o.get(f)));
                return dataMap;
            }, (v1, v2) -> (Map)this.dealMultiValue(v1, v2)));
            ((Map)returnMap.get(DATA)).putAll(collect);
        }
        EASMigrateXhMappingServiceImpl.handleData(params, returnMap, easEntryIds, "getMappingInfoByEasEntryIds");
        return returnMap;
    }

    public Map<String, Object> getXhEntityTypeByEasEntryIds(Map<String, Object> params) {
        logger.info("\u5fae\u670d\u52a1\u901a\u8fc7EAS\u5206\u5f55ID\u83b7\u53d6\u661f\u701a\u5355\u636e\u7c7b\u578b\u63a5\u53e3\u5f00\u59cb  \u53c2\u6570\uff1a{}", params);
        if (params == null) {
            return EASMigrateXhMappingServiceImpl.fail(ResManager.loadKDString((String)"\u53c2\u6570\u4e3a\u7a7a", (String)"EASMigrateXhMappingServiceImpl_0", (String)"imsc-dmw-platform", (Object[])new Object[0]));
        }
        if (params.get(ENTRY_EAS_IDS) == null || CollectionUtils.isEmpty((Collection)((List)params.get(ENTRY_EAS_IDS)))) {
            return EASMigrateXhMappingServiceImpl.fail(ResManager.loadKDString((String)"\u53c2\u6570entryEASIds\u4e3a\u7a7a", (String)"EASMigrateXhMappingServiceImpl_1", (String)"imsc-dmw-platform", (Object[])new Object[0]));
        }
        String splitMark = this.getSplitMark(params);
        List easEntryIds = (List)params.get(ENTRY_EAS_IDS);
        QFilter qFilter = new QFilter("easentryid", "in", (Object)easEntryIds);
        qFilter.and("splitMark", "=", (Object)splitMark);
        DynamicObjectCollection objs = QueryServiceHelper.query((String)"dmw_easidchange", (String)"easentryid,conentity,id", (QFilter[])new QFilter[]{qFilter});
        Map<String, Object> returnMap = EASMigrateXhMappingServiceImpl.success();
        returnMap.put(DATA, new HashMap());
        if (CollectionUtils.isNotEmpty((Collection)objs)) {
            Map<String, String> collect = objs.stream().collect(Collectors.toMap(o -> o.getString("easentryid"), o -> o.getString("conentity"), (v1, v2) -> String.valueOf(this.dealMultiValue(v1, v2))));
            ((Map)returnMap.get(DATA)).putAll(collect);
        }
        EASMigrateXhMappingServiceImpl.handleData(params, returnMap, easEntryIds, "getXhEntityTypeByEasEntryIds");
        return returnMap;
    }

    public Map<String, Object> getXhEntityTypeByEasIds(Map<String, Object> params) {
        logger.info("\u5fae\u670d\u52a1\u901a\u8fc7EAS\u5355\u636eID\u83b7\u53d6\u661f\u701a\u5355\u636e\u7c7b\u578b\u5f00\u59cb  \u53c2\u6570\uff1a{}", params);
        if (params == null) {
            return EASMigrateXhMappingServiceImpl.fail(ResManager.loadKDString((String)"\u53c2\u6570\u4e3a\u7a7a", (String)"EASMigrateXhMappingServiceImpl_0", (String)"imsc-dmw-platform", (Object[])new Object[0]));
        }
        if (params.get(EAS_IDS) == null || CollectionUtils.isEmpty((Collection)((List)params.get(EAS_IDS)))) {
            return EASMigrateXhMappingServiceImpl.fail(ResManager.loadKDString((String)"\u53c2\u6570easIds\u4e3a\u7a7a", (String)"EASMigrateXhMappingServiceImpl_2", (String)"imsc-dmw-platform", (Object[])new Object[0]));
        }
        String splitMark = this.getSplitMark(params);
        List easIds = (List)params.get(EAS_IDS);
        QFilter qFilter = new QFilter("easparentid", "in", (Object)easIds);
        qFilter.and("splitMark", "=", (Object)splitMark);
        DynamicObjectCollection objs = QueryServiceHelper.query((String)"dmw_easidchange", (String)"easparentid,conentity,id", (QFilter[])new QFilter[]{qFilter});
        Map<String, Object> returnMap = EASMigrateXhMappingServiceImpl.success();
        returnMap.put(DATA, new HashMap());
        if (CollectionUtils.isNotEmpty((Collection)objs)) {
            Map<String, String> collect = objs.stream().collect(Collectors.toMap(o -> o.getString("easparentid"), o -> o.getString("conentity"), (v1, v2) -> String.valueOf(this.dealMultiValue(v1, v2))));
            ((Map)returnMap.get(DATA)).putAll(collect);
        }
        EASMigrateXhMappingServiceImpl.handleData(params, returnMap, easIds, "getXhEntityTypeByEasIds");
        return returnMap;
    }

    public Map<String, Object> getXhEntityTypeByEasBosTypes(Map<String, Object> params) {
        logger.info("\u5fae\u670d\u52a1\u901a\u8fc7\u901a\u8fc7EAS\u5206\u5f55ID\u83b7\u53d6\u661f\u701a\u5355\u636e\u5206\u5f55ID\u5f00\u59cb  \u53c2\u6570\uff1a{}", params);
        if (params == null) {
            return EASMigrateXhMappingServiceImpl.fail(ResManager.loadKDString((String)"\u53c2\u6570\u4e3a\u7a7a", (String)"EASMigrateXhMappingServiceImpl_0", (String)"imsc-dmw-platform", (Object[])new Object[0]));
        }
        if (params.get("easBosTypes") == null || CollectionUtils.isEmpty((Collection)((List)params.get("easBosTypes")))) {
            return EASMigrateXhMappingServiceImpl.fail(ResManager.loadKDString((String)"\u53c2\u6570easBosTypes\u4e3a\u7a7a", (String)"EASMigrateXhMappingServiceImpl_3", (String)"imsc-dmw-platform", (Object[])new Object[0]));
        }
        String splitMark = this.getSplitMark(params);
        List easBosTypes = (List)params.get("easBosTypes");
        QFilter qFilter = new QFilter("bostype", "in", (Object)easBosTypes);
        qFilter.and("splitMark", "=", (Object)splitMark);
        DynamicObjectCollection objs = QueryServiceHelper.query((String)"dmw_easidchange", (String)"bostype,conentity,id", (QFilter[])new QFilter[]{qFilter});
        Map<String, Object> returnMap = EASMigrateXhMappingServiceImpl.success();
        returnMap.put(DATA, new HashMap());
        if (CollectionUtils.isNotEmpty((Collection)objs)) {
            Map<String, String> collect = objs.stream().collect(Collectors.toMap(o -> o.getString("bostype"), o -> o.getString("conentity"), (v1, v2) -> String.valueOf(this.dealMultiValue(v1, v2))));
            ((Map)returnMap.get(DATA)).putAll(collect);
        }
        EASMigrateXhMappingServiceImpl.handleData(params, returnMap, easBosTypes, "getXhEntityTypeByEasBosTypes");
        Map data = (Map)returnMap.get(DATA);
        easBosTypes.stream().forEach(o -> {
            if (!data.containsKey(o)) {
                data.put(o, null);
            }
        });
        returnMap.put(DATA, data);
        return returnMap;
    }

    public static Map<String, Object> success() {
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        result.put("success", Boolean.TRUE);
        result.put("status", "1");
        return result;
    }

    public static Map<String, Object> fail(String msg) {
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        result.put("success", Boolean.FALSE);
        result.put("status", "0");
        result.put("message", msg);
        return result;
    }

    private Object dealMultiValue(Object v1, Object v2) {
        if (v1 != null) {
            return v1;
        }
        return v2;
    }

    private static List<String> getAllFieldString(String entityId) {
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)entityId);
        ArrayList<String> fields = new ArrayList<String>();
        if (mainEntityType != null) {
            DataEntityPropertyCollection mainPros = mainEntityType.getProperties();
            for (IDataEntityProperty property : mainPros) {
                if (StringUtils.isEmpty(property.getAlias())) continue;
                fields.add(property.getName());
            }
        }
        return fields;
    }

    private static void handleData(Map<String, Object> params, Map<String, Object> returnMap, List<String> dataList, String functionName) {
        Map data = (Map)returnMap.get(DATA);
        ArrayList<String> idNullList = new ArrayList<String>(8);
        dataList.stream().forEach(o -> {
            if (!data.containsKey(o)) {
                data.put(o, null);
                idNullList.add((String)o);
            }
        });
        EASMigrateXhMappingServiceImpl.buildConvertLog(params, idNullList, functionName);
        returnMap.put(DATA, data);
    }

    private static void buildConvertLog(Map<String, Object> params, List<String> idNullList, String requestMethod) {
        DynamicObject[] migrateLogs = new DynamicObject[idNullList.size()];
        long[] ids = DB.genLongIds((String)"dmw_easmigrate_log", (int)idNullList.size());
        String traceId = RequestContext.get().getTraceId();
        long userId = RequestContext.get().getCurrUserId();
        for (int i = 0; i < idNullList.size(); ++i) {
            DynamicObject tempDyObj = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"dmw_easmigrate_log"));
            String number = CodeRuleServiceHelper.getNumber((String)"dmw_easmigrate_log", (DynamicObject)tempDyObj, null);
            tempDyObj.set("id", (Object)ids[i]);
            tempDyObj.set("billno", (Object)number);
            tempDyObj.set(REQUEST_METHOD, (Object)requestMethod);
            tempDyObj.set("traceid", (Object)traceId);
            tempDyObj.set("createtime", (Object)new Date());
            tempDyObj.set(OP_USER, (Object)userId);
            tempDyObj.set(PARAM, (Object)idNullList.get(i));
            tempDyObj.set("param_tag", (Object)JSON.toJSONString(params));
            tempDyObj.set(DETAIL_MSG, (Object)ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u8f6c\u6362\u540e\u6570\u636e\u3002", (String)"EASMigrateXhMappingServiceImpl_5", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            tempDyObj.set("detailmsg_tag", (Object)ResManager.loadKDString((String)"EAS\u7684\u6570\u636e\u4e3a%s\uff0c\u5728\u661f\u701a\u7cfb\u7edf\u4e2d\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u8f6c\u6362\u540e\u6570\u636e\u3002", (String)"EASMigrateXhMappingServiceImpl_4", (String)"imsc-dmw-platform", (Object[])new Object[]{idNullList.get(i)}));
            migrateLogs[i] = tempDyObj;
        }
        SaveServiceHelper.save((DynamicObject[])migrateLogs);
    }
}

