/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.plugin.formplugin.eas;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.imsc.dmw.helper.eas.EasReportHelper;
import kd.imsc.dmw.utils.CommonUtils;

public class EasMergeBgReportList
extends AbstractListPlugin {
    public void initialize() {
        super.initialize();
        BillList billlist = (BillList)this.getView().getControl("billlistap");
        ArrayList<String> operationKeysList = new ArrayList<String>(1);
        operationKeysList.add("viewreport");
        billlist.addPackageDataListener(pkEvent -> {
            int attachNum = pkEvent.getRowData().getInt("attachnum");
            if (attachNum <= 0) {
                int rowInex = pkEvent.getRowData().getInt("fseq") - 1;
                billlist.hideOperateItems("opcolumn", rowInex, operationKeysList);
            }
        });
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        QFilter mainOrgQFilter = e.getMainOrgQFilter();
        if (mainOrgQFilter != null && "orgunitid".equals(mainOrgQFilter.getProperty())) {
            List orgIdList = (List)e.getMainOrgQFilter().getOriginValue();
            orgIdList.add(0L);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if ("modifyreportorg".equals(actionId) && "success".equals(e.getReturnData())) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6307\u5b9a\u62a5\u8868\u6240\u5c5e\u516c\u53f8\u6210\u529f\u3002", (String)"EasMergeBgReportList_1", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            this.getView().invokeOperation("refresh");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        String operateKey;
        super.afterDoOperation(evt);
        AbstractOperate operate = (AbstractOperate)evt.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "viewreport": {
                BillList billList = (BillList)this.getControl("billlistap");
                ListSelectedRow selectedRow = billList.getCurrentSelectedRowInfo();
                Object pkValue = selectedRow.getPrimaryKeyValue();
                EasReportHelper.viewRptAttachment(pkValue, "dmw_mergebgreport_eas", "rptdataattachment", this.getView());
                break;
            }
            case "batch_exportzip": {
                this.batchExportZip();
                break;
            }
            case "rpt_print": {
                Object[] ids = this.getSelectedRows().getPrimaryKeyValues();
                Map attachments = AttachmentServiceHelper.getAttachments((String)"dmw_mergebgreport_eas", (Object[])ids, (String)"rptdataattachment", (boolean)true);
                EasReportHelper.exportRptDataToPdf(attachments, ResManager.loadKDString((String)"EAS\u5408\u5e76\u9884\u7b97\u62a5\u8868", (String)"EasMergeBgReportList_0", (String)"imsc-dmw-platform", (Object[])new Object[0]), this.getView());
                break;
            }
            case "modifyreportorg": {
                HasPermOrgResult userHasPermOrgs = PermissionServiceHelper.getAllPermOrgs((Long)UserServiceHelper.getCurrentUserId(), (String)"dmw", (String)"dmw_mergebgreport_eas", (String)"4GHTGZ3ZP26W");
                boolean hasPermission = userHasPermOrgs.hasAllOrgPerm();
                if (!userHasPermOrgs.hasAllOrgPerm()) {
                    boolean bl = hasPermission = !CommonUtils.isNull(userHasPermOrgs.getHasPermOrgs());
                }
                if (hasPermission) {
                    QFilter qFilter = new QFilter("id", "in", (Object)this.getSelectedRows().getPrimaryKeyValues());
                    DynamicObjectCollection dynObjColl = QueryServiceHelper.query((String)"dmw_mergebgreport_eas", (String)String.join((CharSequence)",", "id", "isorgnull"), (QFilter[])qFilter.toArray());
                    Set<Long> modifyIdSet = new HashSet<Long>(16);
                    if (!CommonUtils.isNull(dynObjColl)) {
                        modifyIdSet = dynObjColl.stream().filter(o -> o.getBoolean("isorgnull")).map(o -> o.getLong("id")).collect(Collectors.toSet());
                    }
                    if (modifyIdSet.isEmpty()) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u4e2d\u7684\u201c\u62a5\u8868\u6240\u5c5e\u516c\u53f8\u201d\u503c\u4e0d\u5141\u8bb8\u8fdb\u884c\u6307\u5b9a\uff08\u4ec5\u3010\u62a5\u8868\u6240\u5c5e\u516c\u53f8\u4e3a\u7a7a\u3011\u5b57\u6bb5\u503c\u4e3a\u201c\u662f\u201d\u7684\u6570\u636e\u5141\u8bb8\u6307\u5b9a\uff09\uff0c\u8bf7\u6838\u67e5\u3002", (String)"EasMergeBgReportList_2", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                        break;
                    }
                    this.showModifyReportOrgPage(modifyIdSet);
                    break;
                }
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201cEAS\u5408\u5e76\u9884\u7b97\u62a5\u8868\u201d\u7684\u201c\u6307\u5b9a\u62a5\u8868\u6240\u5c5e\u516c\u53f8\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"EasMergeBgReportList_3", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                break;
            }
        }
    }

    private void batchExportZip() {
        Object[] ids = this.getSelectedRows().getPrimaryKeyValues();
        QFilter qFilter = new QFilter("id", "in", (Object)ids);
        String selectors = String.join((CharSequence)",", "id", "orgtreename", "bgschemename", "bgschemenumber", "rptype", "orgunitid", "name", "number", "orgmergename");
        DynamicObject[] reportDynObjs = BusinessDataServiceHelper.load((String)"dmw_mergebgreport_eas", (String)selectors, (QFilter[])qFilter.toArray());
        if (reportDynObjs != null && reportDynObjs.length == 1) {
            String downFileName = EasReportHelper.getMergeBgRptDownFileName(reportDynObjs[0]);
            EasReportHelper.singleRptDataExport(reportDynObjs[0].getPkValue(), downFileName, "dmw_mergebgreport_eas", "rptdataattachment", this.getView());
        } else if (reportDynObjs != null && reportDynObjs.length > 1) {
            HashMap<Object, String> downFileNameMap = new HashMap<Object, String>(reportDynObjs.length);
            for (DynamicObject reportDynObj : reportDynObjs) {
                downFileNameMap.put(reportDynObj.getPkValue(), EasReportHelper.getMergeBgRptDownFileName(reportDynObj));
            }
            EasReportHelper.batchRptDataExport(downFileNameMap, ResManager.loadKDString((String)"EAS\u5408\u5e76\u9884\u7b97\u62a5\u8868", (String)"EasMergeBgReportList_0", (String)"imsc-dmw-platform", (Object[])new Object[0]), "dmw_mergebgreport_eas", "rptdataattachment", this.getView());
        }
    }

    private void showModifyReportOrgPage(Set<Long> modifyIdSet) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("dmw_modifyreportorg");
        parameter.setStatus(OperationStatus.EDIT);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("modifyIds", modifyIdSet);
        parameter.setCustomParam("reportformid", (Object)"dmw_mergebgreport_eas");
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "modifyreportorg"));
        this.getView().showForm(parameter);
    }
}

