/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.plugin.formplugin.multiimport.scheme.list;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.BasedataHelper;
import kd.bos.base.IBasedataController;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.GroupProp;
import kd.bos.entity.property.ParentBasedataProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BaseDataCustomControllerEvent;
import kd.bos.list.BillList;
import kd.bos.list.ITreeListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.TreeListModel;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imsc.dmw.plugin.formplugin.multiimport.scheme.list.ImportTempListPlugin;

public class ImportTargetListPlugin
extends ImportTempListPlugin {
    private static final Log logger = LogFactory.getLog(ImportTargetListPlugin.class);
    public static final String ROOTNODEID = "8609760E-EF83-4775-A9FF-CCDEC7C0B689";
    private static final String NO_GROUP = "1";
    public static final String PROP_ID = "id";
    public static final String PROP_PARENT = "parent";
    public static final String PROP_ENABLE = "enable";
    public static final String OP_OPEN = "btn_open";
    public static final String OP_NEW = "new";
    public static final String BTNOK = "btnok";
    public static final String LICENCE_CLOUDS = "l_c";
    public static final String BILLLISTAP = "billlistap";

    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        e.setCancel(true);
    }

    private QFilter genRefreshFilter(String nodeId) {
        logger.info("genRefreshFilter nodeId {}", (Object)nodeId);
        ListShowParameter param = (ListShowParameter)this.getView().getFormShowParameter();
        String entity = param.getBillFormId();
        if (ROOTNODEID.equals(nodeId) || StringUtils.isBlank((CharSequence)nodeId)) {
            return null;
        }
        List<Long> groupIds = this.queryGroupsByGroupId(entity, nodeId);
        return new QFilter(PROP_ID, "in", groupIds);
    }

    public void treeNodeClick(TreeNodeEvent e) {
        String nodeId = e.getNodeId().toString();
        TreeNode rootNode = this.getTreeModel().getRoot();
        if (rootNode == null || rootNode.getTreeNode(nodeId, 20) == null) {
            return;
        }
        if (NO_GROUP.equals(nodeId)) {
            return;
        }
        this.treeListView.getTreeView().queryTreeNodeChildren(e.getParentNodeId().toString(), nodeId);
    }

    public void initialize() {
        this.templateTreeInitialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{OP_OPEN, BTNOK});
    }

    public void templateTreeInitialize() {
        ITreeModel treeModel;
        ITreeListView treeView = this.getTreeListView();
        if (treeView != null && (treeModel = treeView.getTreeModel()) instanceof TreeListModel) {
            if (treeModel.getGroupProp() instanceof ParentBasedataProp) {
                this.hideToolBar();
            }
            TreeListModel treeListModel = (TreeListModel)treeModel;
            BasedataEntityType entityType = treeListModel.getGroupProp().getEntityType();
            ListShowParameter param = new ListShowParameter();
            BaseDataCustomControllerEvent event = new BaseDataCustomControllerEvent((Object)this, param);
            List controllers = BasedataHelper.createPlugin((List)entityType.getBasedataControllersProp());
            for (IBasedataController controller : controllers) {
                controller.buildBaseDataCoreFilter(event);
            }
            param.getListFilterParameter().getQFilters().addAll(event.getQfilters());
            List ownFilters = param.getListFilterParameter().getQFilters();
            ArrayList filters = new ArrayList(ownFilters);
            treeListModel.getTreeFilter().addAll(filters);
        }
    }

    private void hideToolBar() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"btnnew", "btnedit", "btndel"});
    }

    public void initializeTree(EventObject e) {
        super.initializeTree(e);
        this.initTree();
    }

    public void refreshNode(RefreshNodeEvent e) {
        ITreeModel treeModel;
        String nodeId = e.getNodeId().toString();
        String isOpenAll = this.getPageCache().get("isOpenAll");
        boolean flag = false;
        if (Boolean.TRUE.toString().equals(isOpenAll)) {
            flag = true;
        }
        String textFormat = "";
        ITreeListView treeView = this.getTreeListView();
        if (treeView != null && (treeModel = treeView.getTreeModel()) instanceof TreeListModel) {
            TreeListModel treeListModel = (TreeListModel)treeModel;
            textFormat = treeListModel.getTextFormat();
        }
        List<TreeNode> treeNodes = this.getTreeChildren(nodeId, flag, flag, textFormat);
        e.setChildNodes(treeNodes);
    }

    private List<TreeNode> getTreeChildren(String nodeId, boolean isGetAllSub, boolean isOpen, String textFormat) {
        logger.info("getTreeChildren nodeId {}", (Object)nodeId);
        ListShowParameter param = (ListShowParameter)this.getView().getFormShowParameter();
        String entity = param.getBillFormId();
        if (ROOTNODEID.equals(nodeId)) {
            nodeId = "0";
        }
        QFilter qFilter2 = new QFilter(PROP_PARENT, "=", (Object)Long.valueOf(nodeId));
        List<QFilter> qFilters = new ArrayList<QFilter>(4);
        qFilters = this.addQFilters(qFilters, qFilter2);
        DynamicObjectCollection datas = QueryServiceHelper.query((String)entity, (String)"id,number,name,parent,level,longnumber,order", (QFilter[])qFilters.toArray(new QFilter[0]));
        List groups = datas.stream().sorted((a, b) -> a.getInt("order") - b.getInt("order")).collect(Collectors.toList());
        ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>(datas.size());
        HashSet<Long> parentIds = new HashSet<Long>(datas.size());
        for (DynamicObject group : groups) {
            if (group == null) continue;
            parentIds.add(group.getLong(PROP_ID));
        }
        SqlBuilder sql = new SqlBuilder();
        sql.append("select fparentid from t_dmw_import_target", new Object[0]);
        if (!parentIds.isEmpty()) {
            sql.append(" where ", new Object[0]);
            sql.appendIn("fparentid", new ArrayList(parentIds));
        }
        sql.append("group by fparentid", new Object[0]);
        Set parentids = (Set)DB.query((DBRoute)new DBRoute("imsc"), (SqlBuilder)sql, rs -> {
            HashSet<Long> pids = new HashSet<Long>(datas.size());
            while (rs != null && rs.next()) {
                pids.add(rs.getLong("fparentid"));
            }
            return pids;
        });
        QFilter leafFilter = null;
        String filterStr = (String)this.getView().getFormShowParameter().getCustomParam("l_f_s");
        if (StringUtils.isNotEmpty((CharSequence)filterStr)) {
            leafFilter = QFilter.of((String)filterStr, (Object[])new Object[0]);
        }
        for (DynamicObject group : groups) {
            if (group.getLong(PROP_ID) == 0L) continue;
            TreeNode treeNode = new TreeNode();
            HashMap<String, Integer> data = new HashMap<String, Integer>(1);
            treeNode.setId(group.getString(PROP_ID));
            Long parent = group.getLong(PROP_PARENT);
            treeNode.setParentid(parent == 0L ? ROOTNODEID : group.getString(PROP_PARENT));
            treeNode = this.getLocaleStringName(group, textFormat, treeNode);
            treeNode.setLongNumber(group.getString("longnumber"));
            int level = group.getInt("level");
            data.put("level", level);
            treeNode.setData(data);
            if (parentids.contains(group.getLong(PROP_ID))) {
                if (isGetAllSub) {
                    treeNode.addChildren(this.getTreeChildren(group.getString(PROP_ID), isGetAllSub, isOpen, textFormat));
                } else {
                    treeNode.addChildren(new ArrayList());
                }
            }
            if (isOpen) {
                treeNode.setIsOpened(isOpen);
            }
            boolean isAdd = true;
            isAdd = level == 1 ? this.isHaveLeafData(entity, leafFilter, group.getLong(PROP_ID)) : this.isLeafNodeAllowQFilter(entity, leafFilter, group.getLong(PROP_ID));
            if (!isAdd) continue;
            treeNodes.add(treeNode);
        }
        return treeNodes;
    }

    public void expendTreeNode(TreeNodeEvent e) {
        TreeNode rootNode = this.getTreeModel().getRoot();
        String nodeId = (String)e.getNodeId();
        if ((rootNode != null && !StringUtils.isBlank((CharSequence)nodeId) ? rootNode.getTreeNode(nodeId, 20) : null) == null) {
            return;
        }
        TreeNode node = this.getTreeListView().getTreeModel().refreshNode((Object)nodeId);
        if (node == null) {
            return;
        }
        node.setIsOpened(true);
        e.setExpandedNode(node);
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List filters = e.getQFilters();
        Iterator it = filters.iterator();
        while (it.hasNext()) {
            QFilter filter = (QFilter)it.next();
            if (!ROOTNODEID.equals(filter.getProperty())) continue;
            it.remove();
        }
        e.setMainOrgQFilter(null);
        String nodeId = this.getTreeListView().getTreeView().getTreeState().getFocusNodeId();
        QFilter filter = this.genRefreshFilter(nodeId);
        if (filter != null) {
            filters.add(filter);
        } else {
            filters.add(new QFilter("level", "!=", (Object)1));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if ("iscontainnow".equals(propertyName)) {
            BillList billList = (BillList)this.getControl(BILLLISTAP);
            billList.refresh();
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        BillList billList;
        ListSelectedRowCollection selectedRows;
        List collect;
        QFilter qFilter;
        DynamicObjectCollection query;
        Set labelSet;
        super.beforeClick(evt);
        String itemKey = ((Control)evt.getSource()).getKey();
        if (BTNOK.equals(itemKey) && (labelSet = (query = QueryServiceHelper.query((String)"dmw_importtarget", (String)"importcode", (QFilter[])(qFilter = new QFilter(PROP_ID, "in", collect = (selectedRows = (billList = (BillList)this.getControl(BILLLISTAP)).getSelectedRows()).stream().map(d -> (Long)d.getPrimaryKeyValue()).collect(Collectors.toList()))).toArray())).stream().map(q -> q.getString("importcode").split("\\.")[0]).collect(Collectors.toSet())).size() > 1) {
            evt.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u540c\u5206\u7ec4\u7684\u4e1a\u52a1\u5bf9\u8c61\uff0c\u5efa\u8bae\u5206\u5f00\u5efa\u7acb\u5bfc\u5165\u65b9\u6848", (String)"ImportTargetListPlugin_0", (String)"imsc-dmw-platform", (Object[])new Object[0]));
        }
    }

    private List<Long> queryGroupsByGroupId(String entity, Object id) {
        if (id == null) {
            return Collections.emptyList();
        }
        ArrayList<Long> list = new ArrayList<Long>();
        Long dataId = Long.valueOf(id.toString());
        QFilter filter = new QFilter(PROP_ID, "=", (Object)dataId);
        DynamicObject group = BusinessDataServiceHelper.loadSingleFromCache((String)entity, (String)"number,parent,level", (QFilter[])filter.toArray());
        list.add(dataId);
        if (group == null) {
            return list;
        }
        if (group.getInt("level") == 1) {
            list.clear();
        }
        String longNumberDlm = ".";
        MainEntityType dataEntityType = (MainEntityType)group.getDataEntityType();
        DynamicProperty property = dataEntityType.getProperty(PROP_PARENT);
        GroupProp grop = (GroupProp)property;
        if (grop instanceof ParentBasedataProp) {
            longNumberDlm = ((ParentBasedataProp)grop).getLongNumberDLM();
        }
        String longNumber = group.getString("number");
        QFilter f1 = new QFilter("longnumber", "like", (Object)(longNumber + longNumberDlm + "%"));
        ORM ormOv = ORM.create();
        try (DataSet ds = ormOv.queryDataSet(ImportTargetListPlugin.class.getName(), entity, PROP_ID, f1.toArray());){
            for (Row row : ds) {
                if (row.getLong(PROP_ID) == null) continue;
                list.add(row.getLong(PROP_ID));
            }
        }
        return list;
    }

    private boolean isHaveLeafData(String entryId, QFilter leafFilter, Object parentId) {
        QFilter parentFilter = new QFilter(PROP_PARENT, "=", parentId);
        if (leafFilter != null) {
            parentFilter.and(leafFilter);
        }
        return QueryServiceHelper.exists((String)entryId, (QFilter[])parentFilter.toArray());
    }

    private boolean isLeafNodeAllowQFilter(String entryId, QFilter leafFilter, Object id) {
        QFilter idFilter = new QFilter(PROP_ID, "=", id);
        if (leafFilter != null) {
            idFilter.and(leafFilter);
        }
        return QueryServiceHelper.exists((String)entryId, (QFilter[])idFilter.toArray());
    }
}

