/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.plugin.validator;

import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.imsc.dmw.helper.checker.DataCheckerBuilderFactory;
import kd.imsc.dmw.helper.checker.IDataChecker;
import kd.imsc.dmw.helper.checker.SchemeExportChecker;

public class SchemeImportValidator
extends AbstractValidator {
    public Set<String> preparePropertys() {
        Set set = super.preparePropertys();
        set.add("creator");
        set.add("enable");
        return set;
    }

    public void validate() {
        this.check();
    }

    private void check() {
        String operateKey = this.getOperateKey();
        if ("tblexport".equals(operateKey)) {
            if (ObjectUtils.isEmpty((Object[])this.dataEntities)) {
                return;
            }
            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                try {
                    DynamicObject dynamicObject = dataEntity.getDataEntity();
                    IDataChecker checker = DataCheckerBuilderFactory.getDataCheckerWithClassName(SchemeExportChecker.class.getName());
                    checker.dataCheck(dynamicObject);
                }
                catch (Exception e) {
                    this.addErrorMessage(dataEntity, e.getMessage());
                }
            }
        }
    }
}

