/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.utils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.imsc.dmw.utils.CommonUtils;
import kd.imsc.dmw.utils.StringUtil;

public class DynamicObjectUtils {
    private static final String F_BASEDATAID = "fbasedataid";

    private DynamicObjectUtils() {
    }

    public static <T> List<T> getBaseDataIds(DynamicObjectCollection dys) {
        ArrayList<Object> ids = new ArrayList<Object>(20);
        if (dys != null) {
            for (DynamicObject dy : dys) {
                ids.add(dy.getDynamicObject(F_BASEDATAID).getPkValue());
            }
        }
        return ids;
    }

    public static void setDynamicObjectLPkValue(DynamicObject data, String name, long pkValue) {
        data.set(String.join((CharSequence)"_", name, "id"), (Object)pkValue);
    }

    public static void setDynamicObjectSPkValue(DynamicObject data, String name, String pkValue) {
        data.set(String.join((CharSequence)"_", name, "id"), (Object)pkValue);
    }

    public static void setMultiF7Value(DynamicObject dObject, String multiF7Property, String multiF7EntityName, Object[] multiF7PKIds) {
        DynamicObjectCollection dObjectColletion = null;
        if (multiF7PKIds != null) {
            MulBasedataProp mulBaseDataProp = (MulBasedataProp)dObject.getDynamicObjectType().getProperty(multiF7Property);
            ArrayList<DynamicObject> dObjectList = new ArrayList<DynamicObject>(multiF7PKIds.length);
            for (Object pkId : multiF7PKIds) {
                DynamicObject basedata = new DynamicObject(mulBaseDataProp.getDynamicCollectionItemPropertyType());
                basedata.set("fbasedataid_id", pkId);
                DynamicObjectUtils.setF7Value(basedata, F_BASEDATAID, multiF7EntityName, pkId, null);
                dObjectList.add(basedata);
            }
            dObjectColletion = new DynamicObjectCollection(mulBaseDataProp.getDynamicCollectionItemPropertyType(), (Object)mulBaseDataProp.getParent(), dObjectList);
            dObject.set(multiF7Property, (Object)dObjectColletion);
        }
    }

    public static void setF7Value(DynamicObject dObject, String f7Property, String f7EntityName, Object pkId, Object defaultPkId) {
        if (pkId != null) {
            long pkid = Long.parseLong(pkId.toString());
            DynamicObject f7 = BusinessDataServiceHelper.newDynamicObject((String)f7EntityName);
            if (pkid > 0L) {
                f7.set("id", pkId);
                dObject.set(f7Property, (Object)f7);
            } else if (defaultPkId != null) {
                f7.set("id", defaultPkId);
                dObject.set(f7Property, (Object)f7);
            }
        }
    }

    public static Object getPkId(DynamicObject data, String name) {
        if (data == null) {
            return null;
        }
        Object idobject = data.get(name);
        if (idobject == null) {
            return null;
        }
        return idobject.getClass().equals(DynamicObject.class) ? ((DynamicObject)idobject).getPkValue() : idobject;
    }

    public static List<Object> getIdFromDynamicObjectEntry(DynamicObject data, String name) {
        ArrayList<Object> ids = new ArrayList<Object>();
        DynamicObjectCollection dynamicObjectCollection = data.getDynamicObjectCollection(name);
        if (CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) {
            return ids;
        }
        return dynamicObjectCollection.stream().map(m -> m.get("id")).collect(Collectors.toList());
    }

    public static int getInt(DynamicObject item, String key) {
        if (item == null || !item.getDynamicObjectType().getProperties().containsKey((Object)key) || item.get(key) == null) {
            return 0;
        }
        return item.getInt(key);
    }

    public static long getLong(DynamicObject item, String key) {
        if (item == null || !item.getDynamicObjectType().getProperties().containsKey((Object)key) || item.get(key) == null) {
            return 0L;
        }
        return item.getLong(key);
    }

    public static Object getObjectLong(DynamicObject item, String key) {
        if (item == null || !item.getDynamicObjectType().getProperties().containsKey((Object)key) || item.get(key) == null) {
            return null;
        }
        long id = DynamicObjectUtils.getPkValue(item, key);
        return id > 0L ? Long.valueOf(id) : null;
    }

    public static long getPkValue(DynamicObject item, String key) {
        Object o = DynamicObjectUtils.get(item, key);
        if (o instanceof DynamicObject) {
            return ((DynamicObject)o).getLong("id");
        }
        if (o instanceof Long || o instanceof String) {
            return Long.parseLong(o.toString());
        }
        if (item != null && item.getDynamicObjectType().getProperties().containsKey((Object)key)) {
            return item.getLong(String.join((CharSequence)"_", key, "id"));
        }
        return 0L;
    }

    public static long getPkValue(DynamicObject item) {
        return DynamicObjectUtils.getLong(item, "id");
    }

    public static String getStrPkValue(DynamicObject item, String key) {
        Object o = DynamicObjectUtils.get(item, "id");
        if (o instanceof DynamicObject) {
            return DynamicObjectUtils.getStrPkValue(DynamicObjectUtils.getDynamicObject(item, key));
        }
        if (o instanceof String) {
            return o.toString();
        }
        if (item != null && item.getDynamicObjectType().getProperties().containsKey((Object)key)) {
            return item.getString(String.join((CharSequence)"_", key, "id"));
        }
        return "";
    }

    public static String getStrPkValue(DynamicObject item) {
        return DynamicObjectUtils.getString(item, "id");
    }

    public static String getString(DynamicObject item, String key) {
        if (item == null || !item.getDynamicObjectType().getProperties().containsKey((Object)key) || item.get(key) == null) {
            return "";
        }
        return item.getString(key);
    }

    public static DynamicObject getDynamicObject(DynamicObject item, String key) {
        if (item == null || !item.getDynamicObjectType().getProperties().containsKey((Object)key) || item.get(key) == null) {
            return null;
        }
        return item.getDynamicObject(key);
    }

    public static BigDecimal getBigDecimal(DynamicObject item, String key) {
        if (item == null || !item.getDynamicObjectType().getProperties().containsKey((Object)key) || item.get(key) == null) {
            return BigDecimal.ZERO;
        }
        return item.getBigDecimal(key);
    }

    public static Object get(DynamicObject item, String key) {
        if (item == null || !item.getDynamicObjectType().getProperties().containsKey((Object)key) || item.get(key) == null) {
            return null;
        }
        return item.get(key);
    }

    public static boolean getBoolean(DynamicObject item, String key) {
        if (item == null || !item.getDynamicObjectType().getProperties().containsKey((Object)key) || item.get(key) == null) {
            return false;
        }
        return item.getBoolean(key);
    }

    public static DynamicObjectCollection getDynamicObjectCollection(DynamicObject item, String key) {
        if (item == null || !item.getDynamicObjectType().getProperties().containsKey((Object)key) || item.get(key) == null) {
            return null;
        }
        return item.getDynamicObjectCollection(key);
    }

    public static Date getDate(DynamicObject item, String key) {
        if (item == null || !item.getDynamicObjectType().getProperties().containsKey((Object)key) || item.getDate(key) == null) {
            return null;
        }
        return item.getDate(key);
    }

    public static List<Long> getIdList(DynamicObjectCollection collection) {
        ArrayList<Long> idList = new ArrayList<Long>();
        if (!CollectionUtils.isEmpty((Collection)collection)) {
            return collection.stream().map(s -> (Long)s.getPkValue()).collect(Collectors.toList());
        }
        return idList;
    }

    public static List<Long> getIdList(DynamicObject[] dynObjs) {
        if (!CommonUtils.isNull(dynObjs)) {
            ArrayList<Long> idList = new ArrayList<Long>(dynObjs.length);
            for (DynamicObject dynObj : dynObjs) {
                idList.add(dynObj.getLong("id"));
            }
            return idList;
        }
        return new ArrayList<Long>(0);
    }

    public static List<DynamicObject> convertDynamicObjList(ExtendedDataEntity[] datas) {
        if (datas == null || datas.length == 0) {
            return new ArrayList<DynamicObject>(0);
        }
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(datas.length);
        for (ExtendedDataEntity data : datas) {
            list.add(data.getDataEntity());
        }
        return list;
    }

    public static DynamicObject[] convertArrays(ExtendedDataEntity[] datas) {
        if (datas == null || datas.length == 0) {
            return new DynamicObject[0];
        }
        List<DynamicObject> list = DynamicObjectUtils.convertDynamicObjList(datas);
        return list.toArray(new DynamicObject[list.size()]);
    }

    public static List<DynamicObject> convertDynamicObjList(DynamicObjectCollection dynObjColl) {
        if (CommonUtils.isNull(dynObjColl)) {
            return new ArrayList<DynamicObject>(0);
        }
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(dynObjColl.size());
        for (DynamicObject dynObj : dynObjColl) {
            list.add(dynObj);
        }
        return list;
    }

    public static List<DynamicObject> convertSubDynObjList(DynamicObjectCollection dynObjColl, String subEntityKey) {
        if (CommonUtils.isNull(dynObjColl)) {
            return new ArrayList<DynamicObject>(0);
        }
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(dynObjColl.size() * 20);
        for (DynamicObject dynObj : dynObjColl) {
            DynamicObjectCollection subDynObjColl = dynObj.getDynamicObjectCollection(subEntityKey);
            list.addAll(subDynObjColl.stream().map(o -> o).collect(Collectors.toList()));
        }
        return list;
    }

    public static List<DynamicObject> convertEntryDynObjList(DynamicObject[] dynObjs, String entityKey) {
        if (CommonUtils.isNull(dynObjs)) {
            return new ArrayList<DynamicObject>(0);
        }
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(dynObjs.length * 50);
        for (DynamicObject dynObj : dynObjs) {
            DynamicObjectCollection subDynObjColl = dynObj.getDynamicObjectCollection(entityKey);
            list.addAll(subDynObjColl.stream().map(o -> o).collect(Collectors.toList()));
        }
        return list;
    }

    public static DynamicObject buildDynamicObject(String billType) {
        if (billType == null || billType.isEmpty()) {
            return null;
        }
        return BusinessDataServiceHelper.newDynamicObject((String)billType);
    }

    public static String autoNumber(DynamicObject dynamicObject, String billType, String orgId) {
        if (dynamicObject == null || billType == null || billType.isEmpty()) {
            return null;
        }
        CodeRuleInfo codeRuleInfo = CodeRuleServiceHelper.getCodeRule((String)billType, (DynamicObject)dynamicObject, (String)orgId);
        if (codeRuleInfo != null) {
            CodeRuleServiceHelper.getNumber((CodeRuleInfo)codeRuleInfo, (DynamicObject)dynamicObject);
            return codeRuleInfo.getNumber();
        }
        return dynamicObject.getString("id");
    }

    public static String getDynamicObjectStringValue(DynamicObject srcObject, String itemKey, String itemProp) {
        if (srcObject == null) {
            return "";
        }
        Object item = srcObject.get(itemKey);
        return item instanceof DynamicObject ? ((DynamicObject)item).getString(itemProp) : "";
    }

    public static Set<String> getMulcomboSet(String model) {
        if (StringUtil.isEmpty(model)) {
            return new HashSet<String>(4);
        }
        String[] split = model.split(",");
        return new HashSet<String>(Arrays.asList(split));
    }
}

