/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.imic.business.initscheme;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imsc.imic.common.CommonUtil;
import kd.imsc.imic.common.InitIalSchemeHelper;
import kd.imsc.imic.initscheme.InitSchemeEnabledService;

public class InitSchemeEnableServiceImpl
implements InitSchemeEnabledService {
    private static final Log logger = LogFactory.getLog(InitSchemeEnableServiceImpl.class);

    public Map<Object, Object> itemsEnable(List<Long> itemsPks) {
        return this.itemsEnabled(true, false, itemsPks);
    }

    public Map<Object, Object> itemsDisEnable(List<Long> itemsPks) {
        return this.itemsEnabled(false, false, itemsPks);
    }

    public Map<Object, Object> stepsEnable(List<Long> stepPks) {
        return this.itemsEnabled(true, true, stepPks);
    }

    public Map<Object, Object> stepsDisEnable(List<Long> stepPks) {
        return this.itemsEnabled(false, true, stepPks);
    }

    private Map<Object, Object> itemsEnabled(boolean isEnable, boolean isSteps, List<Long> pks) {
        HashMap<Object, Object> result = new HashMap<Object, Object>(2);
        boolean flag = true;
        StringBuilder errorMessage = new StringBuilder();
        MainEntityType initSchemeDt = MetadataServiceHelper.getDataEntityType((String)"imic_initialscheme");
        QFilter qFilter = null;
        qFilter = isSteps ? new QFilter("itemgroup.id", "in", pks) : new QFilter("itemgroup.imic_initentry_items.id", "in", pks);
        DynamicObject scheme = BusinessDataServiceHelper.loadSingle((String)"imic_initialscheme", (QFilter[])qFilter.toArray());
        if (Objects.isNull(scheme)) {
            flag = false;
            errorMessage.append(ResManager.loadKDString((String)"\u901a\u8fc7\u53c2\u6570ids\u672a\u627e\u5230\u5bf9\u5e94\u7684\u521d\u59cb\u5316\u65b9\u6848\uff0c\u8bf7\u786e\u8ba4\u53c2\u6570\u662f\u5426\u6b63\u786e", (String)"InitSchemeEnableServiceImpl_0", (String)"imsc-imic-platform", (Object[])new Object[0]));
            logger.info("imic\u542f\u7528\u7981\u7528\u4efb\u52a1\u9879\u5fae\u670d\u52a1\uff0c\u53c2\u6570ids: {}", pks);
        } else {
            DynamicObjectCollection stepGroups = scheme.getDynamicObjectCollection("itemgroup");
            ArrayList<Long> modifyItemsIds = new ArrayList<Long>(10);
            if (isSteps) {
                for (DynamicObject stepGroup : stepGroups) {
                    if (!pks.contains(stepGroup.getLong("id"))) continue;
                    Iterator itemsEntryRows = stepGroup.getDynamicObjectCollection("imic_initentry_items");
                    itemsEntryRows.forEach(l -> modifyItemsIds.add((Long)l.getPkValue()));
                }
            } else {
                modifyItemsIds.addAll(pks);
            }
            int itemsCount = 0;
            int disEnableCount = 0;
            for (DynamicObject stepGroup : stepGroups) {
                DynamicObjectCollection itemsEntryRows = stepGroup.getDynamicObjectCollection("imic_initentry_items");
                for (DynamicObject itemRow : itemsEntryRows) {
                    ++itemsCount;
                    Object pkValue = itemRow.getPkValue();
                    if (modifyItemsIds.contains(pkValue)) {
                        itemRow.set("itemenabled", (Object)isEnable);
                    }
                    if (itemRow.getBoolean("itemenabled")) continue;
                    ++disEnableCount;
                }
            }
            if (disEnableCount >= itemsCount) {
                flag = false;
                errorMessage.append(ResManager.loadKDString((String)"\u7981\u7528\u5931\u8d25\uff0c\u6240\u6709\u4efb\u52a1\u5747\u5df2\u88ab\u7981\u7528\uff0c\u8bf7\u81f3\u5c11\u5f00\u542f\u4e00\u4e2a\u4efb\u52a1\u9879", (String)"InitSchemeEnableServiceImpl_1", (String)"imsc-imic-platform", (Object[])new Object[0]));
            }
            if (flag) {
                try (TXHandle h1 = TX.required();){
                    try {
                        if (!isEnable) {
                            DeleteServiceHelper.delete((String)"imic_progressunit", (QFilter[])new QFilter("initialschemeentryid", "in", modifyItemsIds).toArray());
                            InitIalSchemeHelper.reCalculateSchemeProgress(scheme.getLong("id"));
                        }
                        SaveServiceHelper.save((IDataEntityType)initSchemeDt, (Object[])new DynamicObject[]{scheme});
                    }
                    catch (Exception e) {
                        logger.error("\u8c03\u7528\u521d\u59cb\u5316\u4efb\u52a1\u9879\u542f\u7528\u7981\u7528\u5fae\u670d\u52a1\u63a5\u53e3\u5931\u8d25", (Throwable)e);
                        flag = false;
                        errorMessage.append(CommonUtil.getExceptionDetailInfo(e));
                        h1.markRollback();
                    }
                }
            }
        }
        result.put("flag", flag);
        result.put("errorMessage", errorMessage.toString());
        return result;
    }
}

