/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.imic.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imsc.imic.common.StringUtils;
import kd.imsc.imic.common.deliveryinitial.ImicProgressunitConstant;

public class InitIalSchemeHelper {
    public static boolean existSchemeRecord(Object schemeId) {
        QFilter qFilter = new QFilter("initialscheme", "=", schemeId);
        boolean existCompleteRecord = QueryServiceHelper.exists((String)"imic_progressunit", (QFilter[])qFilter.toArray());
        boolean existAllotRecord = QueryServiceHelper.exists((String)"imic_assignrecord", (QFilter[])qFilter.toArray());
        return existCompleteRecord || existAllotRecord;
    }

    public static DynamicObject getInitialScheme(Object schemeId) {
        QFilter qFilter = new QFilter("id", "=", schemeId);
        return BusinessDataServiceHelper.loadSingleFromCache((String)"imic_initialscheme", (String)"id,bizapp,number,name,usedimension,dimensiontype,isalluse,enable", (QFilter[])qFilter.toArray());
    }

    public static QFilter[] getProgressUnitFilter(Long schemeId, String dimensionId) {
        return new QFilter[]{new QFilter(ImicProgressunitConstant.dimensiontId, "=", (Object)dimensionId), new QFilter(ImicProgressunitConstant.schemeId, "=", (Object)schemeId)};
    }

    public static List<DynamicObject> getProgressUnits(Long schemeId, String dimensionId) {
        String selectFields = String.join((CharSequence)",", "id", ImicProgressunitConstant.schemeEntryDetailId, ImicProgressunitConstant.completeUser, ImicProgressunitConstant.completeTime, ImicProgressunitConstant.completedItems, ImicProgressunitConstant.lastCompleted);
        DynamicObject[] progressesInDBArr = BusinessDataServiceHelper.load((String)ImicProgressunitConstant.formId, (String)selectFields, (QFilter[])InitIalSchemeHelper.getProgressUnitFilter(schemeId, dimensionId), (String)ImicProgressunitConstant.completeTime);
        return new ArrayList<DynamicObject>(Arrays.asList(progressesInDBArr));
    }

    public static List<DynamicObject> reCalculateSchemeProgress(long schemeId) {
        String selectFields = String.join((CharSequence)",", "id", ImicProgressunitConstant.schemeId, ImicProgressunitConstant.dimensiontId, ImicProgressunitConstant.completeUser, ImicProgressunitConstant.completeTime, ImicProgressunitConstant.completedItems);
        QFilter filter = new QFilter(ImicProgressunitConstant.schemeId, "=", (Object)schemeId);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)InitIalSchemeHelper.class.getName(), (String)ImicProgressunitConstant.formId, (String)selectFields, (QFilter[])filter.toArray(), null);
        GroupbyDataSet groupbyDataSet = dataSet.groupBy(new String[]{ImicProgressunitConstant.dimensiontId});
        HashMap<String, Long> maxProgressUnitMap = new HashMap<String, Long>(8);
        DataSet max = groupbyDataSet.max(ImicProgressunitConstant.completeTime).max("id").finish();
        for (Row row : max) {
            String dimensionId = row.getString(ImicProgressunitConstant.dimensiontId);
            Long id = row.getLong("id");
            maxProgressUnitMap.put(dimensionId, id);
        }
        dataSet = QueryServiceHelper.queryDataSet((String)InitIalSchemeHelper.class.getName(), (String)ImicProgressunitConstant.formId, (String)selectFields, (QFilter[])filter.toArray(), null);
        GroupbyDataSet groupByDataSet2 = dataSet.groupBy(new String[]{ImicProgressunitConstant.dimensiontId});
        DataSet rows = groupByDataSet2.count("size").finish();
        HashMap<Long, Integer> progressUnitSizeMap = new HashMap<Long, Integer>(8);
        for (Row row : rows) {
            String dimensionId = row.getString(ImicProgressunitConstant.dimensiontId);
            Integer size = row.getInteger("size");
            Long id = (Long)maxProgressUnitMap.get(dimensionId);
            progressUnitSizeMap.put(id, size);
        }
        Map unitMap = BusinessDataServiceHelper.loadFromCache((String)"imic_progressunit", (QFilter[])new QFilter("id", "in", progressUnitSizeMap.keySet()).toArray());
        ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>(10);
        for (Map.Entry longIntegerEntry : progressUnitSizeMap.entrySet()) {
            Long unitId = (Long)longIntegerEntry.getKey();
            Integer dmsnUnitSize = (Integer)longIntegerEntry.getValue();
            DynamicObject modifyUnit = (DynamicObject)unitMap.get(unitId);
            modifyUnit.set(ImicProgressunitConstant.completedItems, (Object)dmsnUnitSize);
            modifyUnit.set(ImicProgressunitConstant.lastCompleted, (Object)Boolean.TRUE);
            saveList.add(modifyUnit);
        }
        SaveServiceHelper.save((DynamicObject[])saveList.toArray(new DynamicObject[0]));
        return saveList;
    }

    public static List<Object> getSchemeIdsByBizAppId(String appId) {
        return InitIalSchemeHelper.getSchemeIdsByBizAppId(appId, true);
    }

    public static List<Object> getSchemeIdsByBizAppId(String appId, boolean enabled) {
        if (StringUtils.isBlank(appId)) {
            return null;
        }
        String isEnable = enabled ? "1" : "0";
        QFilter qFilter = new QFilter("bizapp_id", "=", (Object)appId);
        qFilter.and(new QFilter("enable", "=", (Object)isEnable));
        return QueryServiceHelper.queryPrimaryKeys((String)"imic_initialscheme", (QFilter[])qFilter.toArray(), null, (int)-1);
    }
}

