/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.imic.opplugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.imsc.imbd.opplugin.AbstractImbdOp;
import kd.imsc.imic.common.InitIalSchemeHelper;
import kd.imsc.imic.opplugin.validate.InitialSchemeEnableValidator;

public class InitialSchemeSaveOp
extends AbstractImbdOp {
    private static final String BIZ_APP = "bizapp";
    private static final String ENABLE = "enable";
    private static final String USE_DIMENSION = "usedimension";
    private static final String DIMENSION_TYPE = "dimensiontype";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add(BIZ_APP);
        e.getFieldKeys().add("itemgroup");
        e.getFieldKeys().add(ENABLE);
        e.getFieldKeys().add("imic_initentry_items");
        e.getFieldKeys().add(USE_DIMENSION);
        e.getFieldKeys().add(DIMENSION_TYPE);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new InitialSchemeEnableValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] oldSchemes;
        Set<Object> modifiedDmsnSchemePks;
        super.beginOperationTransaction(e);
        DynamicObject[] schemes = e.getDataEntities();
        ArrayList<Object> modifiedSchemeIds = new ArrayList<Object>();
        ArrayList<DynamicObject> modifiedSchemes = new ArrayList<DynamicObject>();
        for (DynamicObject scheme : schemes) {
            OperationResult disableResult;
            DynamicObject bizApp;
            QFilter qFilter;
            List otherSchemeIds;
            boolean isModify = scheme.getDataEntityState().getFromDatabase();
            boolean useDimension = scheme.getBoolean(USE_DIMENSION);
            if (isModify) {
                modifiedSchemeIds.add(scheme.getPkValue());
                modifiedSchemes.add(scheme);
                Set<Object> taskEntryIds = this.getTaskEntryIds(scheme);
                DynamicObject oldScheme = BusinessDataServiceHelper.loadSingle((Object)scheme.getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"imic_initialscheme"));
                Set<Object> oldSchmeTaskEntryIds = this.getTaskEntryIds(oldScheme);
                Set<Object> deletedTaskEntryIds = oldSchmeTaskEntryIds.stream().filter(element -> !taskEntryIds.contains(element)).collect(Collectors.toSet());
                this.findDisEnableItems(oldScheme, scheme, deletedTaskEntryIds);
                if (!deletedTaskEntryIds.isEmpty()) {
                    DeleteServiceHelper.delete((String)"imic_progressunit", (QFilter[])new QFilter("initialschemeentryid", "in", deletedTaskEntryIds).toArray());
                    InitIalSchemeHelper.reCalculateSchemeProgress(scheme.getLong("id"));
                }
            }
            boolean isEnable = scheme.getBoolean(ENABLE);
            if (useDimension || !isEnable || isModify || (otherSchemeIds = QueryServiceHelper.queryPrimaryKeys((String)"imic_initialscheme", (QFilter[])(qFilter = new QFilter(BIZ_APP, "=", (bizApp = scheme.getDynamicObject(BIZ_APP)).getPkValue()).and(new QFilter(ENABLE, "=", (Object)Boolean.TRUE)).and("id", "!=", scheme.getPkValue())).toArray(), null, (int)-1)).isEmpty() || (disableResult = OperationServiceHelper.executeOperate((String)"disable", (String)"imic_initialscheme", (Object[])otherSchemeIds.toArray(), (OperateOption)OperateOption.create())).isSuccess()) continue;
            this.operationResult.setSuccess(false);
            this.getOperationResult().setMessage(disableResult.getMessage() + disableResult.getAllErrorOrValidateInfo());
            return;
        }
        if (!modifiedSchemes.isEmpty() && !(modifiedDmsnSchemePks = this.getDmsnChangedSchemePks(modifiedSchemes, oldSchemes = BusinessDataServiceHelper.load((Object[])modifiedSchemeIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"imic_initialscheme")))).isEmpty()) {
            QFilter qFilter = new QFilter("initialscheme", "in", modifiedDmsnSchemePks);
            DeleteServiceHelper.delete((String)"imic_progressunit", (QFilter[])qFilter.toArray());
            DeleteServiceHelper.delete((String)"imic_assignrecord", (QFilter[])qFilter.toArray());
        }
    }

    private void findDisEnableItems(DynamicObject oldScheme, DynamicObject newScheme, Set<Object> deleteRecordItemsId) {
        Map<Long, DynamicObject> oldMapping = this.getSchemeItemsMapping(oldScheme);
        Map<Long, DynamicObject> newMapping = this.getSchemeItemsMapping(newScheme);
        for (Map.Entry<Long, DynamicObject> entry : oldMapping.entrySet()) {
            Long id = entry.getKey();
            DynamicObject oldItem = entry.getValue();
            DynamicObject newItem = newMapping.get(id);
            if (newItem == null) continue;
            boolean oldEnabled = oldItem.getBoolean("itemenabled");
            boolean newEnabled = newItem.getBoolean("itemenabled");
            if (!oldEnabled || newEnabled) continue;
            deleteRecordItemsId.add(id);
        }
    }

    private Map<Long, DynamicObject> getSchemeItemsMapping(DynamicObject scheme) {
        DynamicObjectCollection steps = scheme.getDynamicObjectCollection("itemgroup");
        HashMap<Long, DynamicObject> schemeItemsMapping = new HashMap<Long, DynamicObject>(8);
        for (DynamicObject step : steps) {
            DynamicObjectCollection items = step.getDynamicObjectCollection("imic_initentry_items");
            items.forEach(l -> schemeItemsMapping.put(l.getLong("id"), (DynamicObject)l));
        }
        return schemeItemsMapping;
    }

    private Set<Object> getTaskEntryIds(DynamicObject[] schemes) {
        HashSet<Object> schmeTaskEntryIds = new HashSet<Object>(8);
        for (DynamicObject oldScheme : schemes) {
            DynamicObjectCollection steps = oldScheme.getDynamicObjectCollection("itemgroup");
            for (DynamicObject step : steps) {
                DynamicObjectCollection taskEntrys = step.getDynamicObjectCollection("imic_initentry_items");
                taskEntrys.forEach(task -> schmeTaskEntryIds.add(task.getPkValue()));
            }
        }
        return schmeTaskEntryIds;
    }

    private Set<Object> getTaskEntryIds(DynamicObject scheme) {
        return this.getTaskEntryIds(new DynamicObject[]{scheme});
    }

    private Set<Object> getDmsnChangedSchemePks(List<DynamicObject> modifiedSchemes, DynamicObject[] oldSchemes) {
        HashSet<Object> modifiedDmsnSchemePks = new HashSet<Object>(8);
        block0: for (DynamicObject currScheme : modifiedSchemes) {
            Object currSchemeId = currScheme.getPkValue();
            for (DynamicObject oldScheme : oldSchemes) {
                boolean isDmsnChanged;
                boolean changeAllUse;
                Object oldSchemeId = oldScheme.getPkValue();
                if (!Objects.equals(currSchemeId, oldSchemeId)) continue;
                boolean useDimension = currScheme.getBoolean(USE_DIMENSION);
                DynamicObject dimensionType = currScheme.getDynamicObject(DIMENSION_TYPE);
                boolean isAllUse = currScheme.getBoolean("isalluse");
                boolean changeUse = useDimension != oldScheme.getBoolean(USE_DIMENSION);
                boolean changeDimension = false;
                boolean bl = changeAllUse = isAllUse != oldScheme.getBoolean("isalluse");
                if (useDimension && dimensionType != null) {
                    DynamicObject typeDb = (DynamicObject)oldScheme.get(DIMENSION_TYPE);
                    changeDimension = typeDb == null || !dimensionType.getPkValue().equals(typeDb.getPkValue());
                }
                boolean bl2 = isDmsnChanged = changeUse || changeDimension || changeAllUse;
                if (!isDmsnChanged) continue;
                modifiedDmsnSchemePks.add(currSchemeId);
                continue block0;
            }
        }
        return modifiedDmsnSchemePks;
    }
}

