/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.ebg.trd.banks.cib;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.concurrent.TimeUnit;
import kd.sdk.ebg.trd.exception.SDKException;
import netbank.firm.base.SystemProperty;
import netbank.firm.exception.DcfirmException;
import netbank.firm.exception.ExceptionCode;
import netbank.firm.handler.DcfirmChannelPromise;
import netbank.firm.handler.DefaultFileChannelInitializer;
import netbank.firm.handler.DefaultRequestFileHandler;
import netbank.firm.handler.DefaultResponseFileHandler;
import netbank.firm.model.DownloadRequest;

public class FileUtil {
    private String proxyHost;
    private int proxyPort;
    private int blockSize;
    private int startBlockId;
    private int connectionTimeOut;
    private String receivePath;

    private void init(String ip, int filePort, String fileReceivePath) throws SDKException {
        try {
            this.proxyHost = ip;
            this.proxyPort = filePort;
            this.receivePath = fileReceivePath;
            this.blockSize = Integer.parseInt(SystemProperty.getInstance().getProperty("file.transfer.blockSize", "4096"));
            this.startBlockId = Integer.parseInt(SystemProperty.getInstance().getProperty("file.transfer.startBlockId", "1"));
        }
        catch (Exception e) {
            throw new SDKException(ExceptionCode.C004.getCode(), e);
        }
        if (this.blockSize < 1024 || this.blockSize > 8192) {
            throw new SDKException(ExceptionCode.C004.getCode() + "block size between 1024 and 8192");
        }
        if (this.startBlockId < 1) {
            throw new SDKException(ExceptionCode.C004.getCode() + "startNum must be lager than 1");
        }
        this.connectionTimeOut = Integer.parseInt(SystemProperty.getInstance().getProperty("netty.connection.outtime.seconds", "60"));
    }

    public String downloadFile(String fileName, String fileId, String ip, int filePort, String fileReceivePath) throws SDKException {
        String filePath = "";
        this.init(ip, filePort, fileReceivePath);
        NioEventLoopGroup group = new NioEventLoopGroup();
        try {
            Bootstrap b = new Bootstrap();
            ((Bootstrap)((Bootstrap)((Bootstrap)b.group((EventLoopGroup)group)).channel(NioSocketChannel.class)).handler((ChannelHandler)new DefaultFileChannelInitializer())).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.connectionTimeOut);
            ChannelFuture ch = b.connect(this.proxyHost, this.proxyPort).sync();
            DcfirmChannelPromise promise = new DcfirmChannelPromise(ch.channel());
            promise.addListener((GenericFutureListener)((ChannelFutureListener)future -> {
                if (!future.isSuccess()) {
                    throw new DcfirmException(ExceptionCode.B214, future.cause());
                }
            }));
            this.appendRequestFileHandler(ch, (ChannelPromise)promise);
            this.appendResponseFilelHandler(ch, null, (ChannelPromise)promise);
            ch.addListener((GenericFutureListener)((ChannelFutureListener)future -> {
                if (!future.isSuccess()) {
                    throw new DcfirmException(ExceptionCode.B001.getCode(), future.cause().toString());
                }
                DownloadRequest downLoadRequest = new DownloadRequest();
                downLoadRequest.setFileId(fileId);
                downLoadRequest.setFileName(fileName);
                downLoadRequest.setStartNum(Integer.valueOf(this.startBlockId));
                downLoadRequest.setBlockSize(Integer.valueOf(this.blockSize));
                future.channel().writeAndFlush((Object)downLoadRequest).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
            }));
            promise.await(600L, TimeUnit.SECONDS);
            ch.channel().closeFuture().await(600L, TimeUnit.SECONDS);
            AttributeKey ak = AttributeKey.valueOf((String)"recvFile");
            String string = filePath = (String)ch.channel().attr(ak).get();
            return string;
        }
        catch (Throwable e) {
            throw new SDKException(e.getMessage(), e.getCause());
        }
        finally {
            group.shutdownGracefully();
        }
    }

    private void appendResponseFilelHandler(ChannelFuture ch, File sendFile, ChannelPromise promise) throws Exception {
        ChannelPipeline p = ch.channel().pipeline();
        DefaultResponseFileHandler responseFileHandler = new DefaultResponseFileHandler();
        if (sendFile != null) {
            if (!sendFile.exists()) {
                throw new FileNotFoundException();
            }
            responseFileHandler.setSendFile(sendFile);
            responseFileHandler.setBlockSize(this.blockSize);
            responseFileHandler.setStartBlockId(this.startBlockId);
        }
        responseFileHandler.setPromise(promise);
        p.addLast("sendFile", (ChannelHandler)responseFileHandler);
    }

    private void appendRequestFileHandler(ChannelFuture ch, ChannelPromise promise) throws Exception {
        ChannelPipeline p = ch.channel().pipeline();
        DefaultRequestFileHandler requestFileHandler = new DefaultRequestFileHandler();
        requestFileHandler.setPath(this.receivePath);
        requestFileHandler.setPromise(promise);
        p.addLast("re", (ChannelHandler)requestFileHandler);
    }
}

