/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.business.board.credit;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ssc.message.CreditBoardMessage;

public class CreditBoardDataConsumer
implements MessageConsumer {
    private static final Log log = LogFactory.getLog(CreditBoardDataConsumer.class);

    public void onMessage(Object message, String messageId, boolean isResend, MessageAcker messageAcker) {
        log.info("\u6210\u529f\u8fdb\u5165\u5171\u4eab\u770b\u677f\u5e95\u8868\u6570\u636e\u540c\u6b65\u6d88\u8d39\u8005\u5b9e\u73b0\u7c7b:" + this.getClass().getName() + "\uff0cmq\u4f20\u5165\u53c2\u6570: " + SerializationUtils.toJsonString((Object)message) + ", " + messageId);
        if (message == null || StringUtils.isBlank((CharSequence)(message + ""))) {
            log.error("\u5171\u4eab\u770b\u677f\u5e95\u8868\u6570\u636e\u540c\u6b65\u6d88\u606f\u961f\u5217\u4e2d message \u4e3a\u7a7a\uff08\u6216\u4e3anull\uff09,\u4e0d\u7528\u6d88\u8d39");
            messageAcker.ack(messageId);
            return;
        }
        try {
            this.consumer(message);
            log.info("\u5171\u4eab\u770b\u677f\u5e95\u8868\u6570\u636e\u540c\u6b65\u4fe1\u606f\u6210\u529f\u6d88\u8d39:" + this.getClass().getName() + "\uff0cmq\u4f20\u5165\u53c2\u6570: " + SerializationUtils.toJsonString((Object)message) + ", " + messageId);
        }
        catch (Exception e) {
            log.error("\u5171\u4eab\u770b\u677f\u5e95\u8868\u6570\u636e\u540c\u6b65\u6d88\u606f\u6d88\u8d39\u5931\u8d25", (Throwable)e);
            this.createMqErr(message, e, "kd.ssc.task.formplugin.creditboard.CreditBoardConfigPlugin.updateCreditBoardBaseDataMQ:message consume failed");
        }
        messageAcker.ack(messageId);
    }

    private void consumer(Object message) {
        DynamicObjectCollection boardEntryData;
        CreditBoardMessage messageParam = (CreditBoardMessage)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)message), CreditBoardMessage.class);
        String billTypeNumber = messageParam.getBillTypeNumber();
        String fieldName = messageParam.getFieldName();
        String fieldNumber = messageParam.getFieldNumber();
        Object fieldEntityNumber = messageParam.getFieldEntityNumber();
        QFilter qFilter = new QFilter("sscid", "=", messageParam.getSscId());
        qFilter.and(new QFilter("entry.bizbill", "=", (Object)billTypeNumber));
        qFilter.and(new QFilter("entry.billid", ">", (Object)0));
        qFilter.and(new QFilter("entry.bizsys", "=", (Object)427215148743160832L));
        DynamicObject[] boardDatas = BusinessDataServiceHelper.load((String)"ssc_creditboarddata", (String)"id,entry.id,entry.biztypeentity,entry.biztypename,entry.billid,entry.bizbill,entry.biztypeid", (QFilter[])new QFilter[]{qFilter}, (String)"entry.id asc", (int)messageParam.getPageIndex(), (int)messageParam.getPageSize());
        if (boardDatas == null || boardDatas.length == 0) {
            return;
        }
        HashSet billIds = new HashSet(16);
        Arrays.stream(boardDatas).forEach(boardData -> boardData.getDynamicObjectCollection("entry").forEach(data -> billIds.add(data.get("billid"))));
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)(billTypeNumber + ""), (String)("id," + fieldNumber), (QFilter[])new QFilter[]{new QFilter("id", "in", billIds)});
        Map<Object, Object> billIdMap = new HashMap(16);
        if (fieldNumber.contains(".")) {
            String entryEntity = fieldNumber.split("\\.")[0];
            String entryEntityFiled = fieldNumber.split("\\.")[1];
            for (DynamicObject bill2 : Arrays.asList(bills)) {
                DynamicObjectCollection collection = bill2.getDynamicObjectCollection(entryEntity);
                if (collection == null || collection.size() <= 0) continue;
                billIdMap.put(bill2.get("id"), ((DynamicObject)collection.get(0)).get(entryEntityFiled));
            }
        } else {
            billIdMap = Arrays.stream(bills).collect(Collectors.toMap(bill -> bill.get("id"), bill -> bill.get(fieldNumber)));
        }
        if (fieldEntityNumber != null && StringUtils.isNotEmpty((CharSequence)(fieldEntityNumber + ""))) {
            for (DynamicObject boardData2 : Arrays.asList(boardDatas)) {
                boardEntryData = boardData2.getDynamicObjectCollection("entry");
                for (DynamicObject data : boardEntryData) {
                    data.set("biztypeentity", fieldEntityNumber);
                    Object object = billIdMap.get(data.get("billid"));
                    if (object == null) continue;
                    DynamicObject field = (DynamicObject)object;
                    data.set("biztypeid", field.get("id"));
                    try {
                        data.set("biztypename", field.get("name"));
                    }
                    catch (Exception e) {
                        log.info(billTypeNumber + "(" + data.get("billid") + "),\u8be5\u5355\u636e\u7684\u5f15\u7528\u7684\u57fa\u7840\u8d44\u6599\u5c5e\u6027" + fieldEntityNumber + "(" + field.get("id") + "),\u672a\u5f15\u7528name\u5b57\u6bb5");
                    }
                }
            }
        } else {
            for (DynamicObject boardData2 : Arrays.asList(boardDatas)) {
                boardEntryData = boardData2.getDynamicObjectCollection("entry");
                for (DynamicObject data : boardEntryData) {
                    data.set("biztypeentity", (Object)"");
                }
            }
        }
        SaveServiceHelper.save((DynamicObject[])boardDatas);
    }

    private void createMqErr(Object message, Exception e, String mqexceptionmsg) {
        DynamicObject mqErrDyObj = BusinessDataServiceHelper.newDynamicObject((String)"task_mq_faile");
        mqErrDyObj.set("mqregion", (Object)"ssc");
        mqErrDyObj.set("mqqueue", (Object)"kd.ssc.task.ssc_creditboard_queue");
        mqErrDyObj.set("mqexceptionmsg", (Object)mqexceptionmsg);
        mqErrDyObj.set("mqexceptionstack_tag", (Object)this.getStackTrace(e));
        mqErrDyObj.set("mqexceptionhptime", (Object)new Date());
        mqErrDyObj.set("mqparam_tag", (Object)SerializationUtils.toJsonString((Object)message));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{mqErrDyObj});
    }

    public String getStackTrace(Throwable throwable) {
        StringBuilder stringBuilder = new StringBuilder("Exception:");
        if (throwable != null) {
            StackTraceElement[] elements;
            stringBuilder.append(throwable.getMessage()).append('\n');
            for (StackTraceElement e : elements = throwable.getStackTrace()) {
                stringBuilder.append('\t').append(e).append('\n');
            }
        }
        return stringBuilder.toString();
    }
}

