/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.business.boardv2.pojo;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.ssc.task.business.boardv2.helper.DataHelper;
import kd.ssc.task.business.boardv2.pojo.ChartData;
import kd.ssc.task.business.boardv2.pojo.ChartDataURL;
import kd.ssc.task.business.boardv2.pojo.MulSeriesData;

public class TaskTaskData {
    private static final Log log = LogFactory.getLog(TaskTaskData.class);
    private long sscId;
    private int[] taskCount = new int[3];
    public static final int DAILY = 0;
    public static final int MONTHLY = 1;
    public static final int YEARLY = 2;
    private int[] sscData = new int[4];
    public static final int TO_UPLOAD_IMAGE = 0;
    public static final int TO_BE_DIS = 1;
    public static final int PROCESSING = 2;
    public static final int EXPIRE = 3;
    private Map<Long, int[]> groupsData = new HashMap<Long, int[]>();
    public static final int GROUP_PROCESSING = 0;
    public static final int GROUP_EXPIRE = 1;
    public static final int GROUP_PAUSE = 2;
    private final String[] URL_PARAMS = new String[]{"formId=task_administrate&billFormId=task_task&pooltype=3&sources=TaskBusinessManageIndexPlugin&usergroupid=-1" + this.getCaption() + "&sscid=", "formId=task_administrate&billFormId=task_task&pooltype=0&sources=TaskBusinessManageIndexPlugin&usergroupid=-1" + this.getCaption() + "&sscid=", "formId=task_administrate&billFormId=task_task&pooltype=1&sources=TaskBusinessManageIndexPlugin&usergroupid=-1" + this.getCaption() + "&sscid=", "formId=task_administrate&billFormId=task_task&pooltype=1&expire=2&sources=TaskBusinessManageIndexPlugin&usergroupid=-1" + this.getCaption() + "&sscid="};

    public long getSscId() {
        return this.sscId;
    }

    public void setSscId(long sscId) {
        this.sscId = sscId;
    }

    public int[] getTaskCount() {
        return this.taskCount;
    }

    public void setTaskCount(int[] taskCount) {
        this.taskCount = taskCount;
    }

    public int[] getSscData() {
        return this.sscData;
    }

    public void setSscData(int[] sscData) {
        this.sscData = sscData;
    }

    public Map<Long, int[]> getGroupsData() {
        return this.groupsData;
    }

    public void setGroupsData(Map<Long, int[]> groupsData) {
        this.groupsData = groupsData;
    }

    private String getCaption() {
        String encode = ResManager.loadKDString((String)"\u4efb\u52a1\u7ba1\u7406", (String)"TaskTaskData_7", (String)"ssc-task-business", (Object[])new Object[0]);
        try {
            encode = URLEncoder.encode(encode, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error((Throwable)e);
        }
        return "&caption=" + encode;
    }

    public ChartData toChart1005() {
        ChartDataURL chartData = new ChartDataURL();
        chartData.setTitle(ResManager.loadKDString((String)"\u5f85\u529e\u4efb\u52a1", (String)"TaskTaskData_0", (String)"ssc-task-business", (Object[])new Object[0]));
        ArrayList<String> xAxis = new ArrayList<String>(4);
        chartData.setxAxis(xAxis);
        xAxis.add(ResManager.loadKDString((String)"\u5f85\u4e0a\u4f20\u5f71\u50cf", (String)"TaskTaskData_1", (String)"ssc-task-business", (Object[])new Object[0]));
        xAxis.add(ResManager.loadKDString((String)"\u5f85\u5206\u914d", (String)"TaskTaskData_2", (String)"ssc-task-business", (Object[])new Object[0]));
        xAxis.add(ResManager.loadKDString((String)"\u5904\u7406\u4e2d", (String)"TaskTaskData_3", (String)"ssc-task-business", (Object[])new Object[0]));
        xAxis.add(ResManager.loadKDString((String)"\u5df2\u8d85\u671f", (String)"TaskTaskData_4", (String)"ssc-task-business", (Object[])new Object[0]));
        MulSeriesData mulSeriesData = new MulSeriesData();
        for (int sscDatum : this.sscData) {
            mulSeriesData.addData((Object)sscDatum);
        }
        chartData.addSeries(mulSeriesData);
        chartData.setUrl(Arrays.stream(this.URL_PARAMS).map(p -> p + this.sscId).collect(Collectors.toList()));
        return chartData;
    }

    public ChartData toChart1006() {
        ChartData chartData = new ChartData();
        chartData.setTitle(ResManager.loadKDString((String)"\u5404\u7ec4\u5b9e\u65f6\u4efb\u52a1\u5904\u7406\u60c5\u51b5", (String)"TaskTaskData_5", (String)"ssc-task-business", (Object[])new Object[0]));
        ArrayList<String> xAxis = new ArrayList<String>(4);
        chartData.setxAxis(xAxis);
        List<String> seriesName = Arrays.asList(ResManager.loadKDString((String)"\u5904\u7406\u4e2d", (String)"TaskTaskData_3", (String)"ssc-task-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5df2\u8d85\u671f", (String)"TaskTaskData_4", (String)"ssc-task-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6682\u6302", (String)"TaskTaskData_6", (String)"ssc-task-business", (Object[])new Object[0]));
        for (int i = 0; i < 3; ++i) {
            MulSeriesData mulSeriesData = new MulSeriesData();
            mulSeriesData.setName(seriesName.get(i));
            ArrayList<Object> dataList = new ArrayList<Object>();
            mulSeriesData.setData(dataList);
            chartData.addSeries(mulSeriesData);
        }
        Map<Object, DynamicObject> workGroupMap = DataHelper.getWorkGroupFromCache(this.sscId);
        for (Map.Entry<Object, DynamicObject> entry : workGroupMap.entrySet()) {
            DynamicObject workGroupDyo = entry.getValue();
            xAxis.add(workGroupDyo.getString("name"));
            for (int i = 0; i < 3; ++i) {
                chartData.getSeries().get(i).addData((Object)0);
            }
            DynamicObjectCollection groups = workGroupDyo.getDynamicObjectCollection("entryentity");
            for (DynamicObject group : groups) {
                Long pkValue = group.getLong("usergroup_id");
                int[] ints = this.groupsData.getOrDefault(pkValue, new int[]{0, 0, 0});
                for (int i = 0; i < 3; ++i) {
                    List<Object> data = chartData.getSeries().get(i).getData();
                    data.set(data.size() - 1, Integer.parseInt(data.get(data.size() - 1).toString()) + ints[i]);
                }
            }
        }
        return chartData;
    }
}

