/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.business.boardv2.query;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.ssc.task.business.boardv2.pojo.BillCreditLose;
import kd.ssc.task.business.boardv2.pojo.CreditLose;

public class CreditExpenseItemStatistics {
    private static final Log logger = LogFactory.getLog(CreditExpenseItemStatistics.class);

    public static void statistics(Map<String, Object> sourceDataMap, Map<Long, Map<Object, CreditLose>> billTypeCreditMap) {
        QFilter qFilter = new QFilter("billtype.number", "in", sourceDataMap.get("billEntity"));
        DynamicObject[] configs = BusinessDataServiceHelper.load((String)"task_creditboardconfig_", (String)"id,createorg,billtype,fieldname,fieldnumber,fieldentitynumber", (QFilter[])qFilter.toArray());
        if (configs == null || configs.length == 0) {
            logger.info("CreditExpenseItemStatistics configs.length == 0, qFilter = " + qFilter);
            return;
        }
        HashMap<String, DynamicObject> configMap = new HashMap<String, DynamicObject>(configs.length);
        Arrays.stream(configs).forEach(config -> {
            Object createOrg = config.get("createorg.id");
            Object billEntity = config.get("billtype.number");
            String keyLike = createOrg + "#" + billEntity;
            configMap.put(keyLike, (DynamicObject)config);
        });
        Map billInfo = (Map)sourceDataMap.get("billInfo");
        configMap.forEach((key, config) -> {
            String fieldNumber = config.getString("fieldnumber");
            String fieldEntityNumber = config.getString("fieldentitynumber");
            if (StringUtils.isEmpty((CharSequence)fieldNumber)) {
                return;
            }
            String[] keys = key.split("#");
            String sscId = keys[0];
            Long sscIdLong = Long.parseLong(sscId);
            String billEntity = keys[1];
            DynamicObject[] bills = BusinessDataServiceHelper.load((String)billEntity, (String)("id," + fieldNumber), (QFilter[])new QFilter("id", "in", billInfo.get(key)).toArray());
            if (bills != null && bills.length > 0) {
                Arrays.stream(bills).forEach(value -> {
                    try {
                        if (fieldNumber.contains(".")) {
                            String entryEntity = fieldNumber.split("\\.")[0];
                            String entryEntityFiled = fieldNumber.split("\\.")[1];
                            DynamicObjectCollection collection = value.getDynamicObjectCollection(entryEntity);
                            if (collection != null && !collection.isEmpty()) {
                                for (DynamicObject dyo : collection) {
                                    CreditExpenseItemStatistics.statisticsData(dyo.getDynamicObject(entryEntityFiled), sscIdLong, fieldEntityNumber, billTypeCreditMap);
                                }
                            }
                        } else {
                            CreditExpenseItemStatistics.statisticsData(value.getDynamicObject(fieldNumber), sscIdLong, fieldEntityNumber, billTypeCreditMap);
                        }
                    }
                    catch (Exception e) {
                        logger.error("CreditExpenseItemStatistics bill get expense error.", (Throwable)e);
                    }
                });
            }
        });
    }

    public static void statisticsData(DynamicObject dyo, Long sscId, String fieldEntityNumber, Map<Long, Map<Object, CreditLose>> billTypeCreditMap) {
        Map billCreditMap = billTypeCreditMap.computeIfAbsent(sscId, p -> new HashMap(16));
        CreditLose billCreditLose = billCreditMap.computeIfAbsent(dyo.get("id"), p -> new BillCreditLose(dyo.get("id"), new BigDecimal(0), fieldEntityNumber));
        billCreditLose.add(new BigDecimal(1));
    }
}

