/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.business.helper;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.org.model.OrgRelationParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.ssc.task.business.helper.DutyManageDataHelper;

public class OrgRelationQueryHelper {
    public static final Long UNIT2SSC_RELATION_TYPE_ID = 1977681855570258944L;
    public static final String ENTITY_ORGRELATION = "bos_org_orgrelation";

    public static List<Long> getFromOrgList(long sscOrgId) {
        OrgRelationParam param = new OrgRelationParam();
        param.setOrgId(sscOrgId);
        param.setToViewType("12");
        param.setDirectViewType("fromorg");
        param.setIncludeSelf(true);
        return OrgUnitServiceHelper.getBizRelationOrgIds((OrgRelationParam)param);
    }

    public static List<Long> getFromOrgList(long sscOrgId, boolean includeSelf) {
        OrgRelationParam param = new OrgRelationParam();
        param.setOrgId(sscOrgId);
        param.setToViewType("12");
        param.setDirectViewType("fromorg");
        param.setIncludeSelf(includeSelf);
        return OrgUnitServiceHelper.getBizRelationOrgIds((OrgRelationParam)param);
    }

    public static List<Long> loadOrgRelationFromDb(Long sscOrgId) {
        if (sscOrgId == null || sscOrgId == 0L) {
            return null;
        }
        QFilter reFilter = new QFilter("typerelation", "=", (Object)UNIT2SSC_RELATION_TYPE_ID);
        QFilter filter = new QFilter("toorg", "=", (Object)sscOrgId);
        QFilter[] filters = new QFilter[]{reFilter, filter};
        DynamicObjectCollection relationCol = QueryServiceHelper.query((String)ENTITY_ORGRELATION, (String)"id,fromorg", (QFilter[])filters);
        if (relationCol == null || relationCol.size() < 1) {
            return null;
        }
        return relationCol.stream().map(r -> r.getLong("fromorg")).distinct().collect(Collectors.toList());
    }

    public static List<Long> getFromOrgListFilterDutyScope(long sscOrgId, boolean includeSelf) {
        List<Long> orgIds = OrgRelationQueryHelper.getFromOrgList(sscOrgId, includeSelf);
        List<String> dutyScope = DutyManageDataHelper.querySSCDutyScope(sscOrgId);
        if (dutyScope == null) {
            return orgIds;
        }
        ArrayList<Long> orgIds_ = new ArrayList<Long>(orgIds);
        for (String dutyType : dutyScope) {
            if (orgIds_.size() == 0) {
                return orgIds;
            }
            orgIds_.removeAll(OrgUnitServiceHelper.filterOrgDuty(orgIds_, (String)dutyType));
        }
        orgIds.removeAll(orgIds_);
        return orgIds;
    }

    public static List<Long> getToSSCList(long bizOrgId) {
        OrgRelationParam param = new OrgRelationParam();
        param.setOrgId(bizOrgId);
        param.setToViewType("12");
        param.setDirectViewType("toorg");
        param.setIncludeSelf(false);
        return OrgUnitServiceHelper.getBizRelationOrgIds((OrgRelationParam)param);
    }
}

