/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.business.helper;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.workflow.engine.dynprocess.freeflow.WFAuditTask;
import kd.bos.workflow.engine.dynprocess.freeflow.WFCustomParam;
import kd.bos.workflow.engine.dynprocess.freeflow.WFFlowElement;

public class WorkFlowCreditHelper {
    private static final Log log = LogFactory.getLog(WorkFlowCreditHelper.class);
    private static final String CREDIT_CONTROL = "creditcontrol_ssc";
    private static final String CREDIT_SUBSCORE_INFO = "creditSubScoreInfo";

    public static Boolean isOpenCreditControlByHisTask(long historyTaskId) {
        String taskDefinitionKey = WorkFlowCreditHelper.getTaskDefinitionKey(historyTaskId);
        if (StringUtils.isEmpty((CharSequence)taskDefinitionKey)) {
            return null;
        }
        return WorkFlowCreditHelper.isOpenCreditControl(taskDefinitionKey);
    }

    private static Boolean isOpenCreditControl(String taskDefinitionKey) {
        if (StringUtils.isEmpty((CharSequence)taskDefinitionKey)) {
            return null;
        }
        int i = taskDefinitionKey.lastIndexOf("_");
        if (i < 1) {
            return null;
        }
        String processDefinitionKey = taskDefinitionKey.substring(0, i);
        List elements = WorkflowServiceHelper.getProcessElements((String)processDefinitionKey, null);
        for (WFFlowElement element : elements) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)element.getId(), (CharSequence)taskDefinitionKey)) continue;
            List customParams = ((WFAuditTask)element).getCustomParams();
            for (WFCustomParam customParam : customParams) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)customParam.getNumber(), (CharSequence)CREDIT_CONTROL)) continue;
                return StringUtils.equalsIgnoreCase((CharSequence)customParam.getValue(), (CharSequence)"true");
            }
        }
        return null;
    }

    public static Boolean isOpenCreditControlByTaskId(DynamicObject taskInfo) {
        String assignId = taskInfo.getString("assignid");
        if (StringUtils.isEmpty((CharSequence)assignId)) {
            return null;
        }
        DynamicObject wfTask = WorkFlowCreditHelper.getWfHiTaskInst(Long.parseLong(assignId));
        if (wfTask == null) {
            return null;
        }
        String taskDefinitionKey = wfTask.getString("taskdefinitionkey");
        return WorkFlowCreditHelper.isOpenCreditControl(taskDefinitionKey);
    }

    public static DynamicObject getWfHiTaskInst(long assignId) {
        return QueryServiceHelper.queryOne((String)"wf_hitaskinst", (String)"name,processdefinitionid, processinstanceid, taskdefinitionkey", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)assignId)});
    }

    private static String getTaskDefinitionKey(long historyTaskId) {
        DynamicObject sscWfTask = QueryServiceHelper.queryOne((String)"task_wftask", (String)"taskdefinitionkey", (QFilter[])new QFilter[]{new QFilter("taskhistoryid", "=", (Object)historyTaskId)});
        if (sscWfTask == null) {
            return "";
        }
        return sscWfTask.getString("taskdefinitionkey");
    }

    public static void updateWfVariable(Long procInstId, String value) {
        WorkflowServiceHelper.setProcessInstanceVariable((Long)procInstId, (String)CREDIT_SUBSCORE_INFO, (Object)value);
    }

    public static String getWfVariable(Long procInstId) {
        Map variablesByProcInstId = WorkflowServiceHelper.getVariablesByProcInstId((Long)procInstId, (String[])new String[]{CREDIT_SUBSCORE_INFO});
        if (variablesByProcInstId == null || variablesByProcInstId.isEmpty()) {
            return null;
        }
        return (String)variablesByProcInstId.get(CREDIT_SUBSCORE_INFO);
    }
}

