/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.business.task;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ssc.enums.TaskStateEnum;

public class TaskPriorityHelper {
    public static List<Map<String, Object>> updateTaskPriority(List<Map<String, Object>> billInfoList, Integer taskPriority) {
        HashMap<String, String> billIdTypeMap = new HashMap<String, String>(10);
        for (Map<String, Object> map2 : billInfoList) {
            billIdTypeMap.put(String.valueOf(map2.get("billId")), (String)map2.get("billType"));
        }
        Map<Long, Map<String, Object>> taskInfoList = TaskPriorityHelper.getTaskPriorityInfoByBillIdList(billInfoList.stream().map(m -> "'" + m.get("billId") + "'").collect(Collectors.toList()));
        HashSet<String> billIdSet = new HashSet<String>();
        billInfoList.forEach(map -> billIdSet.add(String.valueOf(map.get("billId"))));
        return TaskPriorityHelper.checkBillTaskAndModifyPriority(taskInfoList, taskPriority, billIdTypeMap, billIdSet);
    }

    private static Map<Long, Map<String, Object>> getTaskPriorityInfoByBillIdList(List<String> billIdList) {
        HashMap<Long, Map<String, Object>> resultMap = new HashMap<Long, Map<String, Object>>(billIdList.size());
        ArrayList<String> billTypeIds = new ArrayList<String>(10);
        String sql = "select a.fid,a.fbillid,a.ftasktypeid,a.fbillnumber,a.fbilltypeid,c.fbindbill,a.fsubject,a.ftasklevelid,b.fpriority,a.fqualitysamplelibraryid,a.fstate from t_tk_task a left join t_tk_tasklevel b on a.ftasklevelid = b.fid left join t_tk_taskmainbill c on a.fbilltypeid = c.fid where a.fbillid in (%s) and a.fqualitysamplelibraryid = 0 ";
        String param = StringUtils.join((Object[])billIdList.toArray(), (String)",");
        try (DataSet ds = DB.queryDataSet((String)"kd.ssc.TaskPriorityHelper.queryTask", (DBRoute)DBRoute.of((String)"ssc"), (String)String.format(sql, param));){
            while (ds.hasNext()) {
                Row row = ds.next();
                Long taskId = row.getLong("fid");
                HashMap<String, Object> taskDetail = new HashMap<String, Object>(8);
                String bindBillId = row.getString("fbindbill");
                taskDetail.put("taskTypeId", row.getLong("ftasktypeid"));
                taskDetail.put("billType", bindBillId);
                taskDetail.put("billId", row.getString("fbillid"));
                taskDetail.put("subject", row.getString("fsubject"));
                taskDetail.put("taskLevelId", row.getLong("ftasklevelid"));
                taskDetail.put("level", row.getInteger("fpriority"));
                taskDetail.put("isQualityTask", row.getLong("fqualitysamplelibraryid") != 0L);
                taskDetail.put("state", row.getString("fstate"));
                taskDetail.put("billNo", row.getString("fbillnumber"));
                resultMap.put(taskId, taskDetail);
                billTypeIds.add(bindBillId);
            }
        }
        if (billTypeIds.size() > 0) {
            DynamicObjectCollection collect = QueryServiceHelper.query((String)"bos_formmeta", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("id", "in", billTypeIds)});
            HashMap billTypeInfo = new HashMap(collect.size());
            collect.forEach(dynamicObject -> billTypeInfo.put(dynamicObject.getString("id"), dynamicObject.getString("number")));
            for (Map.Entry entry : resultMap.entrySet()) {
                Map taskInfo = (Map)entry.getValue();
                String billTypeId = (String)taskInfo.get("billType");
                taskInfo.put("billType", billTypeInfo.get(billTypeId));
            }
        }
        return resultMap;
    }

    private static List<Map<String, Object>> checkBillTaskAndModifyPriority(Map<Long, Map<String, Object>> taskInfoMap, Integer targetLevel, Map<String, String> billIdTypeMap, Set<String> billIdSet) {
        Set<String> trueBillTypeSet = TaskPriorityHelper.checkbillType(new HashSet<String>(billIdTypeMap.values()));
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>(10);
        if (taskInfoMap.size() == 0) {
            for (Map.Entry<String, String> entry : billIdTypeMap.entrySet()) {
                HashMap<String, Object> taskDetail = new HashMap<String, Object>(8);
                taskDetail.put("billNo", "");
                taskDetail.put("taskId", 0);
                taskDetail.put("billType", entry.getValue());
                taskDetail.put("billId", entry.getKey());
                taskDetail.put("success", Boolean.FALSE);
                if (trueBillTypeSet.contains(entry.getValue())) {
                    taskDetail.put("msg", ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u672a\u627e\u5230\u5171\u4eab\u4efb\u52a1\u3002", (String)"TaskPriorityHelper_4", (String)"ssc-task-business", (Object[])new Object[0]));
                } else {
                    taskDetail.put("msg", ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b\u4e0d\u5b58\u5728\u3002", (String)"TaskPriorityHelper_5", (String)"ssc-task-business", (Object[])new Object[0]));
                }
                resultList.add(taskDetail);
            }
            return resultList;
        }
        HashMap<Long, Map<String, Object>> taskTargetLevelMap = new HashMap<Long, Map<String, Object>>(taskInfoMap.size());
        Map<Long, Map<Integer, Map<String, Object>>> taskSelectAblePriority = TaskPriorityHelper.getTaskSelectAblePriority(taskInfoMap.keySet());
        for (Map.Entry<Long, Map<String, Object>> entry : taskInfoMap.entrySet()) {
            Long taskId = entry.getKey();
            Map<String, Object> taskInfo = entry.getValue();
            String billId = (String)taskInfo.get("billId");
            HashMap<String, Object> taskDetail = new HashMap<String, Object>(8);
            taskDetail.put("billId", billId);
            String billType = billIdTypeMap.get(billId);
            taskDetail.put("billType", billType);
            billIdSet.remove(billId);
            resultList.add(taskDetail);
            if (!trueBillTypeSet.contains(billType)) {
                taskDetail.put("billNo", "");
                taskDetail.put("taskId", 0);
                taskDetail.put("success", Boolean.FALSE);
                taskDetail.put("msg", ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b\u4e0d\u5b58\u5728\u3002", (String)"TaskPriorityHelper_5", (String)"ssc-task-business", (Object[])new Object[0]));
                continue;
            }
            if (!billType.equals(taskInfo.get("billType"))) {
                taskDetail.put("billNo", "");
                taskDetail.put("taskId", 0);
                taskDetail.put("success", Boolean.FALSE);
                taskDetail.put("msg", ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b\u9519\u8bef", (String)"TaskPriorityHelper_6", (String)"ssc-task-business", (Object[])new Object[0]));
                continue;
            }
            taskDetail.put("billNo", taskInfo.get("billNo"));
            taskDetail.put("taskId", taskId);
            String state = (String)taskInfo.get("state");
            if (!(state.equals(TaskStateEnum.TO_BE_DIS.getValue()) || state.equals(TaskStateEnum.DIS_EXCEPTION.getValue()) || state.equals(TaskStateEnum.TO_BE_AUDIT.getValue()) || state.equals(TaskStateEnum.REUPLOAD_IMAGE.getValue()))) {
                taskDetail.put("success", Boolean.FALSE);
                taskDetail.put("msg", ResManager.loadKDString((String)"\u53ea\u6709\u201c\u5f85\u5206\u914d\u201d\u3001\u201c\u5206\u914d\u5f02\u5e38\u201d\u3001\u201c\u5f85\u5904\u7406\u201d\u6216\u201c\u5f71\u50cf\u91cd\u4f20\u201d\u72b6\u6001\u7684\u4efb\u52a1\u624d\u53ef\u4ee5\u4fee\u6539\u4f18\u5148\u7ea7\u3002", (String)"TaskPriorityHelper_0", (String)"ssc-task-business", (Object[])new Object[0]));
                continue;
            }
            Map<Integer, Map<String, Object>> targetPriority = taskSelectAblePriority.get(taskId);
            if (targetPriority == null || targetPriority.get(targetLevel) == null) {
                taskDetail.put("success", Boolean.FALSE);
                taskDetail.put("msg", ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u672a\u914d\u7f6e\u8be5\u4f18\u5148\u7ea7", (String)"TaskPriorityHelper_1", (String)"ssc-task-business", (Object[])new Object[0]));
                continue;
            }
            BigDecimal taskDuration = (BigDecimal)targetPriority.get(targetLevel).get("timeliness");
            if (taskDuration == null) {
                taskDetail.put("success", Boolean.FALSE);
                taskDetail.put("msg", ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u7684\u76ee\u6807\u4f18\u5148\u7ea7\u672a\u914d\u7f6e\u65f6\u6548\u3002", (String)"TaskPriorityHelper_3", (String)"ssc-task-business", (Object[])new Object[0]));
                continue;
            }
            Integer level = (Integer)taskInfo.get("level");
            if (level < targetLevel) {
                taskDetail.put("success", Boolean.FALSE);
                taskDetail.put("msg", ResManager.loadKDString((String)"\u4efb\u52a1\u4f18\u5148\u7ea7\u9ad8\u4e8e\u76ee\u6807\u4f18\u5148\u7ea7\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u4e3a\u4f4e\u4f18\u5148\u7ea7\u3002", (String)"TaskPriorityHelper_2", (String)"ssc-task-business", (Object[])new Object[0]));
                continue;
            }
            if (level.equals(targetLevel)) {
                taskDetail.put("success", Boolean.FALSE);
                taskDetail.put("msg", ResManager.loadKDString((String)"\u4efb\u52a1\u5df2\u662f\u76ee\u6807\u4f18\u5148\u7ea7\u3002", (String)"TaskPriorityHelper_7", (String)"ssc-task-business", (Object[])new Object[0]));
                continue;
            }
            taskDetail.put("success", Boolean.TRUE);
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("targetLevel", targetPriority.get(targetLevel).get("level"));
            data.put("timeLiness", targetPriority.get(targetLevel).get("timeliness"));
            data.put("billTyepId", taskInfo.get("billTypeId"));
            data.put("taskTypeId", taskInfo.get("taskTypeId"));
            taskTargetLevelMap.put(taskId, data);
        }
        if (billIdSet.size() > 0) {
            for (String billId : billIdSet) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("billId", String.valueOf(billId));
                map.put("billType", "");
                map.put("taskId", 0);
                map.put("billNo", "");
                map.put("success", Boolean.FALSE);
                map.put("msg", ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u672a\u627e\u5230\u5171\u4eab\u4efb\u52a1\u3002", (String)"TaskPriorityHelper_4", (String)"ssc-task-business", (Object[])new Object[0]));
                resultList.add(map);
            }
        }
        TaskPriorityHelper.modifyPriorityAndRecordStateChange(taskTargetLevelMap);
        return resultList;
    }

    private static void modifyPriorityAndRecordStateChange(Map<Long, Map<String, Object>> taskInfo) {
        if (taskInfo.size() == 0) {
            return;
        }
        QFilter idFilter = new QFilter("id", "in", taskInfo.keySet());
        DynamicObject[] taskDos = BusinessDataServiceHelper.load((String)"task_task", (String)"id,tasktypeid.id,tasklevelid", (QFilter[])idFilter.toArray());
        ArrayList<DynamicObject> stateChangeInfoList = new ArrayList<DynamicObject>(10);
        if (taskDos != null && taskDos.length > 0) {
            for (DynamicObject task : taskDos) {
                Long taskId = task.getLong("id");
                task.set("tasklevelid", (Object)((Long)taskInfo.get(taskId).get("targetLevel")));
                DynamicObject stateChangeInfo = BusinessDataServiceHelper.newDynamicObject((String)"task_statechange");
                Long operatorid = Long.valueOf(RequestContext.get().getUserId());
                Timestamp changetime = new Timestamp(System.currentTimeMillis());
                stateChangeInfo.set("operatorid", (Object)operatorid);
                stateChangeInfo.set("operation", (Object)"22");
                stateChangeInfo.set("changetime", (Object)changetime);
                stateChangeInfo.set("jobid", (Object)taskId);
                stateChangeInfo.set("innermsg", (Object)ResManager.loadKDString((String)"API\u8c03\u7528\u4fee\u6539", (String)"TaskPriorityHelper_8", (String)"ssc-task-business", (Object[])new Object[0]));
                stateChangeInfo.set("tasktype", (Object)((Long)taskInfo.get(taskId).get("taskTypeId")));
                stateChangeInfo.set("billtype", (Object)((Long)taskInfo.get(taskId).get("billTypeId")));
                stateChangeInfoList.add(stateChangeInfo);
            }
            SaveServiceHelper.save((DynamicObject[])taskDos);
            SaveServiceHelper.save((DynamicObject[])stateChangeInfoList.toArray(new DynamicObject[0]));
        }
    }

    private static Set<String> checkbillType(Set<String> billTypeSet) {
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"bos_formmeta", (String)"number", (QFilter[])new QFilter[]{new QFilter("number", "in", billTypeSet)});
        return collection.stream().map(dynamicObject -> dynamicObject.getString("number")).collect(Collectors.toSet());
    }

    private static Map<Long, Map<Integer, Map<String, Object>>> getTaskSelectAblePriority(Set<Long> taskIdList) {
        HashMap<Long, Map<Integer, Map<String, Object>>> result = new HashMap<Long, Map<Integer, Map<String, Object>>>(taskIdList.size());
        String sql = "select a.fid,c.fpriorityid,c.ftimeliness,d.fpriority from (select fid,fbilltypeid,ftasktypeid from t_tk_task where fid in (%s)) a left join t_tk_taskrulebill b on a.fbilltypeid = b.fid and a.ftasktypeid = b.ftasktype left join t_tk_levelentry c on b.fchildpkid = c.fid left join t_tk_tasklevel d on c.fpriorityid = d.fid";
        String param = StringUtils.join((Object[])taskIdList.toArray(), (String)",");
        try (DataSet ds = DB.queryDataSet((String)"kd.ssc.TaskPriorityHelper.queryLevelPriority", (DBRoute)DBRoute.of((String)"ssc"), (String)String.format(sql, param));){
            while (ds.hasNext()) {
                Row row = ds.next();
                Long taskId = row.getLong("fid");
                HashMap priorityDetail = (HashMap)result.get(taskId);
                if (priorityDetail == null) {
                    priorityDetail = new HashMap();
                }
                HashMap<String, Number> levelInfo = new HashMap<String, Number>();
                levelInfo.put("level", row.getLong("fpriorityid"));
                levelInfo.put("timeliness", row.getBigDecimal("ftimeliness"));
                priorityDetail.put(row.getInteger("fpriority"), levelInfo);
                result.put(taskId, priorityDetail);
            }
        }
        return result;
    }
}

