/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.business.workbill.builder;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FieldsetPanelAp;
import kd.ssc.task.business.workbill.builder.FieldBuilder;
import kd.ssc.task.business.workbill.containercfg.FieldsetPanelApCfg;
import kd.ssc.task.business.workbill.fieldcfg.FieldApCfg;

public class FieldsetPanelApBuilder {
    private FormMetadata formMeta;
    private EntityMetadata entityMeta;
    List<ControlAp<?>> ctrlAps;
    List<EntityItem<?>> entityItems;
    private Map<String, ControlAp<?>> ctrlApsMap = new HashMap(16);
    private Map<String, EntityItem<?>> entityItemsMap = new HashMap(16);
    private FieldBuilder fieldBuilder = new FieldBuilder();

    public FieldsetPanelApBuilder(FormMetadata formMeta, EntityMetadata entityMeta) {
        this.init(formMeta, entityMeta);
    }

    private void init(FormMetadata formMeta, EntityMetadata entityMeta) {
        this.formMeta = formMeta;
        this.entityMeta = entityMeta;
        this.ctrlAps = this.formMeta.getItems();
        this.entityItems = this.entityMeta.getItems();
        for (ControlAp<?> controlAp : this.ctrlAps) {
            this.ctrlApsMap.put(controlAp.getKey(), controlAp);
        }
        for (EntityItem entityItem : this.entityItems) {
            this.entityItemsMap.put(entityItem.getKey(), entityItem);
        }
    }

    protected void addControlAp(FieldsetPanelApCfg panelApCfg) {
        List<FieldApCfg> fieldCfgLi = panelApCfg.getFieldCfgLi();
        if (panelApCfg.isPreset()) {
            ControlAp<?> panelAp = this.ctrlApsMap.get(panelApCfg.getKey());
            this.updateFieldsetPanelAp(panelApCfg, (FieldsetPanelAp)panelAp);
            List<FieldApCfg> presetFieldCfgLi = fieldCfgLi.stream().filter(FieldApCfg::isPreset).collect(Collectors.toList());
            this.fieldBuilder.updateFieldAps(presetFieldCfgLi, this.ctrlApsMap);
            this.fieldBuilder.updateField(presetFieldCfgLi, this.entityItemsMap);
            fieldCfgLi.removeAll(presetFieldCfgLi);
        } else {
            this.ctrlAps.add((ControlAp<?>)this.createFieldsetPanelAp(panelApCfg));
        }
        this.ctrlAps.addAll(this.fieldBuilder.createFieldAps(fieldCfgLi, panelApCfg.getId()));
        this.entityItems.addAll(this.fieldBuilder.createField(fieldCfgLi));
    }

    protected void updateControlAp(FieldsetPanelApCfg panelApCfg) {
        FieldsetPanelAp panelAp = (FieldsetPanelAp)this.ctrlApsMap.get(panelApCfg.getKey());
        if (panelAp == null) {
            this.addControlAp(panelApCfg);
            return;
        }
        this.updateFieldsetPanelAp(panelApCfg, panelAp);
        List<FieldApCfg> fieldCfgLi = panelApCfg.getFieldCfgLi();
        Set<String> ctrlApKeys = this.ctrlApsMap.keySet();
        List<FieldApCfg> needAddFieldCfgLi = fieldCfgLi.stream().filter(p -> !ctrlApKeys.contains(p.getKey())).collect(Collectors.toList());
        this.ctrlAps.addAll(this.fieldBuilder.createFieldAps(needAddFieldCfgLi, panelAp.getId()));
        this.entityItems.addAll(this.fieldBuilder.createField(needAddFieldCfgLi));
        fieldCfgLi.removeAll(needAddFieldCfgLi);
        this.fieldBuilder.updateFieldAps(fieldCfgLi, this.ctrlApsMap);
        this.fieldBuilder.updateField(fieldCfgLi, this.entityItemsMap);
    }

    protected void deleteControlAp(FieldsetPanelApCfg panelApCfg, boolean self) {
        List<FieldApCfg> delFieldCfgLi = panelApCfg.getDelFieldCfgLi();
        if (delFieldCfgLi != null) {
            Set delFieldKeys = delFieldCfgLi.stream().map(p -> p.getKey()).collect(Collectors.toSet());
            for (String fieldKey : delFieldKeys) {
                this.ctrlAps.remove(this.ctrlApsMap.remove(fieldKey));
                this.entityItems.remove(this.entityItemsMap.remove(fieldKey));
            }
            if (self) {
                this.ctrlAps.remove(this.ctrlApsMap.remove(panelApCfg.getKey()));
            }
        }
    }

    private FieldsetPanelAp createFieldsetPanelAp(FieldsetPanelApCfg panelApCfg) {
        FieldsetPanelAp panel = new FieldsetPanelAp();
        panel.setId(panelApCfg.getId());
        panel.setKey(panelApCfg.getKey());
        panel.setName(panelApCfg.getName());
        panel.setParentId(panelApCfg.getParentId());
        panel.setIndex(panelApCfg.getIndex());
        panel.setCollapsible(true);
        panel.setBackColor("#ffffff");
        Margin margin = new Margin();
        margin.setTop("10px");
        Style style = new Style();
        style.setMargin(margin);
        panel.setStyle(style);
        panel.setGrow(0);
        panel.setShrink(0);
        panel.setInvisible(panelApCfg.isHidden());
        return panel;
    }

    private void updateFieldsetPanelAp(FieldsetPanelApCfg panelApCfg, FieldsetPanelAp panelAp) {
        panelAp.setName(panelApCfg.getName());
        panelAp.setIndex(panelApCfg.getIndex());
        panelAp.setInvisible(panelApCfg.isHidden());
    }
}

