/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.business.workbill.builder;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.db.DBRoute;
import kd.bos.entity.property.RefProp;
import kd.bos.metadata.entity.commonfield.ComboItem;
import kd.bos.util.StringUtils;
import kd.ssc.task.business.workbill.WorkBillConfigDTO;
import kd.ssc.task.business.workbill.containercfg.AdvConApCfg;
import kd.ssc.task.business.workbill.containercfg.ContainerApCfg;
import kd.ssc.task.business.workbill.containercfg.FieldsetPanelApCfg;
import kd.ssc.task.business.workbill.fieldcfg.AccountFieldCfg;
import kd.ssc.task.business.workbill.fieldcfg.AmountFieldCfg;
import kd.ssc.task.business.workbill.fieldcfg.AssistantFieldCfg;
import kd.ssc.task.business.workbill.fieldcfg.BasedataFieldCfg;
import kd.ssc.task.business.workbill.fieldcfg.BigIntFieldCfg;
import kd.ssc.task.business.workbill.fieldcfg.BillNoFieldCfg;
import kd.ssc.task.business.workbill.fieldcfg.BillStatusFieldCfg;
import kd.ssc.task.business.workbill.fieldcfg.CheckBoxFieldCfg;
import kd.ssc.task.business.workbill.fieldcfg.ComboFieldCfg;
import kd.ssc.task.business.workbill.fieldcfg.CreateDateFieldCfg;
import kd.ssc.task.business.workbill.fieldcfg.CreaterFieldCfg;
import kd.ssc.task.business.workbill.fieldcfg.CurrencyFieldCfg;
import kd.ssc.task.business.workbill.fieldcfg.CustomerFieldCfg;
import kd.ssc.task.business.workbill.fieldcfg.DateFieldCfg;
import kd.ssc.task.business.workbill.fieldcfg.DateRangeFieldCfg;
import kd.ssc.task.business.workbill.fieldcfg.DateTimeFieldCfg;
import kd.ssc.task.business.workbill.fieldcfg.DecimalFieldCfg;
import kd.ssc.task.business.workbill.fieldcfg.FieldApCfg;
import kd.ssc.task.business.workbill.fieldcfg.IntegerFieldCfg;
import kd.ssc.task.business.workbill.fieldcfg.LargeTextFieldCfg;
import kd.ssc.task.business.workbill.fieldcfg.MaterielFieldCfg;
import kd.ssc.task.business.workbill.fieldcfg.ModifierFieldCfg;
import kd.ssc.task.business.workbill.fieldcfg.ModifyDateFieldCfg;
import kd.ssc.task.business.workbill.fieldcfg.MulComboFieldCfg;
import kd.ssc.task.business.workbill.fieldcfg.MuliLangTextFieldCfg;
import kd.ssc.task.business.workbill.fieldcfg.OrgFieldCfg;
import kd.ssc.task.business.workbill.fieldcfg.PriceFieldCfg;
import kd.ssc.task.business.workbill.fieldcfg.QtyFieldCfg;
import kd.ssc.task.business.workbill.fieldcfg.SupplierFieldCfg;
import kd.ssc.task.business.workbill.fieldcfg.TextAreaFieldCfg;
import kd.ssc.task.business.workbill.fieldcfg.TextFieldCfg;
import kd.ssc.task.business.workbill.fieldcfg.TimeFieldCfg;
import kd.ssc.task.business.workbill.fieldcfg.TimeRangeFieldCfg;
import kd.ssc.task.business.workbill.fieldcfg.UnitFieldCfg;
import kd.ssc.task.business.workbill.fieldcfg.UserFieldCfg;

public class WorkBillConfigDTOBuilder {
    private static final String SSC = "ssc";
    private static final String BASE_INFO_PANEL_ID = "mqK0FWAH2I";
    private static final String VOUCHER_INFO_PANEL_ID = "afICmAMcxB";

    public static WorkBillConfigDTO createWorkBillConfigDTO(String bizAppId, DynamicObject workBill) {
        String formName = workBill.getString("name");
        String formNumber = workBill.getString("number");
        WorkBillConfigDTO billConfig = new WorkBillConfigDTO(bizAppId);
        billConfig.setFormName(WorkBillConfigDTOBuilder.convert2LocaleName(formName));
        billConfig.setFormNumber(formNumber);
        billConfig.setDBRoute(DBRoute.of((String)SSC).getRouteKey());
        billConfig.setTableName("t_" + formNumber);
        billConfig.setFormId(workBill.getString("entityid"));
        WorkBillConfigDTOBuilder.parseContainerCfg(workBill, billConfig);
        return billConfig;
    }

    private static void parseContainerCfg(DynamicObject dynamicObject, WorkBillConfigDTO billConfig) {
        DynamicObjectCollection collections = dynamicObject.getDynamicObjectCollection("entryentity");
        ArrayList<ContainerApCfg> containerApCfgs = new ArrayList<ContainerApCfg>();
        ArrayList<ContainerApCfg> delContainerApCfgs = new ArrayList<ContainerApCfg>();
        for (DynamicObject obj : collections) {
            String panelType = obj.getString("ptype");
            String panelId = obj.getString("panelid");
            ContainerApCfg containerApCfg = null;
            if (panelType.equalsIgnoreCase("0")) {
                FieldsetPanelApCfg fieldsetPanelApCfg = new FieldsetPanelApCfg();
                if (panelId.equalsIgnoreCase(BASE_INFO_PANEL_ID) || panelId.equalsIgnoreCase(VOUCHER_INFO_PANEL_ID)) {
                    fieldsetPanelApCfg.setPreset(true);
                    fieldsetPanelApCfg.setId(panelId);
                }
                containerApCfg = fieldsetPanelApCfg;
            } else {
                AdvConApCfg advConApCfg = new AdvConApCfg();
                containerApCfg = advConApCfg;
            }
            containerApCfg.setKey(obj.getString("pnumber"));
            containerApCfg.setName(WorkBillConfigDTOBuilder.convert2LocaleName(obj.getString("pname")));
            containerApCfg.setIndex(obj.getInt("seq"));
            containerApCfg.setHidden(!obj.getBoolean("pisvisible"));
            String pCheckMeta = obj.getString("pcheckmeta");
            Map<String, List<FieldApCfg>> fieldApCfgs = WorkBillConfigDTOBuilder.createFieldApCfgs(obj.getDynamicObjectCollection("subentryentity"));
            List<FieldApCfg> delFieldCfgLi = fieldApCfgs.get("del");
            List<FieldApCfg> fieldCfgLi = fieldApCfgs.get("update");
            containerApCfg.setDelFieldCfgLi(delFieldCfgLi);
            containerApCfg.setFieldCfgLi(fieldCfgLi);
            if ("2".equals(pCheckMeta)) {
                delContainerApCfgs.add(containerApCfg);
                continue;
            }
            containerApCfgs.add(containerApCfg);
        }
        billConfig.setContainerCfgLi(containerApCfgs);
        billConfig.setDelContainerCfgLi(delContainerApCfgs);
    }

    public static Map<String, List<FieldApCfg>> createFieldApCfgs(DynamicObjectCollection dynamicObjects) {
        HashMap<String, List<FieldApCfg>> result = new HashMap<String, List<FieldApCfg>>(2);
        ArrayList<FieldApCfg> fieldApCfgs = new ArrayList<FieldApCfg>(dynamicObjects.size());
        ArrayList<FieldApCfg> delFieldApCfgs = new ArrayList<FieldApCfg>(dynamicObjects.size());
        HashMap<FieldApCfg, List<String>> fieldCfgFNumber = new HashMap<FieldApCfg, List<String>>();
        HashMap<String, String> fNumberIdMap = new HashMap<String, String>();
        for (DynamicObject field : dynamicObjects) {
            String fieldType = field.getString("fieldtype");
            String fieldProperty = field.getString("fieldpropertyjson_tag");
            FieldApCfg fieldApCfg = null;
            switch (fieldType) {
                case "Text": {
                    fieldApCfg = WorkBillConfigDTOBuilder.createTextFieldCfg(fieldProperty);
                    break;
                }
                case "LargeText": {
                    fieldApCfg = WorkBillConfigDTOBuilder.createLargeTextFieldCfg(fieldProperty);
                    break;
                }
                case "TextArea": {
                    fieldApCfg = WorkBillConfigDTOBuilder.createTextAreaFieldCfg(fieldProperty);
                    break;
                }
                case "MuliLangText": {
                    fieldApCfg = WorkBillConfigDTOBuilder.createMultLangTextFieldCfg(fieldProperty);
                    break;
                }
                case "Date": {
                    fieldApCfg = WorkBillConfigDTOBuilder.createDateFieldCfg(fieldProperty);
                    break;
                }
                case "DateTime": {
                    fieldApCfg = WorkBillConfigDTOBuilder.createDateTimeFieldCfg(fieldProperty);
                    break;
                }
                case "DateRange": {
                    fieldApCfg = WorkBillConfigDTOBuilder.createDateRangeFieldCfg(fieldProperty);
                    break;
                }
                case "Time": {
                    fieldApCfg = WorkBillConfigDTOBuilder.createTimeFieldCfg(fieldProperty);
                    break;
                }
                case "TimeRange": {
                    fieldApCfg = WorkBillConfigDTOBuilder.createTimeRangeFieldCfg(fieldProperty);
                    break;
                }
                case "CheckBox": {
                    fieldApCfg = WorkBillConfigDTOBuilder.createCheckBoxFieldCfg(fieldProperty);
                    break;
                }
                case "Combo": {
                    fieldApCfg = WorkBillConfigDTOBuilder.createComboFieldCfg(fieldProperty);
                    break;
                }
                case "MulCombo": {
                    fieldApCfg = WorkBillConfigDTOBuilder.createMultComboFieldCfg(fieldProperty);
                    break;
                }
                case "Basedata": {
                    fieldApCfg = WorkBillConfigDTOBuilder.createBaseDataFieldCfg(fieldProperty);
                    break;
                }
                case "User": {
                    fieldApCfg = WorkBillConfigDTOBuilder.createUserFieldCfg(fieldProperty);
                    break;
                }
                case "Org": {
                    fieldApCfg = WorkBillConfigDTOBuilder.createOrgFieldCfg(fieldProperty);
                    break;
                }
                case "Currency": {
                    fieldApCfg = WorkBillConfigDTOBuilder.createCurrencyFieldCfg(fieldProperty);
                    break;
                }
                case "Account": {
                    fieldApCfg = WorkBillConfigDTOBuilder.createAccountFieldCfg(fieldProperty, fieldCfgFNumber);
                    break;
                }
                case "Customer": {
                    fieldApCfg = WorkBillConfigDTOBuilder.createCustomerFieldCfg(fieldProperty);
                    break;
                }
                case "Supplier": {
                    fieldApCfg = WorkBillConfigDTOBuilder.createSupplierFieldCfg(fieldProperty);
                    break;
                }
                case "Materiel": {
                    fieldApCfg = WorkBillConfigDTOBuilder.createMaterielFieldCfg(fieldProperty);
                    break;
                }
                case "Unit": {
                    fieldApCfg = WorkBillConfigDTOBuilder.createUnitFieldCfg(fieldProperty, fieldCfgFNumber);
                    break;
                }
                case "Decimal": {
                    fieldApCfg = WorkBillConfigDTOBuilder.createDecimalFieldCfg(fieldProperty);
                    break;
                }
                case "Integer": {
                    fieldApCfg = WorkBillConfigDTOBuilder.createIntegerFieldCfg(fieldProperty);
                    break;
                }
                case "BigInt": {
                    fieldApCfg = WorkBillConfigDTOBuilder.createBigIntegerFieldCfg(fieldProperty);
                    break;
                }
                case "Amount": {
                    fieldApCfg = WorkBillConfigDTOBuilder.createAmountFieldCfg(fieldProperty, fieldCfgFNumber);
                    break;
                }
                case "Qty": {
                    fieldApCfg = WorkBillConfigDTOBuilder.createQtyFieldCfg(fieldProperty, fieldCfgFNumber);
                    break;
                }
                case "Price": {
                    fieldApCfg = WorkBillConfigDTOBuilder.createPriceFieldCfg(fieldProperty, fieldCfgFNumber);
                    break;
                }
                case "BillNo": {
                    fieldApCfg = WorkBillConfigDTOBuilder.createBillNoFieldCfg(fieldProperty);
                    break;
                }
                case "BillStatus": {
                    fieldApCfg = WorkBillConfigDTOBuilder.createBillStatusFieldCfg(fieldProperty);
                    break;
                }
                case "CreateDate": {
                    fieldApCfg = WorkBillConfigDTOBuilder.createCreateDateFieldCfg(fieldProperty);
                    break;
                }
                case "ModifyDate": {
                    fieldApCfg = WorkBillConfigDTOBuilder.createModifyDateFieldCfg(fieldProperty);
                    break;
                }
                case "Modifier": {
                    fieldApCfg = WorkBillConfigDTOBuilder.createModifierFieldCfg(fieldProperty);
                    break;
                }
                case "Creater": {
                    fieldApCfg = WorkBillConfigDTOBuilder.createCreaterFieldCfg(fieldProperty);
                    break;
                }
                case "Assistant": {
                    fieldApCfg = WorkBillConfigDTOBuilder.createAssistantFieldCfg(fieldProperty, fieldCfgFNumber);
                }
            }
            if (fieldApCfg == null) continue;
            String fieldCheckMeta = field.getString("fcheckmeta");
            fieldApCfg.setIndex(field.getInt("seq"));
            WorkBillConfigDTOBuilder.setCommonProperty(fieldApCfg, field, fNumberIdMap);
            WorkBillConfigDTOBuilder.setRefProperty(fieldCfgFNumber, fNumberIdMap);
            if ("2".equals(fieldCheckMeta)) {
                delFieldApCfgs.add(fieldApCfg);
                continue;
            }
            fieldApCfgs.add(fieldApCfg);
        }
        result.put("update", fieldApCfgs);
        result.put("del", delFieldApCfgs);
        return result;
    }

    private static FieldApCfg createTextFieldCfg(String fieldJsonString) {
        TextFieldCfg textFieldCfg = new TextFieldCfg();
        JSONObject jsonObject = JSONObject.parseObject((String)fieldJsonString);
        WorkBillConfigDTOBuilder.setTextCommonProperty(textFieldCfg, jsonObject);
        return textFieldCfg;
    }

    private static FieldApCfg createLargeTextFieldCfg(String fieldJsonString) {
        LargeTextFieldCfg largeTextFieldCfg = new LargeTextFieldCfg();
        JSONObject jsonObject = JSONObject.parseObject((String)fieldJsonString);
        WorkBillConfigDTOBuilder.setTextCommonProperty(largeTextFieldCfg, jsonObject);
        return largeTextFieldCfg;
    }

    private static FieldApCfg createTextAreaFieldCfg(String fieldJsonString) {
        TextAreaFieldCfg textAreaFieldCfg = new TextAreaFieldCfg();
        JSONObject jsonObject = JSONObject.parseObject((String)fieldJsonString);
        WorkBillConfigDTOBuilder.setTextCommonProperty(textAreaFieldCfg, jsonObject);
        return textAreaFieldCfg;
    }

    private static FieldApCfg createMultLangTextFieldCfg(String fieldJsonString) {
        MuliLangTextFieldCfg muliLangTextFieldCfg = new MuliLangTextFieldCfg();
        JSONObject jsonObject = JSONObject.parseObject((String)fieldJsonString);
        if (jsonObject == null) {
            return muliLangTextFieldCfg;
        }
        WorkBillConfigDTOBuilder.setTextCommonProperty(muliLangTextFieldCfg, jsonObject);
        Boolean gl = jsonObject.getBoolean("gl");
        Boolean mutiLine = jsonObject.getBoolean("mutiLine");
        if (gl != null) {
            muliLangTextFieldCfg.setGl(gl);
        }
        if (mutiLine != null) {
            muliLangTextFieldCfg.setMutiLine(mutiLine);
        }
        return muliLangTextFieldCfg;
    }

    private static FieldApCfg createDateTimeFieldCfg(String fieldJsonString) {
        DateTimeFieldCfg dateTimeFieldCfg = new DateTimeFieldCfg();
        JSONObject jsonObject = JSONObject.parseObject((String)fieldJsonString);
        WorkBillConfigDTOBuilder.setDateTimeCommonProperty(dateTimeFieldCfg, jsonObject);
        return dateTimeFieldCfg;
    }

    private static FieldApCfg createDateFieldCfg(String fieldJsonString) {
        DateFieldCfg dateFieldCfg = new DateFieldCfg();
        JSONObject jsonObject = JSONObject.parseObject((String)fieldJsonString);
        WorkBillConfigDTOBuilder.setDateTimeCommonProperty(dateFieldCfg, jsonObject);
        return dateFieldCfg;
    }

    private static FieldApCfg createDateRangeFieldCfg(String fieldJsonString) {
        DateRangeFieldCfg dateRangeFieldCfg = new DateRangeFieldCfg();
        JSONObject jsonObject = JSONObject.parseObject((String)fieldJsonString);
        if (jsonObject == null) {
            return dateRangeFieldCfg;
        }
        String defValue = jsonObject.getString("defValue");
        String startDateFieldKey = jsonObject.getString("startDateFieldKey");
        String startDateFieldName = jsonObject.getString("startDateFieldName");
        String endDateFieldKey = jsonObject.getString("endDateFieldKey");
        String endDateFieldName = jsonObject.getString("endDateFieldName");
        Integer regionType = jsonObject.getInteger("regionType");
        dateRangeFieldCfg.setDefValue(defValue);
        if (StringUtils.isNotEmpty((String)startDateFieldKey)) {
            dateRangeFieldCfg.setStartDateFieldKey(startDateFieldKey);
        }
        dateRangeFieldCfg.setStartDateFieldName(startDateFieldName);
        if (StringUtils.isNotEmpty((String)endDateFieldKey)) {
            dateRangeFieldCfg.setEndDateFieldKey(endDateFieldKey);
        }
        dateRangeFieldCfg.setEndDateFieldKey(endDateFieldKey);
        dateRangeFieldCfg.setEndDateFieldName(endDateFieldName);
        if (regionType != null) {
            dateRangeFieldCfg.setRegionType(regionType);
        }
        return dateRangeFieldCfg;
    }

    private static FieldApCfg createTimeFieldCfg(String fieldJsonString) {
        return new TimeFieldCfg();
    }

    private static FieldApCfg createTimeRangeFieldCfg(String fieldJsonString) {
        TimeRangeFieldCfg timeRangeFieldCfg = new TimeRangeFieldCfg();
        JSONObject jsonObject = JSONObject.parseObject((String)fieldJsonString);
        if (jsonObject == null) {
            return timeRangeFieldCfg;
        }
        String startDateFieldKey = jsonObject.getString("startDateFieldKey");
        String startDateFieldName = jsonObject.getString("startDateFieldName");
        String endDateFieldKey = jsonObject.getString("endDateFieldKey");
        String endDateFieldName = jsonObject.getString("endDateFieldName");
        if (StringUtils.isNotEmpty((String)startDateFieldKey)) {
            timeRangeFieldCfg.setStartDateFieldKey(startDateFieldKey);
        }
        timeRangeFieldCfg.setStartDateFieldName(startDateFieldName);
        if (StringUtils.isNotEmpty((String)endDateFieldKey)) {
            timeRangeFieldCfg.setEndDateFieldKey(endDateFieldKey);
        }
        timeRangeFieldCfg.setEndDateFieldKey(endDateFieldKey);
        timeRangeFieldCfg.setEndDateFieldName(endDateFieldName);
        return timeRangeFieldCfg;
    }

    private static FieldApCfg createCheckBoxFieldCfg(String fieldJsonString) {
        CheckBoxFieldCfg checkBoxFieldCfg = new CheckBoxFieldCfg();
        JSONObject jsonObject = JSONObject.parseObject((String)fieldJsonString);
        if (jsonObject == null) {
            return checkBoxFieldCfg;
        }
        Integer showStyle = jsonObject.getInteger("showStyle");
        Boolean defValue = jsonObject.getBoolean("defValue");
        if (showStyle != null) {
            checkBoxFieldCfg.setShowStyle(showStyle);
        }
        if (defValue != null) {
            checkBoxFieldCfg.setDefValue(defValue);
        }
        return checkBoxFieldCfg;
    }

    private static FieldApCfg createComboFieldCfg(String fieldJsonString) {
        ComboFieldCfg comboFieldCfg = new ComboFieldCfg();
        JSONObject jsonObject = JSONObject.parseObject((String)fieldJsonString);
        WorkBillConfigDTOBuilder.setComboCommonProperty(comboFieldCfg, jsonObject);
        return comboFieldCfg;
    }

    private static FieldApCfg createMultComboFieldCfg(String fieldJsonString) {
        MulComboFieldCfg mulComboFieldCfg = new MulComboFieldCfg();
        JSONObject jsonObject = JSONObject.parseObject((String)fieldJsonString);
        if (jsonObject == null) {
            return mulComboFieldCfg;
        }
        WorkBillConfigDTOBuilder.setComboCommonProperty(mulComboFieldCfg, jsonObject);
        String selectedItemStyle = jsonObject.getString("selectItemStyle");
        if (StringUtils.isNotEmpty((String)selectedItemStyle)) {
            mulComboFieldCfg.setSelectedItemStyle(selectedItemStyle);
        }
        return mulComboFieldCfg;
    }

    private static FieldApCfg createBaseDataFieldCfg(String fieldJsonString) {
        BasedataFieldCfg basedataFieldCfg = new BasedataFieldCfg();
        JSONObject jsonObject = JSONObject.parseObject((String)fieldJsonString);
        WorkBillConfigDTOBuilder.setBaseDataCommonProperty(basedataFieldCfg, jsonObject);
        return basedataFieldCfg;
    }

    private static FieldApCfg createUserFieldCfg(String fieldJsonString) {
        UserFieldCfg userFieldCfg = new UserFieldCfg();
        JSONObject jsonObject = JSONObject.parseObject((String)fieldJsonString);
        WorkBillConfigDTOBuilder.setBaseDataCommonProperty(userFieldCfg, jsonObject);
        if (jsonObject == null) {
            return userFieldCfg;
        }
        Integer f7Style = jsonObject.getInteger("f7Style");
        if (f7Style != null) {
            userFieldCfg.setF7Style(f7Style);
        }
        return userFieldCfg;
    }

    private static FieldApCfg createOrgFieldCfg(String fieldJsonString) {
        OrgFieldCfg orgFieldCfg = new OrgFieldCfg();
        JSONObject jsonObject = JSONObject.parseObject((String)fieldJsonString);
        WorkBillConfigDTOBuilder.setBaseDataCommonProperty(orgFieldCfg, jsonObject);
        if (jsonObject == null) {
            return orgFieldCfg;
        }
        Integer f7Style = jsonObject.getInteger("f7Style");
        String orgFuncs = jsonObject.getString("orgFuncs");
        if (f7Style != null) {
            orgFieldCfg.setF7Style(f7Style);
        }
        orgFieldCfg.setOrgFuncs(orgFuncs);
        return orgFieldCfg;
    }

    private static FieldApCfg createCurrencyFieldCfg(String fieldJsonString) {
        CurrencyFieldCfg currencyFieldCfg = new CurrencyFieldCfg();
        JSONObject jsonObject = JSONObject.parseObject((String)fieldJsonString);
        WorkBillConfigDTOBuilder.setBaseDataCommonProperty(currencyFieldCfg, jsonObject);
        return currencyFieldCfg;
    }

    private static FieldApCfg createCustomerFieldCfg(String fieldJsonString) {
        CustomerFieldCfg customerFieldCfg = new CustomerFieldCfg();
        JSONObject jsonObject = JSONObject.parseObject((String)fieldJsonString);
        WorkBillConfigDTOBuilder.setBaseDataCommonProperty(customerFieldCfg, jsonObject);
        return customerFieldCfg;
    }

    private static FieldApCfg createSupplierFieldCfg(String fieldJsonString) {
        SupplierFieldCfg supplierFieldCfg = new SupplierFieldCfg();
        JSONObject jsonObject = JSONObject.parseObject((String)fieldJsonString);
        WorkBillConfigDTOBuilder.setBaseDataCommonProperty(supplierFieldCfg, jsonObject);
        return supplierFieldCfg;
    }

    private static FieldApCfg createMaterielFieldCfg(String fieldJsonString) {
        MaterielFieldCfg materielFieldCfg = new MaterielFieldCfg();
        JSONObject jsonObject = JSONObject.parseObject((String)fieldJsonString);
        WorkBillConfigDTOBuilder.setBaseDataCommonProperty(materielFieldCfg, jsonObject);
        return materielFieldCfg;
    }

    private static FieldApCfg createUnitFieldCfg(String fieldJsonString, Map<FieldApCfg, List<String>> fieldCfgNumberMap) {
        Boolean followUnitToChange;
        UnitFieldCfg unitFieldCfg = new UnitFieldCfg();
        JSONObject jsonObject = JSONObject.parseObject((String)fieldJsonString);
        WorkBillConfigDTOBuilder.setBaseDataCommonProperty(unitFieldCfg, jsonObject);
        if (jsonObject == null) {
            return unitFieldCfg;
        }
        final String materielFieldId = jsonObject.getString("materielFieldId");
        if (StringUtils.isNotEmpty((String)materielFieldId)) {
            fieldCfgNumberMap.put(unitFieldCfg, (List<String>)new ArrayList<String>(){
                {
                    this.add(materielFieldId);
                }
            });
        }
        if ((followUnitToChange = jsonObject.getBoolean("followUnitToChange")) != null) {
            unitFieldCfg.setFollowUnitToChange(followUnitToChange);
        }
        return unitFieldCfg;
    }

    private static FieldApCfg createAccountFieldCfg(String fieldJsonString, Map<FieldApCfg, List<String>> fieldCfgNumberMap) {
        AccountFieldCfg accountFieldCfg = new AccountFieldCfg();
        JSONObject jsonObject = JSONObject.parseObject((String)fieldJsonString);
        WorkBillConfigDTOBuilder.setBaseDataCommonProperty(accountFieldCfg, jsonObject);
        if (jsonObject == null) {
            return accountFieldCfg;
        }
        Boolean displayFullName = jsonObject.getBoolean("displayFullName");
        Boolean multiVersion = jsonObject.getBoolean("multiVersion");
        final String refPeriodFieldId = jsonObject.getString("refPeriodFieldId");
        final String refAccTableFieldId = jsonObject.getString("refAcctTableFieldId");
        fieldCfgNumberMap.put(accountFieldCfg, (List<String>)new ArrayList<String>(){
            {
                this.add(refPeriodFieldId);
                this.add(refAccTableFieldId);
            }
        });
        if (displayFullName != null) {
            accountFieldCfg.setDisplayFullName(displayFullName);
        }
        if (multiVersion != null) {
            accountFieldCfg.setMultiVersion(multiVersion);
        }
        return accountFieldCfg;
    }

    private static FieldApCfg createDecimalFieldCfg(String fieldJsonString) {
        DecimalFieldCfg decimalFieldCfg = new DecimalFieldCfg();
        JSONObject jsonObject = JSONObject.parseObject((String)fieldJsonString);
        WorkBillConfigDTOBuilder.setDecimalCommonProperty(decimalFieldCfg, jsonObject);
        return decimalFieldCfg;
    }

    private static FieldApCfg createIntegerFieldCfg(String fieldJsonString) {
        IntegerFieldCfg integerFieldCfg = new IntegerFieldCfg();
        JSONObject jsonObject = JSONObject.parseObject((String)fieldJsonString);
        WorkBillConfigDTOBuilder.setDecimalCommonProperty(integerFieldCfg, jsonObject);
        return integerFieldCfg;
    }

    private static FieldApCfg createBigIntegerFieldCfg(String fieldJsonString) {
        BigIntFieldCfg bigIntFieldCfg = new BigIntFieldCfg();
        JSONObject jsonObject = JSONObject.parseObject((String)fieldJsonString);
        WorkBillConfigDTOBuilder.setDecimalCommonProperty(bigIntFieldCfg, jsonObject);
        return bigIntFieldCfg;
    }

    private static FieldApCfg createAmountFieldCfg(String fieldJsonString, Map<FieldApCfg, List<String>> fieldFNumberMap) {
        Integer amountPrecisionType;
        AmountFieldCfg amountFieldCfg = new AmountFieldCfg();
        JSONObject jsonObject = JSONObject.parseObject((String)fieldJsonString);
        WorkBillConfigDTOBuilder.setDecimalCommonProperty(amountFieldCfg, jsonObject);
        if (jsonObject == null) {
            return amountFieldCfg;
        }
        final String currencyFieldId = jsonObject.getString("currencyFieldId");
        if (StringUtils.isNotEmpty((String)currencyFieldId)) {
            fieldFNumberMap.put(amountFieldCfg, (List<String>)new ArrayList<String>(){
                {
                    this.add(currencyFieldId);
                }
            });
        }
        if ((amountPrecisionType = jsonObject.getInteger("amountPrecisionType")) != null) {
            amountFieldCfg.setAmountPrecisionType(amountPrecisionType);
        }
        return amountFieldCfg;
    }

    private static FieldApCfg createQtyFieldCfg(String fieldJsonString, Map<FieldApCfg, List<String>> fieldFNumberMap) {
        QtyFieldCfg qtyFieldCfg = new QtyFieldCfg();
        JSONObject jsonObject = JSONObject.parseObject((String)fieldJsonString);
        WorkBillConfigDTOBuilder.setDecimalCommonProperty(qtyFieldCfg, jsonObject);
        if (jsonObject == null) {
            return qtyFieldCfg;
        }
        final String unitFieldId = jsonObject.getString("unitFieldId");
        if (StringUtils.isNotEmpty((String)unitFieldId)) {
            fieldFNumberMap.put(qtyFieldCfg, (List<String>)new ArrayList<String>(){
                {
                    this.add(unitFieldId);
                }
            });
        }
        return qtyFieldCfg;
    }

    private static FieldApCfg createPriceFieldCfg(String fieldJsonString, Map<FieldApCfg, List<String>> fieldFNumberMap) {
        Integer amountPrecisionType;
        PriceFieldCfg priceFieldCfg = new PriceFieldCfg();
        JSONObject jsonObject = JSONObject.parseObject((String)fieldJsonString);
        WorkBillConfigDTOBuilder.setDecimalCommonProperty(priceFieldCfg, jsonObject);
        if (jsonObject == null) {
            return priceFieldCfg;
        }
        final String currencyFieldId = jsonObject.getString("currencyFieldId");
        if (StringUtils.isNotEmpty((String)currencyFieldId)) {
            fieldFNumberMap.put(priceFieldCfg, (List<String>)new ArrayList<String>(){
                {
                    this.add(currencyFieldId);
                }
            });
        }
        if ((amountPrecisionType = jsonObject.getInteger("amountPrecisionType")) != null) {
            priceFieldCfg.setAmountPrecisionType(amountPrecisionType);
        }
        return priceFieldCfg;
    }

    private static FieldApCfg createBillNoFieldCfg(String fieldJsonString) {
        BillNoFieldCfg billNoFieldCfg = new BillNoFieldCfg();
        JSONObject jsonObject = JSONObject.parseObject((String)fieldJsonString);
        WorkBillConfigDTOBuilder.setTextCommonProperty(billNoFieldCfg, jsonObject);
        return billNoFieldCfg;
    }

    private static FieldApCfg createBillStatusFieldCfg(String fieldJsonString) {
        BillStatusFieldCfg billStatusFieldCfg = new BillStatusFieldCfg();
        JSONObject jsonObject = JSONObject.parseObject((String)fieldJsonString);
        WorkBillConfigDTOBuilder.setComboCommonProperty(billStatusFieldCfg, jsonObject);
        return billStatusFieldCfg;
    }

    private static FieldApCfg createCreateDateFieldCfg(String fieldJsonString) {
        CreateDateFieldCfg createDateFieldCfg = new CreateDateFieldCfg();
        JSONObject jsonObject = JSONObject.parseObject((String)fieldJsonString);
        WorkBillConfigDTOBuilder.setDateTimeCommonProperty(createDateFieldCfg, jsonObject);
        return createDateFieldCfg;
    }

    private static FieldApCfg createModifyDateFieldCfg(String fieldJsonString) {
        ModifyDateFieldCfg modifyDateFieldCfg = new ModifyDateFieldCfg();
        JSONObject jsonObject = JSONObject.parseObject((String)fieldJsonString);
        WorkBillConfigDTOBuilder.setDateTimeCommonProperty(modifyDateFieldCfg, jsonObject);
        return modifyDateFieldCfg;
    }

    private static FieldApCfg createCreaterFieldCfg(String fieldJsonString) {
        CreaterFieldCfg createrFieldCfg = new CreaterFieldCfg();
        JSONObject jsonObject = JSONObject.parseObject((String)fieldJsonString);
        WorkBillConfigDTOBuilder.setBaseDataCommonProperty(createrFieldCfg, jsonObject);
        return createrFieldCfg;
    }

    private static FieldApCfg createModifierFieldCfg(String fieldJsonString) {
        ModifierFieldCfg modifierFieldCfg = new ModifierFieldCfg();
        JSONObject jsonObject = JSONObject.parseObject((String)fieldJsonString);
        WorkBillConfigDTOBuilder.setBaseDataCommonProperty(modifierFieldCfg, jsonObject);
        return modifierFieldCfg;
    }

    private static FieldApCfg createAssistantFieldCfg(String fieldJsonString, Map<FieldApCfg, List<String>> fieldCfgNumberMap) {
        AssistantFieldCfg assistantFieldCfg = new AssistantFieldCfg();
        JSONObject jsonObject = JSONObject.parseObject((String)fieldJsonString);
        WorkBillConfigDTOBuilder.setBaseDataCommonProperty(assistantFieldCfg, jsonObject);
        if (jsonObject == null) {
            return assistantFieldCfg;
        }
        String asstTypeId = jsonObject.getString("asstTypeId");
        assistantFieldCfg.setAsstTypeId(asstTypeId);
        final String asstParentId = jsonObject.getString("asstParentId");
        fieldCfgNumberMap.put(assistantFieldCfg, (List<String>)new ArrayList<String>(){
            {
                this.add(asstParentId);
            }
        });
        return assistantFieldCfg;
    }

    private static void setTextCommonProperty(TextFieldCfg textFieldCfg, JSONObject jsonObject) {
        if (jsonObject == null) {
            return;
        }
        Integer minLength = jsonObject.getInteger("minLength");
        Integer maxLength = jsonObject.getInteger("maxLength");
        String defValue = jsonObject.getString("defValue");
        Integer editStyle = jsonObject.getInteger("editStyle");
        textFieldCfg.setDefValue(defValue);
        if (minLength != null) {
            textFieldCfg.setMinLength(minLength);
        }
        if (maxLength != null) {
            textFieldCfg.setMaxLength(maxLength);
        }
        if (editStyle != null) {
            textFieldCfg.setEditStyle(editStyle);
        }
    }

    private static void setDateTimeCommonProperty(DateTimeFieldCfg dateTimeFieldCfg, JSONObject jsonObject) {
        if (jsonObject == null) {
            return;
        }
        String minDate = jsonObject.getString("minDate");
        String maxDate = jsonObject.getString("maxDate");
        Integer timeZoneTransType = jsonObject.getInteger("timeZoneTransType");
        String relateOrg = jsonObject.getString("relateOrg");
        Integer regionType = jsonObject.getInteger("regionType");
        dateTimeFieldCfg.setMinDate(minDate);
        dateTimeFieldCfg.setMaxDate(maxDate);
        dateTimeFieldCfg.setRelateOrg(relateOrg);
        if (timeZoneTransType != null) {
            dateTimeFieldCfg.setTimeZoneTransType(timeZoneTransType);
        }
        if (regionType != null) {
            dateTimeFieldCfg.setRegionType(regionType);
        }
    }

    private static void setComboCommonProperty(ComboFieldCfg comboFieldCfg, JSONObject jsonObject) {
        if (jsonObject == null) {
            return;
        }
        JSONArray itemArray = jsonObject.getJSONArray("items");
        for (int i = 0; i < itemArray.size(); ++i) {
            JSONObject item = itemArray.getJSONObject(i);
            String caption = item.getString("Caption");
            String value = item.getString("Value");
            ComboItem comboItem = new ComboItem();
            comboItem.setSeq(i);
            comboItem.setCaption(WorkBillConfigDTOBuilder.convert2LocaleName(caption));
            comboItem.setValue(value);
            Object itemVisible = item.get((Object)"ItemVisible");
            if (itemVisible != null) {
                comboItem.setItemVisible(false);
            }
            comboFieldCfg.addItems(comboItem);
        }
        String defValue = jsonObject.getString("defValue");
        Boolean comboValueCheck = jsonObject.getBooleanValue("comboValueCheck");
        comboFieldCfg.setDefValue(defValue);
        if (comboValueCheck != null) {
            comboFieldCfg.setComboValueCheck(comboValueCheck);
        }
    }

    private static void setBaseDataCommonProperty(BasedataFieldCfg basedataFieldCfg, JSONObject jsonObject) {
        if (jsonObject == null) {
            return;
        }
        String baseEntityId = jsonObject.getString("baseEntityId");
        String displayProp = jsonObject.getString("displayProp");
        String numberProp = jsonObject.getString("numberProp");
        String editSearchProp = jsonObject.getString("editSearchProp");
        Integer displayStyle = jsonObject.getInteger("displayStyle");
        Boolean showUsed = jsonObject.getBoolean("showUsed");
        Boolean viewDetails = jsonObject.getBoolean("viewDetails");
        JSONArray refProps = jsonObject.getJSONArray("refProps");
        if (refProps != null) {
            List refPops = refProps.toJavaList(String.class);
            ArrayList<RefProp> refPropList = new ArrayList<RefProp>(refPops.size());
            for (String ref : refPops) {
                refPropList.add(new RefProp(ref));
            }
            basedataFieldCfg.setRefProps(refPropList);
        }
        Boolean openFuzzyQuery = jsonObject.getBoolean("openFuzzyQuery");
        Boolean showFrequent = jsonObject.getBoolean("showFrequent");
        Integer baseDataEditStyle = jsonObject.getInteger("baseDataEditStyle");
        Boolean quickAddNew = jsonObject.getBoolean("quickAddNew");
        if (StringUtils.isNotEmpty((String)baseEntityId)) {
            basedataFieldCfg.setBaseEntityId(baseEntityId);
        }
        if (StringUtils.isNotEmpty((String)displayProp)) {
            basedataFieldCfg.setDisplayProp(displayProp);
        }
        if (StringUtils.isNotEmpty((String)numberProp)) {
            basedataFieldCfg.setNumberProp(numberProp);
        }
        if (StringUtils.isNotEmpty((String)editSearchProp)) {
            basedataFieldCfg.setEditSearchProp(editSearchProp);
        }
        if (displayStyle != null) {
            basedataFieldCfg.setDisplayStyle(displayStyle);
        }
        if (showUsed != null) {
            basedataFieldCfg.setShowUsed(showUsed);
        }
        if (viewDetails != null) {
            basedataFieldCfg.setViewDetails(viewDetails);
        }
        if (openFuzzyQuery != null) {
            basedataFieldCfg.setOpenFuzzyQuery(openFuzzyQuery);
        }
        if (showFrequent != null) {
            basedataFieldCfg.setShowFrequent(showFrequent);
        }
        if (baseDataEditStyle != null) {
            basedataFieldCfg.setBaseDataEditStyle(baseDataEditStyle);
        }
        if (quickAddNew != null) {
            basedataFieldCfg.setQuickAddNew(quickAddNew);
        }
    }

    private static void setDecimalCommonProperty(DecimalFieldCfg decimalFieldCfg, JSONObject jsonObject) {
        if (jsonObject == null) {
            return;
        }
        Integer precision = jsonObject.getInteger("precision");
        Integer scale = jsonObject.getInteger("scale");
        Boolean zeroShow = jsonObject.getBoolean("zeroShow");
        Double defValue = jsonObject.getDouble("defValue");
        String dataScope = jsonObject.getString("dataScope");
        Boolean noDisplayScaleZero = jsonObject.getBoolean("noDisplayScaleZero");
        Boolean enableNull = jsonObject.getBoolean("enableNull");
        if (precision != null) {
            decimalFieldCfg.setPrecision(precision);
        }
        if (scale != null) {
            decimalFieldCfg.setScale(scale);
        }
        if (zeroShow != null) {
            decimalFieldCfg.setZeroShow(zeroShow);
        }
        if (defValue != null) {
            decimalFieldCfg.setDefValue(BigDecimal.valueOf(defValue));
        }
        decimalFieldCfg.setDataScope(dataScope);
        if (noDisplayScaleZero != null) {
            decimalFieldCfg.setNoDisplayScaleZero(noDisplayScaleZero);
        }
        if (enableNull != null) {
            decimalFieldCfg.setEnableNull(enableNull);
        }
    }

    private static void setCommonProperty(FieldApCfg fieldApCfg, DynamicObject field, Map<String, String> fNumberIdMap) {
        String fieldNumber = field.getString("fieldnumber");
        String fieldName = field.getString("fieldname");
        Boolean isVisible = field.getBoolean("isvisible");
        Boolean isMust = field.getBoolean("ismust");
        Boolean isPreset = field.getBoolean("ispreset");
        fieldApCfg.setHidden(isVisible == false);
        fieldApCfg.setMustInput(isMust);
        fieldApCfg.setKey(fieldNumber);
        fieldApCfg.setPreset(isPreset);
        if (isPreset.booleanValue()) {
            fieldApCfg.setId(field.getString("fieldapid"));
        }
        fieldApCfg.setName(WorkBillConfigDTOBuilder.convert2LocaleName(fieldName));
        String fieldProperty = field.getString("fieldpropertyjson_tag");
        JSONObject jsonObject = JSONObject.parseObject((String)fieldProperty);
        if (jsonObject == null) {
            return;
        }
        Boolean fireUpEvt = jsonObject.getBoolean("fireUpEvt");
        String lock = jsonObject.getString("lock");
        String visible = jsonObject.getString("visible");
        if (fireUpEvt != null) {
            fieldApCfg.setFireUpdEvt(fireUpEvt);
        }
        if (StringUtils.isNotEmpty((String)lock)) {
            fieldApCfg.setLock(lock);
        }
        if (StringUtils.isNotEmpty((String)visible)) {
            fieldApCfg.setVisible(visible);
        }
        fNumberIdMap.put(fieldNumber, fieldApCfg.getId());
    }

    private static void setRefProperty(Map<FieldApCfg, List<String>> fieldCfgFNumber, Map<String, String> fNumberIdMap) {
        for (Map.Entry<FieldApCfg, List<String>> entry : fieldCfgFNumber.entrySet()) {
            FieldApCfg fieldApCfg = entry.getKey();
            List<String> refNumbers = entry.getValue();
            if (fieldApCfg instanceof PriceFieldCfg) {
                ((PriceFieldCfg)fieldApCfg).setCurrencyFieldId(fNumberIdMap.get(refNumbers.get(0)));
                continue;
            }
            if (fieldApCfg instanceof AmountFieldCfg) {
                ((AmountFieldCfg)fieldApCfg).setCurrencyFieldId(fNumberIdMap.get(refNumbers.get(0)));
                continue;
            }
            if (fieldApCfg instanceof QtyFieldCfg) {
                ((QtyFieldCfg)fieldApCfg).setUnitFieldId(fNumberIdMap.get(refNumbers.get(0)));
                continue;
            }
            if (fieldApCfg instanceof UnitFieldCfg) {
                ((UnitFieldCfg)fieldApCfg).setMaterielFieldId(fNumberIdMap.get(refNumbers.get(0)));
                continue;
            }
            if (fieldApCfg instanceof AccountFieldCfg) {
                AccountFieldCfg accountFieldCfg = (AccountFieldCfg)fieldApCfg;
                accountFieldCfg.setRefPeriodFieldId(fNumberIdMap.get(refNumbers.get(0)));
                accountFieldCfg.setRefAcctTableFieldId(fNumberIdMap.get(refNumbers.get(1)));
                continue;
            }
            if (!(fieldApCfg instanceof AssistantFieldCfg)) continue;
            AssistantFieldCfg assistantFieldCfg = (AssistantFieldCfg)fieldApCfg;
            assistantFieldCfg.setAsstParentId(fNumberIdMap.get(refNumbers.get(0)));
        }
    }

    private static LocaleString convert2LocaleName(Object objName) {
        LocaleString formName;
        if (objName instanceof LocaleString) {
            formName = (LocaleString)objName;
        } else if (objName instanceof OrmLocaleValue) {
            HashMap<String, String> localNameMap = new HashMap<String, String>(16);
            for (String loId : ((OrmLocaleValue)objName).keySet()) {
                localNameMap.put(loId, ((OrmLocaleValue)objName).get((Object)loId));
            }
            formName = LocaleString.fromMap(localNameMap);
        } else {
            formName = new LocaleString("zh_CN", (String)objName);
        }
        return formName;
    }
}

