/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task;

import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.ssc.task.create.CreateTask4ExternalSystem;
import kd.ssc.task.create.CreateTask4Rule;
import kd.ssc.task.face.ERPSystem;
import kd.ssc.task.face.ICreateTask4ExternalSystem;
import kd.ssc.task.face.ICreateTask4Rule;
import kd.ssc.task.face.ImageFacade;
import kd.ssc.task.face.TaskFacade;
import kd.ssc.task.face.WorkFlowFacade;
import kd.ssc.task.ierp.ERPSystemImpl;
import kd.ssc.task.ierp.ImageFacadeImpl;
import kd.ssc.task.ierp.TaskFacadeImpl;
import kd.ssc.task.ierp.WorkFlowFacadeImpl;

@KSObject
public class ErpFactory {
    private static final Log log = LogFactory.getLog(ErpFactory.class);

    public static ERPSystem getErpSystem(String erpNumber) {
        return (ERPSystem)ErpFactory.getImplInstance(erpNumber, ERPSystem.class, ERPSystemImpl.class);
    }

    public static ImageFacade getImageFacade(String erpNumber) {
        return (ImageFacade)ErpFactory.getImplInstance(erpNumber, ImageFacade.class, ImageFacadeImpl.class);
    }

    @KSMethod
    public static TaskFacade getTaskFacade(String erpNumber) {
        return (TaskFacade)ErpFactory.getImplInstance(erpNumber, TaskFacade.class, TaskFacadeImpl.class);
    }

    public static WorkFlowFacade getWorkFlowFacade(String erpNumber) {
        return (WorkFlowFacade)ErpFactory.getImplInstance(erpNumber, WorkFlowFacade.class, WorkFlowFacadeImpl.class);
    }

    public static ICreateTask4Rule getCreateTask4Rule(String erpNumber) {
        return (ICreateTask4Rule)ErpFactory.getImplInstance(erpNumber, ICreateTask4Rule.class, CreateTask4Rule.class);
    }

    public static ICreateTask4ExternalSystem getCreateTask4ExternalSystem(String erpNumber) {
        return (ICreateTask4ExternalSystem)ErpFactory.getImplInstance(erpNumber, ICreateTask4ExternalSystem.class, CreateTask4ExternalSystem.class);
    }

    private static Object getImplInstance(String erpNumber, Class Interface, Class defaultImpl) {
        String impl;
        if (erpNumber != null && (impl = (String)DB.query((DBRoute)DBRoute.of((String)"ssc"), (String)"select fimplement from t_tk_sysinterface where finterface=? and ferpNumber=? ", (Object[])new Object[]{Interface.getName(), erpNumber}, e -> {
            if (e.next()) {
                return e.getString("fimplement");
            }
            return null;
        })) != null) {
            try {
                return Class.forName(impl).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e1) {
                log.error("\u83b7\u53d6\u5b9e\u4f8b\u5f02\u5e38\uff1a" + e1.getMessage(), (Throwable)e1);
            }
        }
        try {
            return defaultImpl.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e1) {
            log.error("\u83b7\u53d6\u5b9e\u4f8b\u5f02\u5e38\uff1a" + e1.getMessage(), (Throwable)e1);
            return null;
        }
    }
}

