/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class AlgUtil {
    public static double[] maxRemainder(double[] data, int precision) {
        if (data == null || data.length == 0 || precision < 0 || precision > 8) {
            return data;
        }
        double[] result = new double[data.length];
        double sum = Arrays.stream(data).sum();
        if (sum == 0.0) {
            for (int i = 0; i < result.length; ++i) {
                result[i] = 0.0;
            }
            return result;
        }
        double scale = Math.pow(10.0, precision);
        double percentScale = 100.0 * scale;
        double[] remainder = new double[data.length];
        for (int i = 0; i < data.length; ++i) {
            double value = data[i] * percentScale / sum;
            result[i] = Math.floor(value);
            remainder[i] = value - result[i];
        }
        for (double currentSum = Arrays.stream(result).sum(); currentSum < percentScale; currentSum += 1.0) {
            double max = -2.147483648E9;
            int inx = 0;
            for (int i = 0; i < remainder.length; ++i) {
                double v = remainder[i];
                if (!(max < v)) continue;
                max = v;
                inx = i;
            }
            int n = inx;
            result[n] = result[n] + 1.0;
            remainder[inx] = 0.0;
        }
        int i = 0;
        while (i < result.length) {
            int n = i++;
            result[n] = result[n] / scale;
        }
        return result;
    }

    public static <T> List<List<T>> splitList(List<T> list, int num) {
        int i;
        int size = list.size();
        int count = size / num + (size % num > 0 ? 1 : 0);
        ArrayList<List<T>> resList = new ArrayList<List<T>>(count);
        for (i = 0; i < count - 1; ++i) {
            List<T> subList = list.subList(i * num, (i + 1) * num);
            resList.add(subList);
        }
        resList.add(list.subList(i * num, size));
        return resList;
    }
}

