/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.workbill.field;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.util.StringUtils;
import kd.ssc.workbill.constant.BillManageConstant;
import kd.ssc.workbill.field.AbstractFieldPropService;

public class TextFieldPropService
extends AbstractFieldPropService {
    public TextFieldPropService() {
    }

    public TextFieldPropService(String formId, String closeCallBackKey) {
        super(formId, closeCallBackKey);
    }

    @Override
    public String getFieldPropertyJSON(Object returnData) {
        if (Objects.isNull(returnData)) {
            return null;
        }
        return JSON.toJSONString((Object)returnData);
    }

    @Override
    public String convertJSONToFieldProperty(String fieldPropJSON) {
        if (StringUtils.isEmpty((String)fieldPropJSON)) {
            return null;
        }
        JSONObject jsonObject = JSON.parseObject((String)fieldPropJSON);
        ArrayList propList = Lists.newArrayListWithExpectedSize((int)BillManageConstant.FIELD_PROPERTIES.length);
        for (String[] properties : BillManageConstant.FIELD_PROPERTIES) {
            propList.add(properties[1] + ":" + jsonObject.get((Object)properties[0]));
        }
        return propList.stream().collect(Collectors.joining(","));
    }

    @Override
    public void showFieldPropChooseView(IFormView billView, IDataModel dataModel, String pluginName) {
        FormShowParameter showParameter = this.createFormShowParameter(pluginName);
        showParameter.setCustomParam("fieldValue", billView.getModel().getValue("fieldpropertyjson_tag"));
        billView.showForm(showParameter);
    }
}

