/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.workbill.util;

import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;

public class ISCUtil {
    private static final String ISC_METADATA_SCHEMA = "isc_metadata_schema";
    private static final HashSet<String> needBuildProTypeSet = new HashSet();
    private static final HashMap<String, String> needBuildObjTypeConMap;
    private static final HashMap<String, String> iscObjectEntryKey;

    public static String getISCObjectPkType(long groupId, String objectNumber) {
        QFilter pkFilter;
        if (groupId == 0L || objectNumber == null || objectNumber.isEmpty()) {
            return "string";
        }
        QFilter filter = new QFilter("group", "=", (Object)groupId).and(new QFilter("number", "=", (Object)objectNumber));
        DynamicObjectCollection isc_metadata_schema = QueryServiceHelper.query((String)ISC_METADATA_SCHEMA, (String)"prop_entryentity.prop_name prop_name,prop_entryentity.data_type data_type", (QFilter[])new QFilter[]{filter, pkFilter = new QFilter("prop_entryentity.is_primary_key", "=", (Object)Boolean.TRUE)});
        if (isc_metadata_schema.size() > 0) {
            return ((DynamicObject)isc_metadata_schema.get(0)).getString("data_type");
        }
        return "string";
    }

    public static List<DynamicObject> buildISCObject(DynamicObject dependISCObject, DynamicObject resultISCObject, long resultGroupId, String fullName) {
        DynamicObject result;
        ArrayList<DynamicObject> results = new ArrayList<DynamicObject>();
        if (dependISCObject == null) {
            return results;
        }
        String iscType = dependISCObject.getString("type");
        if (resultISCObject == null) {
            result = BusinessDataServiceHelper.newDynamicObject((String)ISC_METADATA_SCHEMA);
            result.set("group", (Object)resultGroupId);
            result.set("number", dependISCObject.get("number"));
            result.set("name", dependISCObject.get("name"));
            ISCUtil.setISCObjectBaseInfo(result, iscType);
        } else {
            result = resultISCObject;
        }
        result.set("full_name", (Object)fullName);
        long dependGroupId = dependISCObject.getLong("group.id");
        String entryKey = iscObjectEntryKey.get(iscType);
        DynamicObjectCollection propColl = "ENTITY".equals(iscType) ? ISCUtil.getPropColl(dependISCObject) : ISCUtil.getValueByEntryKey(dependISCObject, entryKey);
        result.set(entryKey, (Object)propColl);
        results.add(result);
        if (!"prop_entryentity".equalsIgnoreCase(entryKey)) {
            return results;
        }
        List needConvertDyo = propColl.stream().filter(p -> needBuildProTypeSet.contains(p.getString("data_type"))).collect(Collectors.toList());
        if (needConvertDyo.size() > 0) {
            for (DynamicObject convert : needConvertDyo) {
                String iscObjectNumber = convert.getString("data_schema");
                DynamicObject iscObjectD = ISCUtil.findISCObjectByNumber(dependGroupId, iscObjectNumber);
                if (iscObjectD == null) continue;
                String subFullName = fullName + "." + convert.getString("prop_name");
                DynamicObject iscObjectR = ISCUtil.findISCObjectByNumber(resultGroupId, iscObjectNumber);
                List<DynamicObject> dynamicObjects = ISCUtil.buildISCObject(iscObjectD, iscObjectR, resultGroupId, subFullName);
                results.addAll(dynamicObjects);
            }
        }
        return results;
    }

    public static List<DynamicObject> buildISCObject(DynamicObject dependISCObject, DynamicObject resultISCObject, long resultGroupId, String fullName, String isv_prefix) {
        DynamicObject result;
        ArrayList<DynamicObject> results = new ArrayList<DynamicObject>();
        if (dependISCObject == null) {
            return results;
        }
        String iscType = dependISCObject.getString("type");
        if (resultISCObject == null) {
            result = BusinessDataServiceHelper.newDynamicObject((String)ISC_METADATA_SCHEMA);
            result.set("group", (Object)resultGroupId);
            result.set("number", dependISCObject.get("number"));
            result.set("name", dependISCObject.get("name"));
            ISCUtil.setISCObjectBaseInfo(result, iscType);
        } else {
            result = resultISCObject;
        }
        result.set("full_name", (Object)fullName);
        long dependGroupId = dependISCObject.getLong("group.id");
        String entryKey = iscObjectEntryKey.get(iscType);
        DynamicObjectCollection propColl = "ENTITY".equals(iscType) ? ISCUtil.getPropColl(dependISCObject, isv_prefix) : ISCUtil.getValueByEntryKey(dependISCObject, entryKey);
        result.set(entryKey, (Object)propColl);
        results.add(result);
        if (!"prop_entryentity".equalsIgnoreCase(entryKey)) {
            return results;
        }
        List needConvertDyo = propColl.stream().filter(p -> needBuildProTypeSet.contains(p.getString("data_type"))).collect(Collectors.toList());
        if (needConvertDyo.size() > 0) {
            for (DynamicObject convert : needConvertDyo) {
                String iscObjectNumber = convert.getString("data_schema");
                DynamicObject iscObjectD = ISCUtil.findISCObjectByNumber(dependGroupId, iscObjectNumber);
                if (iscObjectD == null) continue;
                String subFullName = fullName + "." + convert.getString("prop_name");
                DynamicObject iscObjectR = ISCUtil.findISCObjectByNumber(resultGroupId, iscObjectNumber);
                List<DynamicObject> dynamicObjects = ISCUtil.buildISCObject(iscObjectD, iscObjectR, resultGroupId, subFullName, isv_prefix);
                results.addAll(dynamicObjects);
            }
        }
        return results;
    }

    public static void setISCObjectBaseInfo(DynamicObject iscObject, String type) {
        iscObject.set("type", (Object)needBuildObjTypeConMap.getOrDefault(type, type));
        iscObject.set("status", (Object)"A");
        iscObject.set("enable", (Object)"1");
        iscObject.set("state", (Object)"Z");
        iscObject.set("is_init", (Object)Boolean.TRUE);
        iscObject.set("creator", (Object)RequestContext.get().getCurrUserId());
        iscObject.set("createtime", (Object)Timestamp.valueOf(LocalDateTime.now()));
    }

    public static DynamicObjectCollection getPropColl(DynamicObject iscObject) {
        CloneUtils cloneUtils = new CloneUtils(true, true);
        DynamicObject cloneTargetObject = (DynamicObject)cloneUtils.clone((IDataEntityBase)iscObject);
        DynamicObjectCollection props = cloneTargetObject.getDynamicObjectCollection(iscObjectEntryKey.get("ENTITY"));
        props.removeIf(p -> "bos_attachment".equals(p.getString("data_schema")));
        long dependGroupId = iscObject.getLong("group.id");
        HashMap<String, String> hasSelected = new HashMap<String, String>();
        for (DynamicObject prop : props) {
            String data_type = prop.getString("data_type");
            if (!"REF".equalsIgnoreCase(data_type)) continue;
            String iscObjectNumber = prop.getString("data_schema");
            if (hasSelected.containsKey(iscObjectNumber)) {
                prop.set("data_type", hasSelected.get(iscObjectNumber));
            } else {
                String pkType = ISCUtil.getISCObjectPkType(dependGroupId, iscObjectNumber);
                hasSelected.put(iscObjectNumber, pkType);
                prop.set("data_type", (Object)pkType);
            }
            prop.set("data_schema", (Object)"");
        }
        return props;
    }

    public static DynamicObjectCollection getPropColl(DynamicObject iscObject, String isvPrefix) {
        CloneUtils cloneUtils = new CloneUtils(true, true);
        DynamicObject cloneTargetObject = (DynamicObject)cloneUtils.clone((IDataEntityBase)iscObject);
        DynamicObjectCollection props = cloneTargetObject.getDynamicObjectCollection(iscObjectEntryKey.get("ENTITY"));
        props.removeIf(p -> "bos_attachment".equals(p.getString("data_schema")));
        long dependGroupId = iscObject.getLong("group.id");
        HashMap<String, String> hasSelected = new HashMap<String, String>();
        for (DynamicObject prop : props) {
            String data_type = prop.getString("data_type");
            if ("REF".equalsIgnoreCase(data_type)) {
                String iscObjectNumber = prop.getString("data_schema");
                if (hasSelected.containsKey(iscObjectNumber)) {
                    prop.set("data_type", hasSelected.get(iscObjectNumber));
                } else {
                    String pkType = ISCUtil.getISCObjectPkType(dependGroupId, iscObjectNumber);
                    hasSelected.put(iscObjectNumber, pkType);
                    prop.set("data_type", (Object)pkType);
                }
                prop.set("data_schema", (Object)"");
            }
            if (!StringUtils.isNotEmpty((String)isvPrefix)) continue;
            prop.set("prop_name", (Object)ISCUtil.amendNumber(prop.getString("prop_name"), isvPrefix));
        }
        return props;
    }

    private static String amendNumber(String original, String isvPrefix) {
        if (original.startsWith(isvPrefix) && !original.equals(isvPrefix)) {
            original = original.replace(isvPrefix, "");
        }
        return original;
    }

    public static DynamicObject findISCObjectByNumber(Long groupId, String number) {
        QFilter qFilter = new QFilter("group", "=", (Object)groupId).and("number", "=", (Object)number);
        return BusinessDataServiceHelper.loadSingleFromCache((String)ISC_METADATA_SCHEMA, (QFilter[])new QFilter[]{qFilter});
    }

    private static DynamicObjectCollection getValueByEntryKey(DynamicObject iscObject, String entryKey) {
        CloneUtils cloneUtils = new CloneUtils(true, true);
        DynamicObject cloneTargetObject = (DynamicObject)cloneUtils.clone((IDataEntityBase)iscObject);
        return cloneTargetObject.getDynamicObjectCollection(entryKey);
    }

    static {
        needBuildProTypeSet.add("ENTRIES");
        needBuildProTypeSet.add("ENUM");
        needBuildObjTypeConMap = new HashMap();
        needBuildObjTypeConMap.put("ENTITY", "STRUCT");
        iscObjectEntryKey = new HashMap();
        iscObjectEntryKey.put("ENTITY", "prop_entryentity");
        iscObjectEntryKey.put("STRUCT", "prop_entryentity");
        iscObjectEntryKey.put("ENUM", "consts_entryentity");
    }
}

