/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.approveRebuild.helper;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ssc.enums.TaskStateEnum;
import kd.ssc.enums.approveRebuild.MsgTypeEnum;
import kd.ssc.exception.ExceptionPlatformUtil;
import kd.ssc.task.common.TaskApprevalUtil;
import kd.ssc.task.common.workcalendar.CalRemainingTime;
import kd.ssc.task.formplugin.util.WithdrawalSelectorUtil;
import kd.ssc.task.workcalendar.pojo.RemainingTimeInfo;

public class TaskApproveFailureHelper {
    private static final Log log = LogFactory.getLog(TaskApproveFailureHelper.class);

    public static Map<String, Object> getFailureResult(String msg) {
        return TaskApproveFailureHelper.getFailureResult("SSC_400", msg, MsgTypeEnum.WARN);
    }

    public static Map<String, Object> getFailureResult(String errCode, String msg) {
        return TaskApproveFailureHelper.getFailureResult(errCode, msg, MsgTypeEnum.WARN);
    }

    public static Map<String, Object> getFailureResult(String errCode, String msg, MsgTypeEnum msgType) {
        return TaskApproveFailureHelper.getFailureResult(errCode, msg, msgType, null);
    }

    public static Map<String, Object> getFailureResult(String errCode, String msg, MsgTypeEnum msgType, Map<String, Object> data) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(8);
        resultMap.put("success", "false");
        resultMap.put("errCode", errCode);
        resultMap.put("msg", msg);
        resultMap.put("msgType", msgType.getValue());
        resultMap.put("data", data);
        return resultMap;
    }

    public static void saveExceptionInfo2DB(Exception e, String keyInfo) {
        try (TXHandle tx = TX.requiresNew((String)"ssc_taskApproval_saveExcInfo");){
            try {
                ExceptionPlatformUtil.saveErrorInfo((String)TaskApprevalUtil.class.getName(), (String)"doApproveOperation/autoDoApproveOperation", (String)keyInfo, (Throwable)e);
            }
            catch (Exception ex) {
                log.warn("kd.ssc.task.approveRebuild.helper.TaskApproveFailureHelper.saveExceptionInfo2DB() excute failed! ", (Throwable)ex);
            }
        }
    }

    public static void deleteUnPassResion(Long taskid) {
        WithdrawalSelectorUtil utils = new WithdrawalSelectorUtil();
        try (TXHandle th = TX.requiresNew();){
            try {
                utils.deleteTaskWithdrawalUnpassById(taskid);
                utils.deleteTaskUnpass(" ", taskid);
            }
            catch (Exception excption) {
                th.markRollback();
            }
        }
    }

    public static Object[] processCurTask(Long taskId, DynamicObjectCollection taskList, String opinion, String withdrawal, String innerMsg) {
        HashSet<Long> pkList = new HashSet<Long>();
        Object[] keys = new Object[]{};
        for (DynamicObject task : taskList) {
            Long taskIdTmp = task.getLong("taskid");
            if (pkList.contains(taskIdTmp)) continue;
            pkList.add(taskIdTmp);
            if (!taskId.equals(taskIdTmp)) continue;
            keys = TaskApproveFailureHelper.insertTaskHistoryAndStateChangeHis(taskIdTmp, Integer.parseInt(TaskStateEnum.AUDIT_NOTPASSED.getValue()), opinion, withdrawal, innerMsg);
        }
        QFilter qFilter = new QFilter("id", "in", pkList);
        DeleteServiceHelper.delete((String)"task_task", (QFilter[])new QFilter[]{qFilter});
        return keys;
    }

    private static Object[] insertTaskHistoryAndStateChangeHis(long taskId, int state, String opinion, String withdrawal, String innerMsg) {
        DynamicObject[] hisTasks;
        Object[] result;
        QFilter fiterTaskId = new QFilter("id", "=", (Object)taskId);
        String selectFields = "id,billno,resttime,billnumber,orgid,usergroup,costwaittime,billtype,tasktypeid,sscid,creator,subject,state,innermsg,apprevalmessage,taskcreatetime,imageuploadtime,receivetime,completetime,personid,tasklevelid,imageok,flagmsg,autoprocess,pooltype,expirestate,bizdata_tag,billid,procinstid,coefficient,unpassreasondesc,qualitysamplelibrary,qualitystate,orignalperson,reformperson,qualityresult,qualitychecktime\uff0csysbillid,multistate,level,extenderp,source,auditor,assignid,oldtaskstate,recyclestate,unpassreasonid,info,consignerid,flowbackstgid,waittime,pausewaittime,rescanwaittime,allocatecount,islastaudit,hasallocated,createruleid,imagenumber,reverseoprt,oprt,orglongnumber,sourcetaskid,autoprocessforcheck,decisionitem,pendingopinion,rescanopinion,firstreceivetime,billlongid";
        DynamicObject taskData = BusinessDataServiceHelper.loadSingle((String)"task_task", (String)selectFields, (QFilter[])new QFilter[]{fiterTaskId});
        DynamicObject historyTask = BusinessDataServiceHelper.newDynamicObject((String)"task_taskhistory");
        historyTask.set("sourcetaskid", (Object)taskId);
        historyTask.set("state", (Object)state);
        historyTask.set("billnumber", taskData.get("billnumber"));
        historyTask.set("subject", taskData.get("subject"));
        historyTask.set("innermsg", (Object)innerMsg);
        historyTask.set("apprevalmessage", (Object)(opinion.length() > 2000 ? opinion.substring(0, 2000) : opinion));
        historyTask.set("decisionitem", (Object)"3");
        historyTask.set("unpassreasondesc", (Object)withdrawal);
        historyTask.set("receivetime", taskData.get("receivetime"));
        historyTask.set("firstreceivetime", taskData.get("firstreceivetime"));
        historyTask.set("completetime", (Object)new Date());
        historyTask.set("personid", taskData.get("personid"));
        historyTask.set("tasklevelid", taskData.get("tasklevelid"));
        historyTask.set("usergroup", taskData.get("usergroup"));
        historyTask.set("imageok", taskData.get("imageok"));
        historyTask.set("flagmsg", taskData.get("flagmsg"));
        historyTask.set("autoprocess", taskData.get("autoprocess"));
        historyTask.set("pooltype", (Object)2);
        historyTask.set("creator", taskData.get("creator"));
        historyTask.set("sscid", taskData.get("sscid"));
        historyTask.set("tasktypeid", taskData.get("tasktypeid"));
        historyTask.set("billtype", taskData.get("billtype"));
        historyTask.set("orgid", taskData.get("orgid"));
        historyTask.set("taskcreatetime", taskData.get("taskcreatetime"));
        historyTask.set("imageuploadtime", taskData.get("imageuploadtime"));
        historyTask.set("bizdata_tag", taskData.get("bizdata_tag"));
        historyTask.set("billid", taskData.get("billid"));
        historyTask.set("billlongid", taskData.get("billlongid"));
        historyTask.set("procinstid", taskData.get("procinstid"));
        historyTask.set("coefficient", taskData.get("coefficient"));
        historyTask.set("unpassreasondesc", taskData.get("unpassreasondesc"));
        historyTask.set("imagenumber", taskData.get("imagenumber"));
        historyTask.set("iscalculated", (Object)"0");
        historyTask.set("assignid", taskData.get("assignid"));
        historyTask.set("orglongnumber", taskData.get("orglongnumber"));
        CalRemainingTime cal = new CalRemainingTime();
        RemainingTimeInfo remainingTimeInfo = cal.calCompletedTimeNoDB(Collections.singletonList(taskId)).get(taskId);
        if (remainingTimeInfo != null) {
            historyTask.set("costwaittime", (Object)remainingTimeInfo.getCostWorkTime());
            historyTask.set("resttime", (Object)remainingTimeInfo.getReminderTime());
            historyTask.set("waittime", (Object)remainingTimeInfo.getWaitTime());
            historyTask.set("expirestate", (Object)remainingTimeInfo.getExpireState());
            historyTask.set("firstcostwaittime", (Object)remainingTimeInfo.getFirstCostWorkTime());
        }
        if ((result = SaveServiceHelper.save((DynamicObject[])(hisTasks = new DynamicObject[]{historyTask}))).length > 0) {
            DynamicObject stateChange = TaskApprevalUtil.createStateChange4ReturnSsc(taskData, historyTask);
            TaskApprevalUtil.insertDataToHistoryState(taskData.getLong("id"), ((DynamicObject)result[0]).getLong("id"), stateChange, true);
        }
        return result;
    }
}

